/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.stream;

import java.util.ArrayList;
import java.util.Iterator;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.IDataSetConsumer;

public class BufferedConsumer
implements IDataSetConsumer {
    private IDataSetConsumer _wrappedConsumer;
    private ITableMetaData _activeMetaData;
    private ArrayList _allRows = new ArrayList();

    public BufferedConsumer(IDataSetConsumer wrappedConsumer) {
        if (wrappedConsumer == null) {
            throw new NullPointerException("The parameter '_wrappedConsumer' must not be null");
        }
        this._wrappedConsumer = wrappedConsumer;
    }

    public void startDataSet() throws DataSetException {
        this._wrappedConsumer.startDataSet();
    }

    public void endDataSet() throws DataSetException {
        this._wrappedConsumer.endDataSet();
    }

    public void row(Object[] values) throws DataSetException {
        this._allRows.add(values);
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        this._activeMetaData = metaData;
    }

    public void endTable() throws DataSetException {
        Object[] rowValues;
        if (this._activeMetaData == null) {
            throw new IllegalStateException("The field _activeMetaData must not be null at this stage");
        }
        Column[] columns = this._activeMetaData.getColumns();
        int finalColumnCount = columns.length;
        int rowCount = this._allRows.size();
        for (int i = 0; i < rowCount; ++i) {
            rowValues = (Object[])this._allRows.get(i);
            if (rowValues.length >= finalColumnCount) continue;
            Object[] newRowValues = new Object[finalColumnCount];
            System.arraycopy(rowValues, 0, newRowValues, 0, rowValues.length);
            this._allRows.set(i, newRowValues);
        }
        this._wrappedConsumer.startTable(this._activeMetaData);
        Iterator iterator = this._allRows.iterator();
        while (iterator.hasNext()) {
            rowValues = (Object[])iterator.next();
            this._wrappedConsumer.row(rowValues);
        }
        this._wrappedConsumer.endTable();
    }
}

