/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.ArrayList;
import java.util.Arrays;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceTableFilter
implements ITableFilter {
    private static final Logger logger = LoggerFactory.getLogger((Class)SequenceTableFilter.class);
    private final String[] _tableNames;

    public SequenceTableFilter(String[] tableNames) {
        this._tableNames = tableNames;
    }

    private boolean accept(String tableName, String[] tableNames, boolean verifyDuplicate) throws AmbiguousTableNameException {
        if (logger.isDebugEnabled()) {
            logger.debug("accept(tableName={}, tableNames={}, verifyDuplicate={}) - start", new Object[]{tableName, tableNames, new Boolean(verifyDuplicate)});
        }
        boolean found = false;
        for (int i = 0; i < tableNames.length; ++i) {
            if (!tableName.equalsIgnoreCase(tableNames[i])) continue;
            if (!verifyDuplicate) {
                return true;
            }
            if (found) {
                throw new AmbiguousTableNameException(tableName);
            }
            found = true;
        }
        return found;
    }

    public boolean accept(String tableName) throws DataSetException {
        logger.debug("accept(tableName={}) - start", (Object)tableName);
        return this.accept(tableName, this._tableNames, true);
    }

    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getTableNames(dataSet={}) - start", (Object)dataSet);
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = 0; i < this._tableNames.length; ++i) {
            try {
                ITableMetaData metaData = dataSet.getTableMetaData(this._tableNames[i]);
                nameList.add(metaData.getTableName());
                continue;
            }
            catch (NoSuchTableException e) {
                // empty catch block
            }
        }
        return nameList.toArray(new String[0]);
    }

    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("iterator(dataSet={}, reversed={}) - start", (Object)dataSet, (Object)new Boolean(reversed));
        }
        String[] tableNames = this.getTableNames(dataSet);
        return new SequenceTableIterator(reversed ? DataSetUtils.reverseStringArray(tableNames) : tableNames, dataSet);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("tableNames=").append(this._tableNames == null ? "null" : Arrays.asList(this._tableNames).toString());
        sb.append("]");
        return sb.toString();
    }
}

