/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import org.dbunit.dataset.datatype.NumberDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberTolerantDataType
extends NumberDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)NumberTolerantDataType.class);
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private double delta;

    NumberTolerantDataType(String name, int sqlType, double delta) {
        super(name, sqlType);
        if (delta < 0.0) {
            throw new IllegalArgumentException("The given delta '" + delta + "' must be >= 0");
        }
        this.delta = delta;
    }

    public double getDelta() {
        return this.delta;
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        logger.debug("compare(o1={}, o2={}) - start", o1, o2);
        try {
            Comparable value1 = (Comparable)this.typeCast(o1);
            Comparable value2 = (Comparable)this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            if (value1 instanceof BigDecimal && value2 instanceof BigDecimal) {
                BigDecimal bdValue1 = (BigDecimal)value1;
                BigDecimal bdValue2 = (BigDecimal)value2;
                BigDecimal diff = bdValue1.subtract(bdValue2);
                if (diff.compareTo(ZERO) == 0) {
                    return 0;
                }
                if (Math.abs(diff.doubleValue()) <= this.delta) {
                    logger.debug("Values val1={}, val2={} differ but are within tolerated delta {}", new Object[]{bdValue1, bdValue2, new Double(this.delta)});
                    return 0;
                }
                return diff.signum();
            }
            return value1.compareTo(value2);
        }
        catch (ClassCastException e) {
            throw new TypeCastException(e);
        }
    }
}

