/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv.handlers;

import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.Helper;
import org.dbunit.dataset.csv.handlers.Pipeline;
import org.dbunit.dataset.csv.handlers.PipelineComponent;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineComponent
implements PipelineComponent {
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractPipelineComponent.class);
    private PipelineComponent successor;
    private Pipeline pipeline;
    private Helper helper;

    protected PipelineComponent getSuccessor() {
        return this.successor;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        logger.debug("setPipeline(pipeline={}) - start", (Object)pipeline);
        this.pipeline = pipeline;
    }

    public void setSuccessor(PipelineComponent successor) {
        logger.debug("setSuccessor(successor={}) - start", (Object)successor);
        this.successor = successor;
    }

    private StringBuffer getThePiece() {
        return this.getPipeline().getCurrentProduct();
    }

    public void handle(char c) throws IllegalInputCharacterException, PipelineException {
        logger.debug("handle(c=" + c + ") - start");
        if (!this.canHandle(c)) {
            this.getSuccessor().handle(c);
        } else {
            this.getHelper().helpWith(c);
        }
    }

    public void noMoreInput() {
        logger.debug("noMoreInput() - start");
        if (this.allowForNoMoreInput() && this.getSuccessor() != null) {
            this.getSuccessor().noMoreInput();
        }
    }

    public boolean allowForNoMoreInput() {
        logger.debug("allowForNoMoreInput() - start");
        return this.getHelper().allowForNoMoreInput();
    }

    protected static PipelineComponent createPipelineComponent(AbstractPipelineComponent handler, Helper helper) {
        logger.debug("createPipelineComponent(handler={}, helper={}) - start", (Object)handler, (Object)helper);
        helper.setHandler(handler);
        handler.setHelper(helper);
        return handler;
    }

    public void accept(char c) {
        this.getThePiece().append(c);
    }

    protected Helper getHelper() {
        return this.helper;
    }

    private void setHelper(Helper helper) {
        logger.debug("setHelper(helper={}) - start", (Object)helper);
        this.helper = helper;
    }

    protected static class ACCEPT
    extends Helper {
        protected ACCEPT() {
        }

        public void helpWith(char c) {
            logger.debug("helpWith(c={}) - start", (Object)String.valueOf(c));
            this.getHandler().accept(c);
        }
    }

    protected static class IGNORE
    extends Helper {
        protected IGNORE() {
        }

        public void helpWith(char c) {
        }
    }
}

