/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.SortedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)SortedDataSet.class);
    private final IDataSet _dataSet;

    public SortedDataSet(IDataSet dataSet) throws DataSetException {
        this._dataSet = dataSet;
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        return new SortedIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        return this._dataSet.getTableNames();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        return this._dataSet.getTableMetaData(tableName);
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        return new SortedTable(this._dataSet.getTable(tableName));
    }

    private class SortedIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public SortedIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            return new SortedTable(this._iterator.getTable());
        }
    }
}

