/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.ResultSetTableMetaData;
import org.dbunit.dataset.AbstractTableMetaData;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.util.QualifiedTableName;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseTableMetaData
extends AbstractTableMetaData {
    private static final Logger logger = LoggerFactory.getLogger((Class)DatabaseTableMetaData.class);
    private final String _tableName;
    private final QualifiedTableName _qualifiedTableNameSupport;
    private final IDatabaseConnection _connection;
    private Column[] _columns;
    private Column[] _primaryKeys;

    DatabaseTableMetaData(String tableName, IDatabaseConnection connection) throws DataSetException {
        this(tableName, connection, true);
    }

    DatabaseTableMetaData(String tableName, IDatabaseConnection connection, boolean validate) throws DataSetException {
        block6: {
            if (tableName == null) {
                throw new NullPointerException("The parameter 'tableName' must not be null");
            }
            if (connection == null) {
                throw new NullPointerException("The parameter 'connection' must not be null");
            }
            this._tableName = tableName;
            this._connection = connection;
            this._qualifiedTableNameSupport = new QualifiedTableName(this._tableName, this._connection.getSchema());
            if (validate) {
                String schemaName = this._qualifiedTableNameSupport.getSchema();
                String plainTableName = this._qualifiedTableNameSupport.getTable();
                logger.debug("Validating if table '" + plainTableName + "' exists in schema '" + schemaName + "' ...");
                try {
                    DatabaseMetaData databaseMetaData = connection.getConnection().getMetaData();
                    if (!SQLHelper.tableExists(databaseMetaData, schemaName, plainTableName)) {
                        throw new NoSuchTableException("Did not find table '" + plainTableName + "' in schema '" + schemaName + "'");
                    }
                    break block6;
                }
                catch (SQLException e) {
                    throw new DataSetException("Exception while validation existence of table '" + plainTableName + "'", e);
                }
            }
            logger.debug("Validation switched off. Will not check if table exists.");
        }
    }

    public static ITableMetaData createMetaData(String tableName, ResultSet resultSet, IDataTypeFactory dataTypeFactory) throws DataSetException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("createMetaData(tableName={}, resultSet={}, dataTypeFactory={}) - start", new Object[]{tableName, resultSet, dataTypeFactory});
        }
        return new ResultSetTableMetaData(tableName, resultSet, dataTypeFactory);
    }

    public static ITableMetaData createMetaData(String tableName, ResultSet resultSet, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createMetaData(tableName={}, resultSet={}, connection={}) - start", new Object[]{tableName, resultSet, connection});
        }
        return new ResultSetTableMetaData(tableName, resultSet, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getPrimaryKeyNames() throws SQLException {
        logger.debug("getPrimaryKeyNames() - start");
        String schemaName = this._qualifiedTableNameSupport.getSchema();
        String tableName = this._qualifiedTableNameSupport.getTable();
        Connection connection = this._connection.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, schemaName, tableName);
        ArrayList<PrimaryKeyData> list = new ArrayList<PrimaryKeyData>();
        try {
            while (resultSet.next()) {
                String name = resultSet.getString(4);
                int sequence = resultSet.getInt(5);
                list.add(new PrimaryKeyData(name, sequence));
            }
        }
        finally {
            resultSet.close();
        }
        Collections.sort(list);
        String[] keys = new String[list.size()];
        for (int i = 0; i < keys.length; ++i) {
            PrimaryKeyData data = (PrimaryKeyData)list.get(i);
            keys[i] = data.getName();
        }
        return keys;
    }

    public String getTableName() {
        return this._tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns() throws DataSetException {
        logger.debug("getColumns() - start");
        if (this._columns == null) {
            try {
                String schemaName = this._qualifiedTableNameSupport.getSchema();
                String tableName = this._qualifiedTableNameSupport.getTable();
                Connection jdbcConnection = this._connection.getConnection();
                DatabaseMetaData databaseMetaData = jdbcConnection.getMetaData();
                ResultSet resultSet = databaseMetaData.getColumns(null, schemaName, tableName, "%");
                try {
                    DatabaseConfig config = this._connection.getConfig();
                    IDataTypeFactory dataTypeFactory = super.getDataTypeFactory(this._connection);
                    boolean datatypeWarning = config.getFeature("http://www.dbunit.org/features/datatypeWarning");
                    ArrayList<Column> columnList = new ArrayList<Column>();
                    while (resultSet.next()) {
                        String columnName = resultSet.getString(4);
                        int sqlType = resultSet.getInt(5);
                        String sqlTypeName = resultSet.getString(6);
                        int nullable = resultSet.getInt(11);
                        DataType dataType = dataTypeFactory.createDataType(sqlType, sqlTypeName, tableName, columnName);
                        if (dataType != DataType.UNKNOWN) {
                            Column column = new Column(columnName, dataType, sqlTypeName, Column.nullableValue(nullable));
                            columnList.add(column);
                            continue;
                        }
                        if (!datatypeWarning) continue;
                        logger.warn(tableName + "." + columnName + " data type (" + sqlType + ", '" + sqlTypeName + "') not recognized and will be ignored. See FAQ for more information.");
                    }
                    if (columnList.size() == 0) {
                        logger.warn("No columns found for table '" + tableName + "' that are supported by dbunit. " + "Will return an empty column list");
                    }
                    this._columns = columnList.toArray(new Column[0]);
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                throw new DataSetException(e);
            }
        }
        return this._columns;
    }

    public Column[] getPrimaryKeys() throws DataSetException {
        logger.debug("getPrimaryKeys() - start");
        if (this._primaryKeys == null) {
            try {
                DatabaseConfig config = this._connection.getConfig();
                IColumnFilter primaryKeysFilter = (IColumnFilter)config.getProperty("http://www.dbunit.org/properties/primaryKeyFilter");
                if (primaryKeysFilter != null) {
                    this._primaryKeys = Columns.getColumns(this.getTableName(), this.getColumns(), primaryKeysFilter);
                } else {
                    String[] pkNames = this.getPrimaryKeyNames();
                    this._primaryKeys = Columns.getColumns(pkNames, this.getColumns());
                }
            }
            catch (SQLException e) {
                throw new DataSetException(e);
            }
        }
        return this._primaryKeys;
    }

    public String toString() {
        try {
            String tableName = this.getTableName();
            String columns = Arrays.asList(this.getColumns()).toString();
            String primaryKeys = Arrays.asList(this.getPrimaryKeys()).toString();
            return "table=" + tableName + ", cols=" + columns + ", pk=" + primaryKeys + "";
        }
        catch (DataSetException e) {
            return super.toString();
        }
    }

    private class PrimaryKeyData
    implements Comparable {
        private final String _name;
        private final int _index;

        public PrimaryKeyData(String name, int index) {
            this._name = name;
            this._index = index;
        }

        public String getName() {
            logger.debug("getName() - start");
            return this._name;
        }

        public int getIndex() {
            return this._index;
        }

        public int compareTo(Object o) {
            PrimaryKeyData data = (PrimaryKeyData)o;
            return this.getIndex() - data.getIndex();
        }
    }
}

