/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseTableIterator;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.util.QualifiedTableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)DatabaseDataSet.class);
    private final IDatabaseConnection _connection;
    private final Map _tableMap = new HashMap();
    private List _nameList = null;

    DatabaseDataSet(IDatabaseConnection connection) throws SQLException {
        this._connection = connection;
    }

    static String getSelectStatement(String schema, ITableMetaData metaData, String escapePattern) throws DataSetException {
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug("getSelectStatement(schema={}, metaData={}, escapePattern={}) - start", new Object[]{schema, metaData, escapePattern});
        }
        Column[] columns = metaData.getColumns();
        Column[] primaryKeys = metaData.getPrimaryKeys();
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select ");
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sqlBuffer.append(", ");
            }
            String columnName = new QualifiedTableName(columns[i].getColumnName(), null, escapePattern).getQualifiedName();
            sqlBuffer.append(columnName);
        }
        sqlBuffer.append(" from ");
        sqlBuffer.append(new QualifiedTableName(metaData.getTableName(), schema, escapePattern).getQualifiedName());
        for (i = 0; i < primaryKeys.length; ++i) {
            if (i == 0) {
                sqlBuffer.append(" order by ");
            } else {
                sqlBuffer.append(", ");
            }
            sqlBuffer.append(new QualifiedTableName(primaryKeys[i].getColumnName(), null, escapePattern).getQualifiedName());
        }
        return sqlBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DataSetException {
        logger.debug("initialize() - start");
        if (this._nameList != null) {
            return;
        }
        try {
            Connection jdbcConnection = this._connection.getConnection();
            String schema = this._connection.getSchema();
            String[] tableType = (String[])this._connection.getConfig().getProperty("http://www.dbunit.org/properties/tableType");
            DatabaseMetaData databaseMetaData = jdbcConnection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, schema, "%", tableType);
            try {
                ArrayList<String> nameList = new ArrayList<String>();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString(2);
                    String tableName = resultSet.getString(3);
                    DatabaseConfig config = this._connection.getConfig();
                    if (config.getFeature("http://www.dbunit.org/features/skipOracleRecycleBinTables") && tableName.startsWith("BIN$")) continue;
                    QualifiedTableName qualifiedTableName = new QualifiedTableName(tableName, schemaName);
                    if (this._tableMap.containsKey((tableName = qualifiedTableName.getQualifiedNameIfEnabled(config)).toUpperCase())) {
                        throw new AmbiguousTableNameException(tableName);
                    }
                    nameList.add(tableName);
                    this._tableMap.put(tableName.toUpperCase(), null);
                }
                this._nameList = nameList;
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)new Boolean(reversed));
        String[] names = this.getTableNames();
        if (reversed) {
            names = DataSetUtils.reverseStringArray(names);
        }
        return new DatabaseTableIterator(names, this);
    }

    public String[] getTableNames() throws DataSetException {
        this.initialize();
        return this._nameList.toArray(new String[0]);
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        this.initialize();
        String upperTableName = tableName.toUpperCase();
        if (!this._tableMap.containsKey(upperTableName)) {
            throw new NoSuchTableException(tableName);
        }
        ITableMetaData metaData = (ITableMetaData)this._tableMap.get(upperTableName);
        if (metaData != null) {
            return metaData;
        }
        Iterator it = this._nameList.iterator();
        while (it.hasNext()) {
            String databaseTableName = (String)it.next();
            if (!databaseTableName.equalsIgnoreCase(tableName)) continue;
            metaData = new DatabaseTableMetaData(databaseTableName, this._connection);
            this._tableMap.put(upperTableName, metaData);
            break;
        }
        return metaData;
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        this.initialize();
        try {
            ITableMetaData metaData = this.getTableMetaData(tableName);
            DatabaseConfig config = this._connection.getConfig();
            IResultSetTableFactory factory = (IResultSetTableFactory)config.getProperty("http://www.dbunit.org/properties/resultSetTableFactory");
            return factory.createTable(metaData, this._connection);
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }
}

