/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.AbstractDatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnection
extends AbstractDatabaseConnection
implements IDatabaseConnection {
    private static final Logger logger = LoggerFactory.getLogger((Class)DatabaseConnection.class);
    private final Connection _connection;
    private final String _schema;

    public DatabaseConnection(Connection connection) throws DatabaseUnitException {
        this(connection, null);
    }

    public DatabaseConnection(Connection connection, String schema) throws DatabaseUnitException {
        this(connection, schema, false);
    }

    public DatabaseConnection(Connection connection, String schema, boolean validate) throws DatabaseUnitException {
        if (connection == null) {
            throw new NullPointerException("The parameter 'connection' must not be null");
        }
        this._connection = connection;
        this._schema = schema;
        this.printConnectionInfo();
        this.validateSchema(validate);
    }

    public Connection getConnection() throws SQLException {
        return this._connection;
    }

    public String getSchema() {
        return this._schema;
    }

    public void close() throws SQLException {
        logger.debug("close() - start");
        this._connection.close();
    }

    private void printConnectionInfo() {
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("Database connection info: " + SQLHelper.getDatabaseInfo(this._connection.getMetaData()));
            }
            catch (SQLException e) {
                logger.warn("Exception while trying to retrieve database info from connection", (Throwable)e);
            }
        }
    }

    private void validateSchema(boolean validateStrict) throws DatabaseUnitException {
        if (logger.isDebugEnabled()) {
            logger.debug("validateSchema(validateStrict={}) - start", (Object)String.valueOf(validateStrict));
        }
        if (this._schema == null) {
            logger.debug("Schema is null. Nothing to validate.");
            return;
        }
        try {
            boolean schemaExists = SQLHelper.schemaExists(this._connection, this._schema);
            if (!schemaExists) {
                String msg = "The given schema '" + this._schema + "' does not exist.";
                if (validateStrict) {
                    throw new DatabaseUnitException(msg);
                }
                logger.warn(msg);
            }
        }
        catch (SQLException e) {
            throw new DatabaseUnitException("Exception while checking the schema for validity", e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("schema=").append(this._schema);
        sb.append(", connection=").append(this._connection);
        sb.append(", super=").append(super.toString());
        sb.append("]");
        return sb.toString();
    }
}

