/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.SQLException;
import org.dbunit.database.CachedResultSetTable;
import org.dbunit.database.ForwardOnlyResultSetTable;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedResultSetTableFactory
implements IResultSetTableFactory {
    private static final Logger logger = LoggerFactory.getLogger((Class)CachedResultSetTableFactory.class);

    public IResultSetTable createTable(String tableName, String selectStatement, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createTable(tableName={}, selectStatement={}, connection={}) - start", new Object[]{tableName, selectStatement, connection});
        }
        return new CachedResultSetTable(new ForwardOnlyResultSetTable(tableName, selectStatement, connection));
    }

    public IResultSetTable createTable(ITableMetaData metaData, IDatabaseConnection connection) throws SQLException, DataSetException {
        logger.debug("createTable(metaData={}, connection={}) - start", (Object)metaData, (Object)connection);
        return new CachedResultSetTable(metaData, connection);
    }
}

