/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.CachedResultSetTable;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.ForwardOnlyResultSetTable;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.util.QualifiedTableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseConnection
implements IDatabaseConnection {
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractDatabaseConnection.class);
    private IDataSet _dataSet = null;
    private DatabaseConfig _databaseConfig = new DatabaseConfig();

    public IDataSet createDataSet() throws SQLException {
        logger.debug("createDataSet() - start");
        if (this._dataSet == null) {
            this._dataSet = new DatabaseDataSet(this);
        }
        return this._dataSet;
    }

    public IDataSet createDataSet(String[] tableNames) throws SQLException {
        logger.debug("createDataSet(tableNames={}) - start", (Object[])tableNames);
        return new FilteredDataSet(tableNames, this.createDataSet());
    }

    public ITable createQueryTable(String resultName, String sql) throws DataSetException, SQLException {
        logger.debug("createQueryTable(resultName={}, sql={}) - start", (Object)resultName, (Object)sql);
        ForwardOnlyResultSetTable rsTable = new ForwardOnlyResultSetTable(resultName, sql, this);
        return new CachedResultSetTable(rsTable);
    }

    public int getRowCount(String tableName) throws SQLException {
        logger.debug("getRowCount(tableName={}) - start", (Object)tableName);
        return this.getRowCount(tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String tableName, String whereClause) throws SQLException {
        logger.debug("getRowCount(tableName={}, whereClause={}) - start", (Object)tableName, (Object)whereClause);
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select count(*) from ");
        QualifiedTableName qualifiedTableName = new QualifiedTableName(tableName, this.getSchema());
        String qualifiedName = qualifiedTableName.getQualifiedName();
        sqlBuffer.append(qualifiedName);
        if (whereClause != null) {
            sqlBuffer.append(" ");
            sqlBuffer.append(whereClause);
        }
        Statement statement = this.getConnection().createStatement();
        try {
            int n;
            ResultSet resultSet = statement.executeQuery(sqlBuffer.toString());
            try {
                resultSet.next();
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return n;
        }
        finally {
            statement.close();
        }
    }

    public DatabaseConfig getConfig() {
        return this._databaseConfig;
    }

    public IStatementFactory getStatementFactory() {
        return (IStatementFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("_databaseConfig=").append(this._databaseConfig);
        sb.append(", _dataSet=").append(this._dataSet);
        return sb.toString();
    }
}

