/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.QuerySet;
import org.dbunit.ant.Table;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvDataSetWriter;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlWriter;
import org.dbunit.dataset.xml.XmlDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
extends AbstractStep {
    private static final Logger logger = LoggerFactory.getLogger((Class)Export.class);
    private File _dest;
    private String _format = "flat";
    private String _doctype = null;
    private boolean _ordered = false;
    private List _tables = new ArrayList();

    private String getAbsolutePath(File filename) {
        return filename != null ? filename.getAbsolutePath() : "null";
    }

    public File getDest() {
        return this._dest;
    }

    public String getFormat() {
        return this._format;
    }

    public List getTables() {
        return this._tables;
    }

    public void setDest(File dest) {
        logger.debug("setDest(dest={}) - start", (Object)dest);
        this._dest = dest;
    }

    public void setFormat(String format) {
        logger.debug("setFormat(format={}) - start", (Object)format);
        if (!(format.equalsIgnoreCase("flat") || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("dtd") || format.equalsIgnoreCase("csv"))) {
            throw new IllegalArgumentException("Type must be one of: 'flat'(default), 'xml', or 'dtd' but was: " + format);
        }
        this._format = format;
    }

    public boolean isOrdered() {
        return this._ordered;
    }

    public void setOrdered(boolean ordered) {
        this._ordered = ordered;
    }

    public void addTable(Table table) {
        logger.debug("addTable(table={}) - start", (Object)table);
        this._tables.add(table);
    }

    public void addQuery(Query query) {
        logger.debug("addQuery(query={}) - start", (Object)query);
        this._tables.add(query);
    }

    public void addQuerySet(QuerySet querySet) {
        logger.debug("addQuerySet(querySet={}) - start", (Object)querySet);
        this._tables.add(querySet);
    }

    public String getDoctype() {
        return this._doctype;
    }

    public void setDoctype(String doctype) {
        logger.debug("setDoctype(doctype={}) - start", (Object)doctype);
        this._doctype = doctype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        logger.debug("execute(connection={}) - start", (Object)connection);
        try {
            if (this._dest == null) {
                throw new DatabaseUnitException("'_dest' is a required attribute of the <export> step.");
            }
            IDataSet dataset = this.getExportDataSet(connection);
            this.log("dataset tables: " + Arrays.asList(dataset.getTableNames()), 3);
            if (this._format.equals("csv")) {
                CsvDataSetWriter.write(dataset, this._dest);
            } else {
                FileOutputStream out = new FileOutputStream(this._dest);
                try {
                    if (this._format.equalsIgnoreCase("flat")) {
                        FlatXmlWriter writer = new FlatXmlWriter(out);
                        writer.setDocType(this._doctype);
                        writer.write(dataset);
                    } else if (this._format.equalsIgnoreCase("xml")) {
                        XmlDataSet.write(dataset, out);
                    } else if (this._format.equalsIgnoreCase("dtd")) {
                        FlatDtdDataSet.write(dataset, out);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            this.log("Successfully wrote file '" + this._dest + "'", 2);
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
        catch (IOException e) {
            throw new DatabaseUnitException(e);
        }
    }

    protected IDataSet getExportDataSet(IDatabaseConnection connection) throws DatabaseUnitException, SQLException {
        IDataSet dataset = this.getDatabaseDataSet(connection, this._tables, false);
        if (this.isOrdered()) {
            DatabaseSequenceFilter filter = new DatabaseSequenceFilter(connection);
            dataset = new FilteredDataSet(filter, dataset);
        }
        return dataset;
    }

    public String getLogMessage() {
        return "Executing export: \n      in format: " + this._format + " to datafile: " + this.getAbsolutePath(this._dest);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Export: ");
        result.append(" dest=" + this.getAbsolutePath(this._dest));
        result.append(", format= " + this._format);
        result.append(", doctype= " + this._doctype);
        result.append(", tables= " + this._tables);
        return result.toString();
    }
}

