/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.Compare;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.ant.Export;
import org.dbunit.ant.Operation;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitTask
extends Task {
    private static final Logger logger = LoggerFactory.getLogger((Class)DbUnitTask.class);
    private Connection conn = null;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private String schema = null;
    private List steps = new ArrayList();
    private Path classpath;
    private AntClassLoader loader;
    private boolean useQualifiedTableNames = false;
    private boolean supportBatchStatement = false;
    private boolean datatypeWarning = true;
    private String escapePattern = null;
    private String dataTypeFactory = "org.dbunit.dataset.datatype.DefaultDataTypeFactory";
    private String batchSize = null;
    private String fetchSize = null;
    private boolean skipOracleRecycleBinTables = false;

    public void setDriver(String driver) {
        logger.debug("setDriver(driver={}) - start", (Object)driver);
        this.driver = driver;
    }

    public void setUrl(String url) {
        logger.debug("setUrl(url={}) - start", (Object)url);
        this.url = url;
    }

    public void setUserid(String userId) {
        logger.debug("setUserid(userId={}) - start", (Object)userId);
        this.userId = userId;
    }

    public void setPassword(String password) {
        logger.debug("setPassword(password=*****) - start");
        this.password = password;
    }

    public void setSchema(String schema) {
        logger.debug("setSchema(schema={}) - start", (Object)schema);
        this.schema = schema;
    }

    public void setUseQualifiedTableNames(boolean useQualifiedTableNames) {
        logger.debug("setUseQualifiedTableNames(useQualifiedTableNames={}) - start", (Object)new Boolean(useQualifiedTableNames));
        this.useQualifiedTableNames = useQualifiedTableNames;
    }

    public void setSupportBatchStatement(boolean supportBatchStatement) {
        logger.debug("setSupportBatchStatement(supportBatchStatement={}) - start", (Object)new Boolean(supportBatchStatement));
        this.supportBatchStatement = supportBatchStatement;
    }

    public void setDatatypeWarning(boolean datatypeWarning) {
        logger.debug("setDatatypeWarning(datatypeWarning={}) - start", (Object)new Boolean(datatypeWarning));
        this.datatypeWarning = datatypeWarning;
    }

    public void setDatatypeFactory(String datatypeFactory) {
        logger.debug("setDatatypeFactory(datatypeFactory={}) - start", (Object)datatypeFactory);
        this.dataTypeFactory = datatypeFactory;
    }

    public void setEscapePattern(String escapePattern) {
        logger.debug("setEscapePattern(escapePattern={}) - start", (Object)escapePattern);
        this.escapePattern = escapePattern;
    }

    public void setClasspath(Path classpath) {
        logger.debug("setClasspath(classpath={}) - start", (Object)classpath);
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        logger.debug("createClasspath() - start");
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        logger.debug("setClasspathRef(r={}) - start", (Object)r);
        this.createClasspath().setRefid(r);
    }

    public List getSteps() {
        return this.steps;
    }

    public void addOperation(Operation operation) {
        logger.debug("addOperation({}) - start", (Object)operation);
        this.steps.add(operation);
    }

    public void addCompare(Compare compare) {
        logger.debug("addCompare({}) - start", (Object)compare);
        this.steps.add(compare);
    }

    public void addExport(Export export) {
        logger.debug("addExport(export={}) - start", (Object)export);
        export.setParentTask(this);
        this.steps.add(export);
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(String fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isSkipOracleRecycleBinTables() {
        return this.skipOracleRecycleBinTables;
    }

    public void setSkipOracleRecycleBinTables(boolean skipOracleRecycleBinTables) {
        this.skipOracleRecycleBinTables = skipOracleRecycleBinTables;
    }

    public void execute() throws BuildException {
        logger.debug("execute() - start");
        try {
            IDatabaseConnection connection = this.createConnection();
            ListIterator stepIter = this.steps.listIterator();
            while (stepIter.hasNext()) {
                DbUnitTaskStep step = (DbUnitTaskStep)stepIter.next();
                this.log(step.getLogMessage(), 2);
                step.execute(connection);
            }
        }
        catch (DatabaseUnitException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("execute()", (Throwable)e);
            }
        }
    }

    IDatabaseConnection createConnection() throws SQLException {
        logger.debug("createConnection() - start");
        if (this.driver == null) {
            throw new BuildException("Driver attribute must be set!", this.getLocation());
        }
        if (this.userId == null) {
            throw new BuildException("User Id attribute must be set!", this.getLocation());
        }
        if (this.password == null) {
            throw new BuildException("Password attribute must be set!", this.getLocation());
        }
        if (this.url == null) {
            throw new BuildException("Url attribute must be set!", this.getLocation());
        }
        if (this.steps.size() == 0) {
            throw new BuildException("Must declare at least one step in a <dbunit> task!", this.getLocation());
        }
        Driver driverInstance = null;
        try {
            Class dc;
            if (this.classpath != null) {
                this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                this.loader = new AntClassLoader(this.getProject(), this.classpath);
                dc = this.loader.loadClass(this.driver);
            } else {
                this.log("Loading " + this.driver + " using system loader.", 3);
                dc = Class.forName(this.driver);
            }
            driverInstance = (Driver)dc.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        catch (InstantiationException e) {
            throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        this.log("connecting to " + this.url, 3);
        Properties info = new Properties();
        info.put("user", this.userId);
        info.put("password", this.password);
        this.conn = driverInstance.connect(this.url, info);
        if (this.conn == null) {
            throw new SQLException("No suitable Driver for " + this.url);
        }
        this.conn.setAutoCommit(true);
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(this.conn, this.schema);
        }
        catch (DatabaseUnitException e) {
            throw new BuildException("Could not create dbunit connection object", (Throwable)e);
        }
        DatabaseConfig config = connection.getConfig();
        config.setFeature("http://www.dbunit.org/features/batchedStatements", this.supportBatchStatement);
        config.setFeature("http://www.dbunit.org/features/qualifiedTableNames", this.useQualifiedTableNames);
        config.setFeature("http://www.dbunit.org/features/datatypeWarning", this.datatypeWarning);
        config.setFeature("http://www.dbunit.org/features/skipOracleRecycleBinTables", this.skipOracleRecycleBinTables);
        config.setProperty("http://www.dbunit.org/properties/escapePattern", this.escapePattern);
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", new ForwardOnlyResultSetTableFactory());
        if (this.batchSize != null) {
            Integer batchSizeInteger = new Integer(this.batchSize);
            config.setProperty("http://www.dbunit.org/properties/batchSize", batchSizeInteger);
        }
        if (this.fetchSize != null) {
            config.setProperty("http://www.dbunit.org/properties/fetchSize", new Integer(this.fetchSize));
        }
        try {
            IDataTypeFactory dataTypeFactory = (IDataTypeFactory)Class.forName(this.dataTypeFactory).newInstance();
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", dataTypeFactory);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Class Not Found: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Illegal Access: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        catch (InstantiationException e) {
            throw new BuildException("Instantiation Exception: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        return connection;
    }
}

