package org.dbunitng.util;

import static org.testng.Assert.*;

import java.io.Serializable;
import java.lang.reflect.Field;

import org.testng.annotations.Test;

@Test(groups = "util")
public class PropertyUtilTest {

	public void testDecapitalizePropertyName() {
		String actual = PropertyUtil.decapitalizePropertyName("FirstName");
		assertEquals(actual, "firstName");
	}

	public void testDecapitalizePropertyName2() {
		String actual = PropertyUtil.decapitalizePropertyName("firstName");
		assertEquals(actual, "firstName");
	}

	public void testDecapitalizePropertyName3() {
		String actual = PropertyUtil.decapitalizePropertyName("Name");
		assertEquals(actual, "name");
	}

	public void testDecapitalizePropertyName4() {
		String actual = PropertyUtil.decapitalizePropertyName(null);
		assertNull(actual);
	}

	public void testDecapitalizePropertyName5() {
		String actual = PropertyUtil.decapitalizePropertyName("");
		assertEquals(actual, "");
	}

	public void testDecapitalizePropertyName6() {
		String actual = PropertyUtil.decapitalizePropertyName("AName");
		assertEquals(actual, "AName");
	}

	private static class Sample implements Serializable {
		public String normalString;

		public final String finalString = "final";

		public static String staticString;

		public static final String staticFinalString = "static final";

	}

	public void testIsInstanceField() throws Exception {
		Field field = Sample.class.getField("normalString");
		assertTrue(PropertyUtil.isInstanceField(field));
	}

	public void testIsInstanceField2() throws Exception {
		Field field = Sample.class.getField("finalString");
		assertFalse(PropertyUtil.isInstanceField(field));
	}

	public void testIsInstanceField3() throws Exception {
		Field field = Sample.class.getField("staticString");
		assertFalse(PropertyUtil.isInstanceField(field));
	}

	public void testIsInstanceField4() throws Exception {
		Field field = Sample.class.getField("staticFinalString");
		assertFalse(PropertyUtil.isInstanceField(field));
	}

}
