package org.dbunitng.listeners.internal;

import static org.testng.Assert.assertSame;

import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunitng.annotations.DatabaseType;
import org.dbunitng.exception.DbUnitNGRuntimeException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups = "listener")
public class DbUnitNGConfigTest {

	@DataProvider(name = "url")
	public Object[][] dataUrl() {

		return new Object[][] {
			{ "jdbc:sqlserver://hostname:9999",
				DatabaseType.SQLSERVER.getDataTypeFactory() },
			{ "jdbc:oracle:thin:@hostname:1521:orcl",
				DatabaseType.ORACLE.getDataTypeFactory() },
			{ "jdbc:db2://host:9999/database",
				DatabaseType.DB2.getDataTypeFactory() },
			{ "jdbc:mysql://127.0.0.1/testframework",
				DatabaseType.MYSQL.getDataTypeFactory() },
			{ "jdbc:hsqldb:hsql://127.0.0.1:9001",
				DatabaseType.HSQLDB.getDataTypeFactory() },
			{ "jdbc:h2:tcp://localhost:9092/MyDB",
				DatabaseType.H2.getDataTypeFactory() }, { null, null } };
	}

	@Test(dataProvider = "url")
	public void testGetDataTypeFactory(String url, IDataTypeFactory expected) {

		IDataTypeFactory actual = DbUnitNGConfig.getDataTypeFactory(url);
		assertSame(actual, expected);

	}

	@Test(expectedExceptions = DbUnitNGRuntimeException.class)
	public void testGetDataTypeFactoryException() {
		DbUnitNGConfig.getDataTypeFactory("hoge");
	}

	@DataProvider(name = "jdbc-connection")
	public Object[][] dataJdbcConnection() {
		return new Object[][] { { null, "url", "user", "password" },
			{ "driver", null, "user", "password" },
			{ "driver", "url", null, "password" },
			{ "driver", "url", "user", null }, };
	}

	@Test(expectedExceptions = DbUnitNGRuntimeException.class, dataProvider = "jdbc-connection")
	public void testVerifyParamsNotNullException(String driver, String url,
			String user, String password) {
		DbUnitNGConfig config = new DbUnitNGConfig();
		config.setDriver(driver);
		config.setPassword(password);
		config.setUrl(url);
		config.setUserName(user);

		config.verifyParamsNotNull();
	}

	public void testVerifyParamsNotNull() {
		DbUnitNGConfig config = new DbUnitNGConfig();
		config.setDriver("driver");
		config.setPassword("password");
		config.setUrl("url");
		config.setUserName("user");

		config.verifyParamsNotNull();
	}

}
