package org.dbunitng.dataset;

import java.util.ArrayList;
import java.util.List;

import org.dbunit.dataset.IDataSet;
import org.dbunitng.assertion.AssertionHelper;
import org.dbunitng.beans.testbeans.SampleArrayBean;
import org.dbunitng.beans.testbeans.SampleNestedBean;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups = "bean")
public class BeanListConverterNestedArrayTest {

	@DataProvider(name = "array")
	public Object[][] dataArray() {

		SampleNestedBean nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean1");

		List<SampleNestedBean> list = new ArrayList<SampleNestedBean>();
		list.add(nestedBean);

		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean2");
		list.add(nestedBean);

		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean3");
		list.add(nestedBean);

		SampleArrayBean bean = new SampleArrayBean();
		bean.setName("SampleArrayBean1");
		bean.setBeans(list.toArray(new SampleNestedBean[list.size()]));

		List<SampleArrayBean> beanList = new ArrayList<SampleArrayBean>();
		beanList.add(bean);

		list = new ArrayList<SampleNestedBean>();
		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean4");
		list.add(nestedBean);

		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean5");
		list.add(nestedBean);

		bean = new SampleArrayBean();
		bean.setName("SampleArrayBean2");
		bean.setBeans(list.toArray(new SampleNestedBean[list.size()]));

		beanList.add(bean);

		return new Object[][] { { beanList } };
	}

	@Test(dataProvider = "array")
	public void testConvertNestedArray(List<SampleArrayBean> list)
			throws Exception {

		BeanListConverter converter = new BeanListConverter(list);
		IDataSet dataSet = converter.convert();

		AssertionHelper.assertEqualsOnlyColumnsInFile(
			dataSet,
			getClass(),
			"NestedBeanTest-Array.xml");

	}

}
