package org.dbunitng.data;

import static org.testng.Assert.assertTrue;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import org.dbunit.IDatabaseTester;
import org.dbunit.JdbcDatabaseTester;
import org.dbunitng.annotations.FileType;
import org.dbunitng.exception.DbUnitNGRuntimeException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups = "data")
public class TestDataFileMakerTest {

	private static final String DIR = "temp";

	private TestDataFileMaker maker;

	private IDatabaseTester tester;

	@BeforeClass
	public void init() {
		maker =
			new TestDataFileMaker(
				"com.mysql.jdbc.Driver",
				"jdbc:mysql://127.0.0.1/testframework",
				"root",
				"root",
				null);
		tester =
			new JdbcDatabaseTester(
				"com.mysql.jdbc.Driver",
				"jdbc:mysql://127.0.0.1/testframework",
				"root",
				"root");
	}

	@BeforeClass
	public void deleteDir() {
		delete(new File(DIR));
	}

	private void delete(File dir) {
		File[] files = dir.listFiles();
		if (files == null) {
			return;
		}

		for (File file : files) {
			if (file.isDirectory()) {
				delete(file);
			}
			file.delete();
		}
		dir.delete();
	}

	public void testExtractSpecifiedTablesToXml() {
		String targetDir = "/xml/specified";
		String[] tableNames = new String[] { "dept", "emp" };
		maker.extractTables(DIR + targetDir, tableNames, FileType.XML);
		assertFiles(targetDir, tableNames, FileType.XML);
	}

	protected void assertFiles(String targetDir, String[] tableNames,
			FileType type) {
		File dir = new File(DIR + targetDir);
		List<String> list = Arrays.asList(dir.list());
		for (String tableName : tableNames) {
			assertTrue(list.contains(tableName.toUpperCase() + "."
				+ type.toString()));
		}
	}

	protected void assertFiles(String targetDir, FileType type) {
		try {
			assertFiles(targetDir, tester
				.getConnection()
				.createDataSet()
				.getTableNames(), type);
		} catch (Exception e) {
			throw new DbUnitNGRuntimeException(e);
		}
	}

	public void testExtractAllTablesToXml() {
		String targetDir = "/xml/all";
		maker.extractAllTables(DIR + targetDir, FileType.XML);
		assertFiles(targetDir, FileType.XML);
	}

	public void testExtractSpecifiedTablesToXls() {
		String targetDir = "/xls/specified";
		String[] tableNames = new String[] { "dept", "emp" };
		maker.extractTables(DIR + targetDir, tableNames, FileType.EXCEL);
		assertFiles(targetDir, tableNames, FileType.EXCEL);

	}

	public void testExtractAllTablesToXls() {
		String targetDir = "/xls/all";
		maker.extractAllTables(DIR + targetDir, FileType.EXCEL);
		assertFiles(targetDir, FileType.EXCEL);
	}

	public void testExtractSpecifiedTablesToCsv() {
		String targetDir = "/csv/specified";
		String[] tableNames = new String[] { "dept", "emp" };
		maker.extractTables(DIR + targetDir, tableNames, FileType.CSV);
		assertFiles(targetDir, tableNames, FileType.CSV);
	}

	public void testExtractAllTablesToCsv() {
		String targetDir = "/csv/all";
		maker.extractAllTables(DIR + targetDir, FileType.CSV);
		assertFiles(targetDir, FileType.CSV);
	}

}
