package org.dbunitng.sample;

import java.util.List;

import org.dbunit.DatabaseUnitException;
import org.dbunitng.annotations.DatabaseOperationType;
import org.dbunitng.annotations.DbUnitNG;
import org.dbunitng.annotations.SetUpOperation;
import org.dbunitng.assertion.AssertionHelper;
import org.dbunitng.dataset.BeanListConverter;
import org.dbunitng.listeners.DbUnitNGTestListener;
import org.dbunitng.sample.dao.EmpDao;
import org.dbunitng.sample.entity.Emp;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups = "performance")
public class PerformanceTest {

	@SetUpOperation(pathname = "org/dbunitng/sample/result.xml")
	@Test
	public void testPerformance() throws DatabaseUnitException {
		EmpDao dao = new EmpDao();
		long start = System.currentTimeMillis();
		List<Emp> list = dao.listAllEmployee();
		System.out.printf("DAO execute time : (%d ms)\n", System
			.currentTimeMillis()
			- start);

		AssertionHelper.assertEqualsOnlyColumnsInFile(new BeanListConverter(
			list).convert(), getClass(), "result.xml");
	}

	@BeforeSuite
	@DbUnitNG(driver = "com.mysql.jdbc.Driver", password = "root", url = "jdbc:mysql://127.0.0.1/testframework", username = "root", defaultOperation = DatabaseOperationType.CLEAN_INSERT)
	public void beforeSuite() {}

	@AfterSuite
	public void afterSuite() {}

	@BeforeTest
	public void beforeTest() {}

	@AfterTest
	public void afterTest() {}

	@BeforeClass
	public void beforeClass() {}

	@AfterClass
	public void afterClass() {}

	@BeforeMethod
	public void beforeMethod() {}

	@AfterMethod
	public void afterMethod() {}

	@BeforeGroups
	public void beforeGroups() {}

	@AfterGroups
	public void afterGroups() {}

	@Test(enabled = false)
	public static void main(String[] args) {
		TestNG testNG = new TestNG();

		testNG.addListener(new DbUnitNGTestListener());
		testNG.addListener(new PerformanceListener());
		TestListenerAdapter adapter = new TestListenerAdapter();
		testNG.addListener(adapter);

		testNG.setTestClasses(new Class[] { PerformanceTest.class });

		testNG.run();

		System.out.println("PassedTests:" + adapter.getPassedTests());
		System.out.println("FailedTests:" + adapter.getFailedTests());
		System.out.println("SkippedTests:" + adapter.getSkippedTests());
	}

}
