package org.dbunitng.sample.sql;

import java.io.Reader;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;

public class SqlMapClientManager {

	private static SqlMapClient sqlMapClient;
	static {
		try {
			String resource =
				"org/dbunitng/sample/sql/sql-map-config.xml";
			Reader reader = Resources.getResourceAsReader(resource);
			sqlMapClient = SqlMapClientBuilder.buildSqlMapClient(reader);
		} catch (Exception e) {
			throw new RuntimeException("SqlMapClientの初期化に失敗しました", e);
		}
	}

	public static SqlMapClient getSqlMapClient() {
		return sqlMapClient;
	}

}
