package jp.dbdiffreport;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class DdrUtil {

	public static void debug(String s) {
		System.out.println(s);
	}

	public static DdrProperties getProperties() throws Exception {
		return getProperties("");
	}

	public static DdrProperties getProperties(String prefix) throws Exception {

		Properties p = new Properties();
		p.load(ClassLoader.getSystemResourceAsStream("DbDiffReport.properties"));

		DdrProperties ddrProperties = new DdrProperties();
		ddrProperties.setDiff(p.getProperty("diff"));
		ddrProperties.setDriver(p.getProperty(prefix + "driver"));
		ddrProperties.setUrl(p.getProperty(prefix + "url"));
		ddrProperties.setUser(p.getProperty(prefix + "user"));
		ddrProperties.setPassword(p.getProperty(prefix + "password"));
		ddrProperties.setSchema(p.getProperty(prefix + "schema"));

		List<String> list = new ArrayList<String>();
		String tables = p.getProperty(prefix + "tables");
		if (tables != null) {
			for (String table : tables.replaceAll("\\s", "").replaceAll(";", ",").split(",")) {
				list.add(table);
			}
		}
		ddrProperties.setTableList(list);

		return ddrProperties;
	}

	public static Connection getConnection(DdrProperties p) throws Exception {

		Class.forName(p.getDriver());
		return DriverManager.getConnection(p.getUrl(), p.getUser(), p.getPassword());
	}

	public static List<HashMap<String, Object>> getColumns(Connection con, String schema, String table) throws Exception {

		String schema2 = schema;
		String table2 = table;
		if (table.indexOf('.') != -1) {
			String[] s = table.split("\\.", 2);
			schema2 = s[0];
			table2 = s[1];
		}

		DatabaseMetaData dbmd = con.getMetaData();
		ResultSet rs = dbmd.getColumns(null, schema2, table2, "%");
		ResultSetMetaData rsmd = rs.getMetaData();
		int cols = rsmd.getColumnCount();

		List<HashMap<String, Object>> list = new ArrayList<HashMap<String,Object>>();
		while (rs.next()) {
			HashMap<String, Object> map = new HashMap<String, Object>();
			for (int i = 0; i < cols; i++) {
				map.put(rsmd.getColumnName(i + 1), rs.getObject(i + 1));
			}
			list.add(map);
		}

		return list;
	}

	public static List<String> getPrimaryKeys(Connection con, String schema, String table) throws Exception {

		String schema2 = schema;
		String table2 = table;
		if (table.indexOf('.') != -1) {
			String[] s = table.split("\\.", 2);
			schema2 = s[0];
			table2 = s[1];
		}

		DatabaseMetaData dbmd = con.getMetaData();
		ResultSet rs = dbmd.getPrimaryKeys(null, schema2, table2);

		List<String> list = new ArrayList<String>();
		while (rs.next()) {
			list.add(rs.getString("COLUMN_NAME"));
		}

		return list;
	}

	public static List<DdrSchemaTable> getTables(Connection con, String schema, List<String> tableList) throws Exception {

		List<DdrSchemaTable> list = new ArrayList<DdrSchemaTable>();

		DatabaseMetaData dbmd = con.getMetaData();
		for (String table : tableList) {
			String schema2 = schema;
			String table2 = table;
			if (table.indexOf('.') != -1) {
				String[] s = table.split("\\.", 2);
				schema2 = s[0];
				table2 = s[1];
			}

			ResultSet rs = dbmd.getPrimaryKeys(null, schema2, table2);
			while (rs.next()) {
				DdrSchemaTable schemaTable = new DdrSchemaTable();
				schemaTable.setSchema(schema2);
				schemaTable.setTable(rs.getString("COLUMN_NAME"));
				list.add(schemaTable);
			}
		}

		return list;
	}
}
