/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbNamedPipe;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.DefaultProperties;
import net.sourceforge.jtds.jdbc.SharedSocket;
import net.sourceforge.jtds.jdbc.Support;

public class SharedNamedPipe
extends SharedSocket {
    private SmbNamedPipe pipe;

    public SharedNamedPipe(ConnectionJDBC2 connection) throws IOException {
        super(connection.getBufferDir(), connection.getTdsVersion(), connection.getServerType());
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(connection.getDomainName(), connection.getUser(), connection.getPassword());
        StringBuffer url = new StringBuffer(32);
        url.append("smb://");
        url.append(connection.getServerName());
        url.append("/IPC$");
        String instanceName = connection.getInstanceName();
        if (instanceName != null && instanceName.length() != 0) {
            url.append("/MSSQL$");
            url.append(instanceName);
        }
        String namedPipePath = DefaultProperties.getNamedPipePath(connection.getServerType());
        url.append(namedPipePath);
        this.setPipe(new SmbNamedPipe(url.toString(), 3, auth));
        this.setOut(new DataOutputStream(this.getPipe().getNamedPipeOutputStream()));
        int bufferSize = Support.calculateNamedPipeBufferSize(connection.getTdsVersion(), connection.getPacketSize());
        this.setIn(new DataInputStream(new BufferedInputStream(this.getPipe().getNamedPipeInputStream(), bufferSize)));
    }

    boolean isConnected() {
        return this.getPipe() != null;
    }

    void close() throws IOException {
        super.close();
        this.getOut().close();
        this.getIn().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void forceClose() {
        block9: {
            block8: {
                try {
                    try {
                        this.getOut().close();
                    }
                    catch (IOException e) {
                        Object var3_2 = null;
                        this.setOut(null);
                        break block8;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.setOut(null);
                    throw throwable;
                }
                this.setOut(null);
            }
            try {
                try {
                    this.getIn().close();
                }
                catch (IOException iOException) {
                    Object var5_8 = null;
                    this.setIn(null);
                    break block9;
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.setIn(null);
                throw throwable;
            }
            this.setIn(null);
        }
        this.setPipe(null);
    }

    private SmbNamedPipe getPipe() {
        return this.pipe;
    }

    private void setPipe(SmbNamedPipe pipe) {
        this.pipe = pipe;
    }

    protected void setTimeout(int timeout) {
    }
}

