using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Mail;
using System.Net.Sockets;
using System.IO;
using System.Net;
using log4net;
using System.Reflection;
using System.Net.Mime;
using System.Text.RegularExpressions;

namespace DataUnit.Core
{
    public class Mail
    {
        private static readonly ILog _logger
           = LogManager.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);


        private DataUnit.Core.MailAuth _authType;

        public DataUnit.Core.MailAuth AuthType
        {
            get { return _authType; }
            set { _authType = value; }
        }
        private string _body;

        public string Body
        {
            get { return _body; }
            set {
                _body = value.Trim().Replace("\r\n","\n").Replace("\n","\r\n");
            }
        }
        private string _from;

        public string From
        {
            get { return _from; }
            set { _from = value.Trim(); }
        }
        private string _smtpPassword;

        public string SmtpPassword
        {
            get { return _smtpPassword; }
            set { _smtpPassword = value.Trim(); }
        }
        private string _smtpServer;

        public string SmtpServer
        {
            get { return _smtpServer; }
            set { _smtpServer = value.Trim(); }
        }

        private string _smtpUser;

        public string SmtpUser
        {
            get { return _smtpUser; }
            set { _smtpUser = value.Trim(); }
        }

        private int _smtpPort;

        public int SmtpPort
        {
            get { return _smtpPort; }
            set { _smtpPort = value; }
        }

        private string _popServer;
        public string PopServer
        {
            get { return _popServer; }
            set { _popServer = value.Trim(); }
        }


        private string _title;
        public string Title
        {
            get { return _title; }
            set { _title = value.Trim(); }
        }
        private string _to;

        private bool _isFileNameAddToTitle;

        public bool IsFileNameAddToTitle
        {
            get { return _isFileNameAddToTitle; }
            set { _isFileNameAddToTitle = value; }
        }

        private bool _canAddSqlToBody;

        public bool CanAddSqlToBody
        {
            get { return _canAddSqlToBody; }
            set { _canAddSqlToBody = value; }
        }
        

        public string To
        {
            get { return _to; }
            set { _to = value.Trim(); }
        }

        private string _cc;

        public string Cc
        {
            get { return _cc; }
            set { _cc = value.Trim(); }
        }

        private string _bcc;

        public string Bcc
        {
            get { return _bcc; }
            set { _bcc = value.Trim(); }
        }

        private bool _isSend;

        public bool IsSend
        {
            get { return _isSend; }
            set { _isSend = value; }
        }

        public void Send(string attachFilePath,string fileName,string sql)
        {
            _logger.Info(String.Format("[MJn[{0}]", fileName));

            try
            {
                SmtpClient smtp = new SmtpClient(_smtpServer,_smtpPort);
                if (_authType == MailAuth.Smtp)
                {
                    smtp.Credentials = new NetworkCredential(_smtpUser, _smtpPassword);
                    smtp.EnableSsl = false;
                }
                else if (_authType == MailAuth.PopBefore)
                {
                    ConnectPopServer();
                }

                using (MailMessage msg = CreateMailMassage(attachFilePath,fileName,sql)){
                    smtp.Send(msg);
                }
            }
            catch (Exception ex)
            {
                _logger.Error("[MG[", ex);
                throw;
            }

        }

        private MailMessage CreateMailMassage(string attachFilePath, string fileName,string sql)
        {
            MailMessage msg = new MailMessage();
            Encoding encodingJp = Encoding.GetEncoding("iso-2022-jp");

            //
            string subject = _title;
            if (_isFileNameAddToTitle)
            {
                subject += fileName.Split('.')[0];
            }
            subject = Convert.ToBase64String(encodingJp.GetBytes(subject));
            msg.Subject = string.Format("=?{0}?B?{1}?=", encodingJp.BodyName, subject);

            //{
            msg.Body = _body;
            if (_canAddSqlToBody )
            {
                msg.Body += "\r\n" + sql;
            }
            AlternateView view = AlternateView.CreateAlternateViewFromString(_body, encodingJp, MediaTypeNames.Text.Plain);
            view.TransferEncoding = TransferEncoding.SevenBit;
            msg.AlternateViews.Add(view);

            //AhX
            msg.From = new MailAddress(_from);
            SetMailAddress(msg.To, _to);
            SetMailAddress(msg.CC, _cc);
            SetMailAddress(msg.Bcc, _bcc);

            //Ytt@C
            Attachment file = new Attachment(attachFilePath);
            msg.Attachments.Add(file);
            return msg;
        }


        private static void SetMailAddress(MailAddressCollection mailObjects ,string mailString){

            string[] mails = Regex.Split(mailString, @",|;|\s"); //J}AZ~RAXy[Xŕ
            foreach (string mail in mails)
            {
                if (0 < mail.Trim().Length)
                {
                    mailObjects.Add(new MailAddress(mail));
                }
            }
        }

        private void ConnectPopServer()
        {
            TcpClient client = new TcpClient();

            client.ReceiveTimeout = 10000;
            client.SendTimeout = 10000;
            client.Connect(_popServer, 110);

            StreamWriter sw = new StreamWriter(client.GetStream());
            StreamReader sr = new StreamReader(client.GetStream());

            sw.WriteLine("USER " + _smtpUser);
            sw.Flush();
            _logger.Debug("POP-USERX|X:" + sr.ReadLine());

            sw.WriteLine("PASS " + _smtpPassword);
            sw.Flush();
            _logger.Debug("POP-PASSX|X:" + sr.ReadLine());

            sw.WriteLine("STAT");
            sw.Flush();
            _logger.Debug("POP-STATX|X:" + sr.ReadLine());

            sw.WriteLine("QUIT");
            sw.Flush();
            _logger.Debug("POP-QUITX|X:" + sr.ReadLine());

        }

    }

    public enum MailAuth
    {
        /// <summary>
        /// F؂Ȃ
        /// </summary>
        None = 0,
        /// <summary>
        /// SMTPF
        /// </summary>
        Smtp = 1,
        /// <summary>
        /// POP Before SMTP
        /// </summary>
        PopBefore = 2,
    }
}
