﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.IO;
using log4net;
using System.Reflection;

namespace DataUnit.Core
{
    class Csv
    {

        private static readonly ILog _logger
            = LogManager.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        public void Output(DataTable table, string fileName)
        {
            _logger.Debug(String.Format("CSV出力開始 [{0}]", fileName));
            _logger.Warn(String.Format("「{0}」に該当するデータがありました", fileName.Split(',')[0]));

            try
            {
                using (StreamWriter sw = new StreamWriter(fileName,true, Encoding.GetEncoding("Shift-JIS")))
                {
                    OutputHeader(table, sw);
                    OutputValues(table, sw);
                }
            }
            catch (Exception ex)
            {
                _logger.Error("CSV出力エラー", ex);
                throw;
            }
        }

        private void OutputHeader(DataTable table, StreamWriter sw)
        {
            for (int i = 0; i < table.Columns.Count; i++)
            {
                sw.Write("\"" + table.Columns[i].ColumnName.Replace("\"", "\"\"") + "\"");
                if (i < table.Columns.Count - 1)
                {
                    sw.Write(",");  //コンマ区切り
                }
            }

            sw.WriteLine(""); //改行
        }

        private void OutputValues(DataTable table, StreamWriter sw)
        {
            for (int i = 0; i < table.Rows.Count; i++)
            {
                for (int j = 0; j < table.Columns.Count; j++)
                {
                    sw.Write("\"" + table.Rows[i][j].ToString().Replace("\"", "\"\"") + "\"");
                    if (j < table.Columns.Count - 1)
                    {
                        sw.Write(",");  //コンマ区切り
                    }
                }
                sw.WriteLine(""); //改行
            }
        }


    }
}
