package daruma.client.darumaviewer.views;

import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import daruma.client.darumaviewer.Const;
import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.datamodel.DaRuMaServerList;
import daruma.client.darumaviewer.datamodel.DaRuMaTargetNS;
import daruma.client.darumaviewer.datamodel.TreeObject;

public class DaRuMaViewerViewProvider {
	public static Image imgServer = SwtUtil.loadImg("icons/server.gif"); //$NON-NLS-1$

	public static Image imgTargetNS = PlatformUI.getWorkbench()
			.getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER);

	public static Image imgFeatureType = PlatformUI.getWorkbench()
			.getSharedImages().getImage(ISharedImages.IMG_OBJ_ELEMENT);

	public static Image imgViewer = PlatformUI.getWorkbench().getSharedImages()
			.getImage(ISharedImages.IMG_DEF_VIEW);

	public static class FeatureTypeTreeContentProvider implements
			ITreeContentProvider {

		private boolean displayTargetNS = Const.DFT_DISPLAY_TARGET_NS;

		public Object[] getChildren(Object item) {
			if (item instanceof TreeObject) {
				TreeObject treeObj = (TreeObject) item;
				Object data = treeObj.getData();
				if (data instanceof DaRuMaServer) {
					List childList = displayTargetNS ? ((DaRuMaServer) data)
							.getTargetNSList()
							: ((DaRuMaServer) data).getFeatureTypeList();
					return treeObj.toArray(childList);
				} else if (data instanceof DaRuMaTargetNS) {
					return treeObj.toArray(((DaRuMaTargetNS) data)
							.getFeatureTypeList());
				} else if (data instanceof DaRuMaServerList) {
					return treeObj.toArray((DaRuMaServerList) data);
				}
			}
			return new Object[0];
		}

		public Object getParent(Object element) {
			return null;
		}

		public boolean hasChildren(Object item) {
			if (item instanceof TreeObject) {
				TreeObject treeObj = (TreeObject) item;
				Object data = treeObj.getData();
				if (data instanceof DaRuMaServer) {
					int childSize = displayTargetNS ? ((DaRuMaServer) data)
							.getTargetNSSize()
							: ((DaRuMaServer) data).getFeatureTypeSize();
					return childSize > 0;
				} else if (data instanceof DaRuMaTargetNS) {
					return ((DaRuMaTargetNS) data).getFeatureTypeSize() > 0;
				} else if (data instanceof DaRuMaServerList) {
					return ((DaRuMaServerList) data).size() > 0;
				}
			}
			return false;
		}

		public Object[] getElements(Object inputElement) {
			if (inputElement != null) {
				if (inputElement instanceof DaRuMaServerList) {
					TreeObject treeObj = new TreeObject(inputElement);
					return new Object[] { treeObj };
				}
				if (inputElement instanceof TreeObject) {
					return getChildren(inputElement);
				}
			}
			return new Object[0];
		}

		public void dispose() {

		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

		/**
		 * displayTargetNSを取得する
		 * @return Returns the displayTargetNS.
		 */
		public boolean isDisplayTargetNS() {
			return displayTargetNS;
		}

		/**
		 * displayTargetNSをセットする
		 * @param displayTargetNS The displayTargetNS to set.
		 */
		public void setDisplayTargetNS(boolean displayTargetNS) {
			this.displayTargetNS = displayTargetNS;
		}
	}

	public static class FeatureTypeTreeLabelProvider extends LabelProvider {
		public String getText(Object item) {
			if (item instanceof TreeObject) {
				TreeObject treeObj = (TreeObject) item;
				Object data = treeObj.getData();

				if (data instanceof DaRuMaServer) {
					return ((DaRuMaServer) data).getName();
				} else if (data instanceof DaRuMaTargetNS) {
					return ((DaRuMaTargetNS) data).getTargetNS();
				} else if (data instanceof DaRuMaFeatureType) {
					return ((DaRuMaFeatureType) data).getTypeName();
				} else if (data instanceof DaRuMaServerList) {
					return Messages.getString("DaRuMaViewerViewProvider.1"); //$NON-NLS-1$
				}
				return data.toString();
			}
			return item.toString();
		}

		public Image getImage(Object item) {
			Image image = null;
			if (item instanceof TreeObject) {
				TreeObject treeObj = (TreeObject) item;
				Object data = treeObj.getData();

				if (data instanceof DaRuMaServerList) {
					image = imgViewer;
				} else if (data instanceof DaRuMaServer) {
					image = imgServer;
				} else if (data instanceof DaRuMaTargetNS) {
					image = imgTargetNS;
				} else if (data instanceof DaRuMaFeatureType) {
					image = imgFeatureType;
				}
			}
			return image;
		}
	}
}
