package daruma.client.darumaviewer.views;

import java.io.File;
import java.util.List;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.*;

import daruma.client.darumaviewer.Const;
import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.Perspective;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.datamodel.DaRuMaServerList;
import daruma.client.darumaviewer.datamodel.DaRuMaTargetNS;
import daruma.client.darumaviewer.datamodel.TreeObject;
import daruma.client.darumaviewer.dialogs.AddServerDialog;
import daruma.client.darumaviewer.dialogs.PreferenceDialog;
import daruma.client.darumaviewer.prefs.DaRuMaViewerPreference;
import daruma.client.darumaviewer.service.DaRuMaViewerService;
import daruma.client.darumaviewer.views.DaRuMaViewerViewProvider.FeatureTypeTreeContentProvider;

public class DaRuMaViewerView extends ViewPart {
	public static DaRuMaViewerPreference dftPref = new DaRuMaViewerPreference();

	public static DaRuMaViewerService dftService = new DaRuMaViewerService();

	private TreeViewer treeViewer;

	private Composite composite;

	private DaRuMaServerList currServerList = new DaRuMaServerList();

	private Action actPref;

	private Action actGetFeatureTypes;

	private Action actGetFeatureTypeInfo;

	private Action actXmlGetFeature;

	private Action actCsvGetFeature;

	private Action actRunCommand;

	private Action actServerAdd;

	private Action actServerDel;

	private static String SEPERATOR_SERVERS = ","; //$NON-NLS-1$

	private static String SEPERATOR_HOST_PORT = ":"; //$NON-NLS-1$

	private FeatureTypeTreeContentProvider contentProvider;
	
	/**
	 * ロガー
	 */
	protected static Logger logger = LogManager
			.getLogger(DaRuMaViewerView.class.getClass());

	/**
	 * ビューID
	 */
	public static final String ID = DaRuMaViewerView.class.getName();

	public static int DFT_SERVERS_EXPAND_LEVEL = 2;

	public static int DFT_FEATURETYPES_EXPAND_LEVEL = 1;

	/**
	 * ビューの画面を作成する
	 * 
	 * @param parent
	 *            親Composite
	 */
	public void createPartControl(Composite parent) {
		this.setPartName(Messages.getString("DaRuMaViewerView.20")); //$NON-NLS-1$
		dftPref.load();
		loadServerList(currServerList, dftPref);

		composite = parent;
		makeActions();

		treeViewer = new TreeViewer(composite, SWT.SINGLE | SWT.H_SCROLL
				| SWT.V_SCROLL);
		contentProvider = new DaRuMaViewerViewProvider.FeatureTypeTreeContentProvider();
		contentProvider.setDisplayTargetNS(dftPref.isDisplayTargetNS());
		treeViewer
				.setContentProvider(contentProvider);
		treeViewer
				.setLabelProvider(new DaRuMaViewerViewProvider.FeatureTypeTreeLabelProvider());
		treeViewer.getTree().addMouseMoveListener(
				new TreeMouseMoveListener(this, treeViewer));
		treeViewer.setInput(currServerList);
		treeViewer.setSorter(new NameSorter());
		treeViewer.expandAll();
		makeTreeViewerContextMenu(treeViewer);

	}

	class NameSorter extends ViewerSorter {
	}

	private void loadServerList(DaRuMaServerList serverList,
			DaRuMaViewerPreference pref) {
		serverList.clear();
		if (pref.getServers().length() > 0) {
			String[] servers = pref.getServers().split(SEPERATOR_SERVERS);
			for (int cnt = 0; cnt < servers.length; cnt++) {
				String server = servers[cnt];
				int temp = server.indexOf(SEPERATOR_HOST_PORT);
				String host = server;
				int port = Const.DFT_PORT;
				if (temp >= 0) {
					host = server.substring(0, temp);
					try {
						temp = Integer.parseInt(server.substring(temp + 1));
						port = temp;
					} catch (Exception e) {

					}
				}
				serverList.add(new DaRuMaServer(host, port));
			}
		}
	}

	private void saveServerList(DaRuMaServerList serverList,
			DaRuMaViewerPreference pref) {
		String servers = ""; //$NON-NLS-1$
		for (int cnt = 0; cnt < serverList.size(); cnt++) {
			if (cnt > 0)
				servers += SEPERATOR_SERVERS;
			DaRuMaServer server = (DaRuMaServer) serverList.get(cnt);
			servers += server.getHost() + SEPERATOR_HOST_PORT
					+ server.getPort();
		}
		pref.setServers(servers);
		pref.save();
	}

	/**
	 * フォーカスを設定する
	 */
	public void setFocus() {
	}

	/**
	 * 
	 * @param viewer
	 */
	private void makeTreeViewerContextMenu(TreeViewer viewer) {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new TreeViewerMenuListener());
		Menu menu = menuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, viewer);
	}

	private void makeActions() {
		Action[] actions = new Action[8];
		for (int cnt = 0; cnt < actions.length; cnt++) {
			actions[cnt] = new Action() {
				public void run() {
					handleActions(this);
				}

			};
		}

		actPref = actions[0];
		actPref.setText(Messages.getString("DaRuMaViewerView.21")); //$NON-NLS-1$
		actPref.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages()
				.getImageDescriptor(ISharedImages.IMG_OBJ_FILE));

		actGetFeatureTypes = actions[1];
		actGetFeatureTypes.setImageDescriptor(PlatformUI.getWorkbench()
				.getSharedImages().getImageDescriptor(
						ISharedImages.IMG_OBJ_FILE));

		actGetFeatureTypeInfo = actions[2];
		actGetFeatureTypeInfo.setText(Messages
				.getString("DaRuMaViewerView.23")); //$NON-NLS-1$
		actGetFeatureTypeInfo.setImageDescriptor(PlatformUI.getWorkbench()
				.getSharedImages().getImageDescriptor(
						ISharedImages.IMG_OBJ_FILE));
		actXmlGetFeature = actions[3];
		actXmlGetFeature
				.setText(Messages.getString("DaRuMaViewerView.24")); //$NON-NLS-1$
		actXmlGetFeature.setImageDescriptor(PlatformUI.getWorkbench()
				.getSharedImages().getImageDescriptor(
						ISharedImages.IMG_OBJ_FILE));
		actCsvGetFeature = actions[4];
		actCsvGetFeature
				.setText(Messages.getString("DaRuMaViewerView.25")); //$NON-NLS-1$
		actCsvGetFeature.setImageDescriptor(PlatformUI.getWorkbench()
				.getSharedImages().getImageDescriptor(
						ISharedImages.IMG_OBJ_FILE));

		actRunCommand = actions[5];
		actRunCommand
				.setText(Messages.getString("DaRuMaViewerView.213")); //$NON-NLS-1$
		actRunCommand.setImageDescriptor(PlatformUI.getWorkbench()
				.getSharedImages().getImageDescriptor(
						ISharedImages.IMG_OBJ_FILE));

		actServerAdd = actions[6];
		actServerAdd.setText(Messages.getString("DaRuMaViewerView.3")); //$NON-NLS-1$
		actServerAdd.setImageDescriptor(PlatformUI.getWorkbench()
				.getSharedImages().getImageDescriptor(
						ISharedImages.IMG_TOOL_NEW_WIZARD));

		actServerDel = actions[7];
		actServerDel.setText(Messages.getString("DaRuMaViewerView.4")); //$NON-NLS-1$
		actServerDel.setImageDescriptor(PlatformUI.getWorkbench()
				.getSharedImages().getImageDescriptor(
						ISharedImages.IMG_TOOL_DELETE));

	}

	public TreeObject getCurrTreeObject(TreeViewer viewer) {
		ISelection selection = viewer.getSelection();
		Object item = ((IStructuredSelection) selection).getFirstElement();

		if (item instanceof TreeObject) {
			return (TreeObject) item;
		}
		return null;
	}

	public DaRuMaFeatureType getCurrFeatureType(TreeViewer viewer) {
		TreeObject treeObj = getCurrTreeObject(viewer);

		if (treeObj != null) {
			Object data = treeObj.getData();
			if (data instanceof DaRuMaFeatureType)
				return (DaRuMaFeatureType) data;
		}
		return null;
	}

	public DaRuMaServer getCurrServer(TreeViewer viewer) {
		TreeObject treeObj = getCurrTreeObject(viewer);

		if (treeObj != null) {
			Object data = treeObj.getData();
			if (data instanceof DaRuMaServer)
				return (DaRuMaServer) data;
		}
		return null;
	}

	private void setupPref(DaRuMaViewerPreference pref)
	{
		PreferenceDialog dialog = new PreferenceDialog(this.getSite()
				.getShell(), pref); //$NON-NLS-1$
		dialog.open();
		if(dftPref.isDisplayTargetNS() != contentProvider.isDisplayTargetNS())
		{
			contentProvider.setDisplayTargetNS(pref.isDisplayTargetNS());
			updateAll();
		}
	}
	private boolean validatePref(DaRuMaViewerPreference pref){
		boolean rc = true;

		File workDir = new File(pref.getWorkDir());
		workDir.mkdirs();
		if (!(workDir.exists() && workDir.isDirectory())) {
			SwtUtil.showError(Messages.getString("DaRuMaViewerView.214")); //$NON-NLS-1$
			rc = false;
		}

		File clientDir = new File(pref.getClientToolDir());
		if (!(clientDir.exists() && clientDir.isDirectory())) {
			SwtUtil.showError(Messages.getString("DaRuMaViewerView.215")); //$NON-NLS-1$
			rc = false;
		}
		return rc;
	}
	
	private boolean checkPref(DaRuMaViewerPreference pref) {
		boolean rc;
		
		rc = validatePref(pref);
		if(!rc)
		{
			setupPref(pref);
			rc = validatePref(pref);
		}
		
		return rc;
	}

	private void handleActions(Action action) {
		TreeObject currTreeObject = getCurrTreeObject(treeViewer);
		DaRuMaFeatureType currFeatureType = getCurrFeatureType(treeViewer);
		DaRuMaServer currServer = getCurrServer(treeViewer);

		if (action == actPref) {
			setupPref(dftPref);
		} else if (action == actServerAdd) {
			AddServerDialog dialog = new AddServerDialog(this.getSite()
					.getShell()); //$NON-NLS-1$
			dialog.open();
			DaRuMaServer newServer = dialog.getNewServer();
			if (newServer != null) {
				updateServerList(newServer, true);
			}

		} else if (action == actServerDel) {
			if (currServer != null) {
				if (SwtUtil
						.showQuestion(Messages.getString("DaRuMaViewerView.5") + currServer.getName() + Messages.getString("DaRuMaViewerView.6"))) //$NON-NLS-1$ //$NON-NLS-2$
					updateServerList(currServer, false);
			}
		} else if (!checkPref(dftPref)) {

		} else if (action == actGetFeatureTypes) {
			if(!dftService.getFeatureTypes(dftPref,
					currServer))
				SwtUtil.showError(Messages.getString("DaRuMaViewerView.29")); //$NON-NLS-1$
			updateFeatureTypeList(currTreeObject);
		} else if (action == actGetFeatureTypeInfo) {
			if (currFeatureType != null) {
				FeatureTypeView view = (FeatureTypeView) SwtUtil.showView(
						Perspective.topFolder, FeatureTypeView.ID,
						currFeatureType.getTypeName());
				view.setFeatureType(currFeatureType);
			}
		} else if (action == actRunCommand) {
			if (currServer != null) {
				RunCommandView view = (RunCommandView) SwtUtil.showView(
						Perspective.topFolder, RunCommandView.ID,
						currServer.getName());
				view.setCurrServer(currServer);
			}
		} else if((action == actXmlGetFeature) || (action == actCsvGetFeature))
		{
			if(currFeatureType != null)
			{
				RunCommandView view = (RunCommandView) SwtUtil.showView(
						Perspective.topFolder, RunCommandView.ID,
						currFeatureType.getServer().getName());
				view.setCurrServer(currFeatureType.getServer());
				view.setXmlGetFeature(currFeatureType, (action == actXmlGetFeature));
			}
		}
		else {
			SwtUtil.showInfo(Messages.getString("DaRuMaViewerView.9")); //$NON-NLS-1$
		}
			

	}

	private void updateAll() {
		treeViewer.refresh();
		treeViewer.expandToLevel(DFT_SERVERS_EXPAND_LEVEL);
	}

	
	private void updateServerList(DaRuMaServer server, boolean flgAdd) {
		if (flgAdd)
			currServerList.add(server);
		else
			currServerList.remove(server);
		saveServerList(currServerList, dftPref);
		updateAll();
	}

	private void updateFeatureTypeList(TreeObject treeObj) {
		treeViewer.refresh(treeObj);
		treeViewer.expandToLevel(treeObj, DFT_FEATURETYPES_EXPAND_LEVEL);
	}

	/**
	 * ツリービューメニューリスナー
	 */
	private class TreeViewerMenuListener implements IMenuListener {
		/**
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
		 */
		public void menuAboutToShow(IMenuManager manager) {
			ISelection selection = treeViewer.getSelection();
			Object item = ((IStructuredSelection) selection).getFirstElement();

			if (item instanceof TreeObject) {
				TreeObject treeObj = (TreeObject) item;
				Object data = treeObj.getData();
				if (data instanceof List) {
					manager.add(actPref);
					manager.add(new Separator());
					manager.add(actServerAdd);
				}

				if (data instanceof DaRuMaServer) {
					actGetFeatureTypes.setText(((DaRuMaServer)data).isFeatureTypeValid() ? Messages.getString("DaRuMaViewerView.12") : Messages.getString("DaRuMaViewerView.22")); //$NON-NLS-1$ //$NON-NLS-2$
					manager.add(actGetFeatureTypes);
					manager.add(new Separator());
					manager.add(actServerDel);
					manager.add(new Separator());
					manager.add(actRunCommand);
				} else if (data instanceof DaRuMaFeatureType) {
					manager.add(actGetFeatureTypeInfo);
					manager.add(new Separator());
					manager.add(actXmlGetFeature);
					manager.add(actCsvGetFeature);
				}
			}
			manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
		}
	}

	public class TreeMouseMoveListener implements MouseMoveListener {
		/**
		 * 前回行番号
		 */
		TreeItem prevItem;

		/**
		 * ビュー
		 */
		DaRuMaViewerView view;

		/**
		 * テーブルビュー
		 */
		TreeViewer viewer;

		/**
		 * リスナーを生成する
		 * 
		 * @param view
		 *            ビュー
		 * @param viewer
		 *            テーブルビュー
		 */
		public TreeMouseMoveListener(DaRuMaViewerView view, TreeViewer viewer) {
			this.view = view;
			this.viewer = viewer;
		}

		/**
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.swt.events.MouseMoveListener#mouseMove(org.eclipse.swt.events.MouseEvent)
		 */
		public void mouseMove(MouseEvent e) {
			if (e.widget != null) {
				if (e.widget instanceof Tree) {
					Tree tree = (Tree) e.widget;
					TreeItem item = tree.getItem(new Point(e.x, e.y));
					if (item != null) {
						Object obj = item.getData();

						if (obj instanceof TreeObject) {
							TreeObject treeObj = (TreeObject) obj;
							Object data = treeObj.getData();

							String tip = ""; //$NON-NLS-1$
							if (data instanceof DaRuMaFeatureType) {
								tip = ((DaRuMaFeatureType) data).getName();
							} else if (data instanceof DaRuMaServer) {
								int size = ((DaRuMaServer) data)
										.getFeatureTypeSize();
								if (size < 0)
									tip = Messages
											.getString("DaRuMaViewerView.2"); //$NON-NLS-1$
								else{
									tip = Messages.getString("DaRuMaViewerView.10") + ((DaRuMaServer) data).getTargetNSSize(); //$NON-NLS-1$
									tip += Messages.getString("DaRuMaViewerView.11"); //$NON-NLS-1$
									tip += Messages
											.getString("DaRuMaViewerView.1") + size; //$NON-NLS-1$
								}
							} else if (data instanceof DaRuMaTargetNS) {
								tip = Messages.getString("DaRuMaViewerView.1") //$NON-NLS-1$
								+ ((DaRuMaTargetNS) data).getFeatureTypeSize();
							} else if (data instanceof DaRuMaServerList) {
								tip = Messages.getString("DaRuMaViewerView.0") //$NON-NLS-1$
										+ ((DaRuMaServerList) data).size();
							}
							if (prevItem != item) {
								tree
										.setToolTipText(tip.length() > 0 ? tip
												: ""); //$NON-NLS-1$
							}
						}
					}
					prevItem = item;
				}
			}
		}

	}
	
	/**
	 * ファイルをクローズする
	 * 
	 * @return 成功した場合True, それ以外はFalseを返す
	 */
	public boolean closeFile() {
		return closeFile(true);
	}
	/**
	 * ファイルをクローズする
	 * 
	 * @param blSave
	 *            保存フラグ
	 * @return 成功した場合True, それ以外はFalseを返す
	 */
	private boolean closeFile(boolean blSave) {
		boolean rc = false;


		rc = true;

		return rc;
	}

}