package daruma.client.darumaviewer.service;

import daruma.client.darumaviewer.datamodel.DaRuMaFeatureTypeInfo;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.prefs.DaRuMaViewerPreference;

public class DaRuMaViewerService {
	public DaRuMaClientAgent agent = new DaRuMaClientAgent();

	public boolean getFeatureTypes(DaRuMaViewerPreference pref,
			DaRuMaServer server) {
		boolean rc = false;
		String outFile = pref.getWorkDir() + "/" + "ShowFeatureTypes.txt"; //$NON-NLS-1$ //$NON-NLS-2$
		server.setFeatureTypeValid(false);
		if (agent.doShowFeatureTypes(pref, server, outFile,
				DaRuMaClientAgent.MODE_DIALOG_AUTOCLOSE)) {
			rc = DaRuMaClientUtil.retriveFeatureTypes(outFile, server);
		}
		server.setFeatureTypeValid(rc);
		return rc;
	}

	public boolean getFeatureTypeInfo(DaRuMaViewerPreference pref,
			DaRuMaFeatureTypeInfo featureTypeInfo, boolean blSchema,
			boolean blCount) {
		boolean rc = false;
		String outFile1 = pref.getWorkDir() + "/" + "DescribeFeatureType.xml"; //$NON-NLS-1$ //$NON-NLS-2$
		String outFile2 = pref.getWorkDir() + "/" + "CountFeatureType.xml"; //$NON-NLS-1$ //$NON-NLS-2$

		if (blSchema) {
			if (agent.doDescribeFeatureType(pref, featureTypeInfo.getServer(),
					featureTypeInfo, outFile1,
					DaRuMaClientAgent.MODE_DIALOG_AUTOCLOSE)) {
				rc = DaRuMaClientUtil.retriveFeatureTypeSchema(featureTypeInfo,
						outFile1);
			}
			if(!rc) return rc;
		}
		if (blCount) {
			if (agent.doCountFeatureType(pref, featureTypeInfo.getServer(),
					featureTypeInfo, outFile2,
					DaRuMaClientAgent.MODE_DIALOG_AUTOCLOSE)) {
				rc = DaRuMaClientUtil.retriveFeatureTypeCount(featureTypeInfo,
						outFile2);

			}
			if(!rc) return rc;
		}
		return rc;
	}

}
