package daruma.client.darumaviewer.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
// 追加　2006,11,28
import java.io.FileWriter;

import org.eclipse.swt.widgets.Display;
// 追加　2006,11,28
import org.eclipse.jface.dialogs.MessageDialog;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.dialogs.ThreadDialog;
import daruma.client.darumaviewer.dialogs.ThreadDialogRunnable;
import daruma.client.darumaviewer.prefs.DaRuMaViewerPreference;
import daruma.client.darumaviewer.views.SwtUtil;

public class DaRuMaClientAgent {
	public static boolean osWindows = System.getProperty("os.name").startsWith( //$NON-NLS-1$
			"Windows"); //$NON-NLS-1$

	public static String CMD_EXT = osWindows ? ".cmd" : ""; //$NON-NLS-1$ //$NON-NLS-2$

	public static String CMD_DARUMACLIENT = "DarumaClient" + CMD_EXT; //$NON-NLS-1$

	public static String CMD_SHOWFEATURETYPES = "ShowFeatureTypes" + CMD_EXT; //$NON-NLS-1$

	public static String CMD_COUNTFEATURETYPE = "CountFeatureType" + CMD_EXT; //$NON-NLS-1$

	public static String CMD_DESCRIBEFEATURETYPE = "DescribeFeatureType" //$NON-NLS-1$
			+ CMD_EXT;

	public static String CMD_REGISTERFEATURETYPE = "RegisterFeatureType" //$NON-NLS-1$
			+ CMD_EXT;

	public static String CMD_XMLGETFEATURE = "XmlGetFeature" + CMD_EXT; //$NON-NLS-1$

	public static String CMD_CSVGETFEATURE = "CsvGetFeature" + CMD_EXT; //$NON-NLS-1$

	public static String CMD_XMLINSERT = "XmlInsert" + CMD_EXT; //$NON-NLS-1$

	public static String CMD_CSVINSERT = "CsvInsert" + CMD_EXT; //$NON-NLS-1$

	public static String OPT_HOST = "-host"; //$NON-NLS-1$

	public static String OPT_IN = "-in"; //$NON-NLS-1$

	public static String OPT_OUT = "-out"; //$NON-NLS-1$

	public static String OPT_FEATURE = "-checkFeature"; //$NON-NLS-1$

	public static String OPT_CSVCFG = "-csvcfg"; //$ NON-NLS-1$

	public static String OPT_DEBUG = "-debug"; //$NON-NLS-1$

	public static String OPT_NOTADDHEADER = "-notaddheader"; //$NON-NLS-1$

	public static String OPT_ONLYBODY = "-onlybody"; //$NON-NLS-1$
	
	public static String OPT_ATTATCH_DIR = "-attatchDir"; //$NON-NLS-1$
	public static String OPT_ENCODE = "-encode"; //$NON-NLS-1$
	public final static int MODE_NO_DIALOG = 0;

	public final static int MODE_DIALOG_AUTOCLOSE = 1;

	public final static int MODE_DIALOG = 2;
	
	public final static String DFT_ENCODE = System.getProperty("file.encoding");
	

	private int run(String[] args, int mode, String encode) {
		
		if (mode == MODE_DIALOG_AUTOCLOSE)
			return runWithDialog(args, true, encode);
		else if (mode == MODE_DIALOG)
			return runWithDialog(args, false, encode);
		else
			return runWithoutDialog(args, null, encode);

	}

	private int runWithoutDialog(String[] args, ThreadDialog dialog, String encode) {
		try {
			Process process = Runtime.getRuntime().exec(args);
			return waitProcess(process, dialog, encode);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return -1;
	}

	private int waitProcess(Process process, final ThreadDialog dialog, String encode) {
		try {
			InputStream in = process.getInputStream();
			InputStreamReader inIsr = new InputStreamReader(in, encode); //$NON-NLS-1$
			InputStream err = process.getErrorStream();
			InputStreamReader errIsr = new InputStreamReader(err, encode); //$NON-NLS-1$

			char[] buf = new char[8092];
			while (true) {
				boolean refresh = false;
				if (inIsr.ready()) {
					int len = inIsr.read(buf);
					if (len > 0) {
						if (dialog != null) {
							dialog.addToConsole(buf, 0, len, false);
							refresh = true;
						}
					}	
								
				}

				if (errIsr.ready()) {
					int len = errIsr.read(buf);
					if (len > 0) {
						if (dialog != null) {
							dialog.addToConsole(buf, 0, len, true);
							refresh = true;
						}
					}
				}

				if (refresh) {
					Display display = dialog.getShell().getDisplay();
					if (!display.isDisposed()) {
						Runnable r = new Runnable() {
							public void run() {
								dialog.refreshConsole();
							}
						};
						display.syncExec(r);
					}

				}

				try {
					int rc = process.exitValue();
					inIsr.close();
					errIsr.close();
					in.close();
					err.close();
					return rc;
				} catch (IllegalThreadStateException e) {
				}
				try {
					Thread.sleep(200);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return -1;
	}

	private int runWithDialog(String[] args, boolean autoClose, String encode) {
		/*
		 * 処理ダイアログを生成
		 */
		DaRuMaAgentRunner runner = new DaRuMaAgentRunner(args);
		ThreadDialog threadDialog = new ThreadDialog(null, Messages
				.getString("DaRuMaClientAgent.8"), //$NON-NLS-1$
				Messages.getString("DaRuMaClientAgent.9"), runner, autoClose); //$NON-NLS-1$
		runner.setDialog(threadDialog);
		runner.setEncode(encode);
		int rc = threadDialog.open();
		return rc;
	}

	class DaRuMaAgentRunner implements ThreadDialogRunnable {
		String[] args;

		ThreadDialog dialog;
		
		String encode = DFT_ENCODE;
		
		Process process = null;

		DaRuMaAgentRunner(String[] args) {
			this.args = args;
		}

		public int run() {
			try {
				this.process = Runtime.getRuntime().exec(args);
				return waitProcess(this.process, dialog, encode);
			} catch (IOException e) {
				e.printStackTrace();
			}
			return -1;
		}

		/**
		 * dialogをセットする
		 * 
		 * @param dialog
		 *            The dialog to set.
		 */
		public void setDialog(ThreadDialog dialog) {
			this.dialog = dialog;
		}
		
		

		/**
		 * encodeをセットする
		 * @param encode The encode to set.
		 */
		public void setEncode(String encode) {
			this.encode = encode;
		}

		public void stop() {
			if(process != null)
			{
				process.destroy();
			}
		}

	}

	private String[] makeArgArray(List argList) {
		String[] args = new String[argList.size()];
		for (int cnt = 0; cnt < argList.size(); cnt++) {
			args[cnt] = (String) argList.get(cnt);
		}
		return args;
	}

	public boolean doDaRuMaClient(DaRuMaViewerPreference pref,
			DaRuMaServer server, String inFile, boolean blAddSoapHeader,
			String outFile, boolean blDelSoapHeader, boolean blMakebatFile, 
			String batFile, boolean blViewCommand,int mode) {
		boolean rc = false;
		List argList = new ArrayList();

		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_DARUMACLIENT); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		argList.add(OPT_IN); //$NON-NLS-1$
		argList.add(inFile);
		if (!blAddSoapHeader)
			argList.add(OPT_NOTADDHEADER);
		if (blDelSoapHeader)
			argList.add(OPT_ONLYBODY);
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
		
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doShowFeatureTypes(DaRuMaViewerPreference pref,
			DaRuMaServer server, String outFile, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_SHOWFEATURETYPES); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		argList.add(OPT_OUT); //$NON-NLS-1$
		argList.add(outFile);
	
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doDescribeFeatureType(DaRuMaViewerPreference pref,
			DaRuMaServer server, DaRuMaFeatureType featureType, String outFile,
			int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_DESCRIBEFEATURETYPE); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
		argList.add(featureType.getName());
	
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doCountFeatureType(DaRuMaViewerPreference pref,
			DaRuMaServer server, DaRuMaFeatureType featureType, String outFile,
			int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_COUNTFEATURETYPE); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
		argList.add(featureType.getName());

		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doXmlGetFeature(DaRuMaViewerPreference pref,
			DaRuMaServer server, DaRuMaFeatureType featureType, String outFile,
			boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_XMLGETFEATURE); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		argList.add(OPT_FEATURE); //$NON-NLS-1$
		argList.add(featureType.getName());
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}		
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doXmlGetFeature(DaRuMaViewerPreference pref,
			DaRuMaServer server, String inFile, String outFile, boolean blMakebatFile, 
			String batFile, boolean blViewCommand, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_XMLGETFEATURE); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		argList.add(OPT_IN); //$NON-NLS-1$
		argList.add(inFile);
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}	
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doRegisterFeatureType(DaRuMaViewerPreference pref,
			DaRuMaServer server, String inFile, String outFile, boolean blMakebatFile, 
			String batFile, boolean blViewCommand, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_REGISTERFEATURETYPE); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
		argList.add(OPT_IN); //$NON-NLS-1$
		argList.add(inFile);
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}	
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doXmlInsert(DaRuMaViewerPreference pref,
			DaRuMaServer server, String inFile, String outFile, boolean blMakebatFile, 
			String batFile, boolean blViewCommand, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_XMLINSERT); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
		argList.add(OPT_IN); //$NON-NLS-1$
		argList.add(inFile);
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}	
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doCsvInsert(DaRuMaViewerPreference pref,
			DaRuMaServer server, String inFile, String csvcfgFile, String attatchedFileDir,
			String outFile, String encode, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_CSVINSERT); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
		argList.add(OPT_IN); //$NON-NLS-1$
		argList.add(inFile);
		argList.add(OPT_CSVCFG); //$NON-NLS-1$
		argList.add(csvcfgFile);
		argList.add(OPT_ENCODE); //$NON-NLS-1$
		argList.add(encode);
		if((attatchedFileDir != null) && (attatchedFileDir.length() > 0))
		{
			argList.add(OPT_ATTATCH_DIR);
			argList.add(attatchedFileDir);
		}
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}
		rc = (run(makeArgArray(argList), mode, DFT_ENCODE) == 0);
		return rc;
	}

	public boolean doCsvGetFeature(DaRuMaViewerPreference pref,
			DaRuMaServer server, DaRuMaFeatureType featureType,
			String csvcfgFile, String attatchedFileDir,String outFile, String encode, boolean blMakebatFile, 
			String batFile, boolean blViewCommand, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_CSVGETFEATURE); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		if (featureType != null) {
			argList.add(OPT_FEATURE); //$NON-NLS-1$
			argList.add(featureType.getName());
		}
		argList.add(OPT_CSVCFG); //$NON-NLS-1$
		argList.add(csvcfgFile);
		argList.add(OPT_ENCODE); //$NON-NLS-1$
		argList.add(encode);
		if((attatchedFileDir != null) && (attatchedFileDir.length() > 0))
		{
			argList.add(OPT_ATTATCH_DIR);
			argList.add(attatchedFileDir);
		}
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}	
		rc = (run(makeArgArray(argList), mode, encode) == 0);
		return rc;
	}

	public boolean doCsvGetFeature(DaRuMaViewerPreference pref,
			DaRuMaServer server, String inFile, String csvcfgFile,String attatchedFileDir,
			String outFile, String encode, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
		boolean rc = false;
		List argList = new ArrayList();
		if (outFile != null) {
			File file = new File(outFile);
			file.delete();
		}
		argList.add(pref.getClientToolDir() + "/" + CMD_CSVGETFEATURE); //$NON-NLS-1$
		if (pref.isDebug())
			argList.add(OPT_DEBUG);
		argList.add(OPT_HOST); //$NON-NLS-1$
		argList.add(server.getHost());
		argList.add(OPT_IN); //$NON-NLS-1$
		argList.add(inFile);
		argList.add(OPT_CSVCFG); //$NON-NLS-1$
		argList.add(csvcfgFile);
		argList.add(OPT_ENCODE); //$NON-NLS-1$
		argList.add(encode);
		if((attatchedFileDir != null) && (attatchedFileDir.length() > 0))
		{
			argList.add(OPT_ATTATCH_DIR);
			argList.add(attatchedFileDir);
		}
		if (outFile != null) {
			argList.add(OPT_OUT); //$NON-NLS-1$
			argList.add(outFile);
		}
//		 変更 2007,01,25
		if(blViewCommand){
		    if(!viewCommand (argList)){
		    	return false;
		    }
		}
		if(blMakebatFile){
		    if(!createbatFile (batFile, argList)){
		        return false;
		    }
		}
		rc = (run(makeArgArray(argList), mode, encode) == 0);
		return rc;
	}
	
	public boolean createbatFile (String cmdFile, List args){
		 
	     boolean rc = false;
		 try{
		      // Fileオブジェクトの作成
		      File batfile = new File(cmdFile);
			  // batFile.batを新規作成する
			  batfile.createNewFile();
			  // Fileオブジェクトを引数にファイル出力ストリームをオープン
		      FileWriter fw = new FileWriter(batfile);
		      
		      // linuxの場合、Fileモードを書き込み可能755に変更
		      if(!osWindows){
		    	  Runtime rt = Runtime.getRuntime();
		    	  String command[] = new String[3]; 
		          command[0] = "chmod";
		          command[1] = "755";
		          command[2] = cmdFile;
		          rt.exec(command);
		      }
		      
		      String commandcsv = args.toString();
		      int len = commandcsv.length();
		      char command[] = null;
		      command = commandcsv.toCharArray();
		      
		      String str = "";
		      String com = null;
		      String comall = osWindows ? "" : "#!/bin/sh\n";
		      for(int i = 0; i <= (len - 1); i++){		      
		    	if((command[i] != '[') && (command[i] != ']') && (command[i] != ',')){	    	    
		   		  com = str + (command[i]);
		   		  comall = comall + com;		   		  		   		  
		    	}		   		 
		      }    
		      
		      fw.write(comall);
		      fw.close();
		      rc = true;
		      
		      }catch(IOException e){
		    	   e.printStackTrace();
		 	  }
		      return rc;
		    
		}


	public boolean viewCommand (List args){
	 
  		  boolean rc = false;
  	
	      String commandcsv = args.toString();
	      int len = commandcsv.length();
	      char command[] = null;
	      command = commandcsv.toCharArray();
	      
	      String str = "";
	      String com = null;
	      String comall = "";
	      for(int i = 0; i <= (len - 1); i++){      
	    	   if((command[i] != '[') && (command[i] != ']') && (command[i] != ',')){  	    
	   		   com = str + (command[i]);
	   		   comall = comall + com;	   		  
	    	   }	   		 
	      }   
	      
	      if(!SwtUtil.showQuestion(Messages.getString("DaRuMaClientAgent.10") + comall)){
	    	  return false;
	      }
	      rc = true;
	      return rc;
	    
	}
}

