package daruma.client.darumaviewer.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.*;

/**
 * ダイアログの汎用クラス このクラスでコンストラクタでタイトル、幅、高さを指定して ダイアログを表示することができる
 * 詳しいことはEclipseドキュメントを参照
 * 
 * @see org.eclipse.jface.dialogs.Dialog
 */
public abstract class GenericDialog extends Dialog implements SelectionListener {
	private Composite composite;

	private String title;

	private int width;

	private int height;

	private String okText = IDialogConstants.OK_LABEL;

	private String cancelText = IDialogConstants.CANCEL_LABEL;

	private boolean allowEscape = true;

	private boolean allowClose = true;

	/**
	 * 指定されたタイトル、幅、高でダイアログを生成します
	 * 
	 * @param parentShell
	 *            親シェル
	 * @param title
	 *            タイトル
	 * @param width
	 *            幅
	 * @param height
	 *            高さ
	 */
	protected GenericDialog(Shell parentShell, String title, int width,
			int height) {
		super(parentShell);
		this.title = title;
		this.width = width;
		this.height = height;
	}

	protected Point getInitialSize() {
		return new Point(width, height);
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(title);
	}

	protected Control createDialogArea(Composite parent) {
		composite = (Composite) super.createDialogArea(parent);
		createPropertyDialogArea(composite);
		return composite;
	}

	protected void createButtonsForButtonBar(Composite parent) {
		if (okText.length() > 0) {
			createButton(parent, IDialogConstants.OK_ID, okText, true);
		}
		if (cancelText.length() > 0) {
			createButton(parent, IDialogConstants.CANCEL_ID,
					IDialogConstants.CANCEL_LABEL, false);
		}
	}

	protected void handleShellCloseEvent() {
		if (allowEscape) {
			super.handleShellCloseEvent();
		}
	}

	/**
	 * ダイアログをオープンする
	 * 
	 * @return ユーザーが押したボタンのID
	 */
	public int open() {
		if (!allowClose)
			this.setShellStyle(this.getShellStyle() & ~SWT.CLOSE);
		return super.open();
	}

	protected void buttonPressed(int buttonId) {
		if (buttonId == IDialogConstants.CLOSE_ID
				|| buttonId == IDialogConstants.FINISH_ID) {
			dialogClose(true);
			setReturnCode(buttonId);
			close();
		} else if (buttonId == IDialogConstants.OK_ID)
			dialogClose(false);
		else if (buttonId == IDialogConstants.CANCEL_ID)
			dialogClose(true);
		super.buttonPressed(buttonId);
	}

	/**
	 * クローズボタンフラグを取得する
	 * 
	 * @return クローズボタンフラグを返す
	 */
	public boolean isAllowClose() {
		return allowClose;
	}

	/**
	 * クローズボタンフラグを設定する
	 * 
	 * @param allowClose
	 *            設定するクローズボタンフラグ
	 */
	public void setAllowClose(boolean allowClose) {
		this.allowClose = allowClose;
	}

	/**
	 * ESCキー有効フラグを取得する
	 * 
	 * @return ESCキー有効フラグを返す
	 */
	public boolean isAllowEscape() {
		return allowEscape;
	}

	/**
	 * ESCキー有効フラグを設定する
	 * 
	 * @param allowEscape
	 *            設定するESCキー有効フラグ
	 */
	public void setAllowEscape(boolean allowEscape) {
		this.allowEscape = allowEscape;
	}

	/**
	 * キャンセルボタンのテキストを取得する
	 * 
	 * @return キャンセルボタンのテキストを返す
	 */
	public String getCancelText() {
		return cancelText;
	}

	/**
	 * キャンセルボタンのテキストを設定する
	 * 
	 * @param cancelText
	 *            設定するキャンセルボタンのテキスト
	 */
	public void setCancelText(String cancelText) {
		this.cancelText = cancelText;
	}

	/**
	 * OKボタンのテキストを取得する
	 * 
	 * @return OKボタンのテキストを返す
	 */
	public String getOkText() {
		return okText;
	}

	/**
	 * OKボタンのテキストを設定する
	 * 
	 * @param okText
	 *            設定するOKボタンのテキスト
	 */
	public void setOkText(String okText) {
		this.okText = okText;
	}

	/**
	 * ダイアログの初期画面を作成する
	 * 
	 * @param composite
	 *            Compositeオブジェクト
	 */
	abstract public void createPropertyDialogArea(Composite composite);

	/**
	 * ダイアログをクローズする
	 * 
	 * @param flgCancel
	 *            キャンセルボタンフラグ
	 */
	abstract public void dialogClose(boolean flgCancel);
}
