package daruma.client.darumaviewer.datamodel;

import java.util.ArrayList;
import java.util.List;

public class DaRuMaTargetNS {
	private String targetNS;

	private List featureTypeList  = new ArrayList();

	/**
	 * FeatureTypeリストサイズを取得する
	 * 
	 * @return FeatureTypeリストサイズ
	 */
	public int getFeatureTypeSize() {
		return featureTypeList.size();
	}

	/**
	 * 指定されたインデックスのFeatureTypeを取得する
	 * 
	 * @return FeatureType
	 */
	public DaRuMaFeatureType getFeatureType(int index) {
		return ((DaRuMaFeatureType) featureTypeList.get(index));
	}
	
	/**
	 * FeatureTypeを追加する
	 * @return 追加されるFeatureType
	 */
	public void addFeatureType(DaRuMaFeatureType featureType) {
		featureTypeList.add(featureType);
	}
	
	/**
	 * featureTypeListを取得する
	 * @return Returns the featureTypeList.
	 */
	public List getFeatureTypeList() {
		return featureTypeList;
	}

	/**
	 * targetNSを取得する
	 * @return Returns the targetNS.
	 */
	public String getTargetNS() {
		return targetNS;
	}

	/**
	 * targetNSをセットする
	 * @param targetNS The targetNS to set.
	 */
	public void setTargetNS(String targetNS) {
		this.targetNS = targetNS;
	}
	
	public boolean equals(Object obj)
	{
		if((obj != null) && (obj instanceof DaRuMaTargetNS))
		{
			return ((DaRuMaTargetNS)obj).targetNS.equals(this.targetNS);
		}
		return false;
	}
}
