package daruma.client.darumaviewer.datamodel;

import java.util.ArrayList;
import java.util.List;

import daruma.client.darumaviewer.Const;
import daruma.client.darumaviewer.Messages;

public class DaRuMaServer {
	public final static int DARUMA_SERVER_STS_NOT_CONNECTED = 0;

	public final static int DARUMA_SERVER_STS_OK = 1;

	public final static int DARUMA_SERVER_STS_ERR = 2;

	private String host;

	private int port;

	private int sts = DARUMA_SERVER_STS_NOT_CONNECTED;

	private boolean featureTypeValid = false;

	private List featureTypeList = new ArrayList();

	private List targetNSList = new ArrayList();

	public DaRuMaServer(String host, int port) {
		this.host = host;
		this.port = port;
	}

	/**
	 * hostを取得する
	 * 
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * hostをセットする
	 * 
	 * @param host
	 *            The host to set.
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * stsを取得する
	 * 
	 * @return Returns the sts.
	 */
	public int getSts() {
		return sts;
	}

	/**
	 * stsをセットする
	 * 
	 * @param sts
	 *            The sts to set.
	 */
	public void setSts(int sts) {
		this.sts = sts;
	}

	/**
	 * stsを取得する
	 * 
	 * @return Returns the sts.
	 */
	public String getStsName() {
		String stsName = ""; //$NON-NLS-1$
		switch (sts) {
		case DARUMA_SERVER_STS_OK:
			stsName = Messages.getString("DaRuMaServer.1"); //$NON-NLS-1$
			break;
		case DARUMA_SERVER_STS_ERR:
			stsName = Messages.getString("DaRuMaServer.2"); //$NON-NLS-1$
			break;
		case DARUMA_SERVER_STS_NOT_CONNECTED:
			stsName = Messages.getString("DaRuMaServer.3"); //$NON-NLS-1$
			break;
		}
		return stsName;
	}

	/**
	 * portを取得する
	 * 
	 * @return Returns the port.
	 */
	public int getPort() {
		return port;
	}

	/**
	 * portをセットする
	 * 
	 * @param port
	 *            The port to set.
	 */
	public void setPort(int port) {
		this.port = port;
	}

	public String getName() {
		if (Const.USE_PORT)
			return host + ":" + port; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		else
			return host;
	}

	/**
	 * FeatureTypeリストサイズを取得する
	 * 
	 * @return FeatureTypeリストサイズ
	 */
	public int getFeatureTypeSize() {
		return featureTypeValid ? featureTypeList.size() : -1;
	}

	/**
	 * 指定されたインデックスのFeatureTypeを取得する
	 * 
	 * @return FeatureType
	 */
	public DaRuMaFeatureType getFeatureType(int index) {
		return featureTypeValid ? ((DaRuMaFeatureType) featureTypeList
				.get(index)) : null;
	}

	/**
	 * FeatureTypeを追加する
	 * 
	 * @return 追加されるFeatureType
	 */
	public DaRuMaFeatureType addNewFeatureType() {
		DaRuMaFeatureType featureType = new DaRuMaFeatureType(this);
		featureTypeList.add(featureType);
		return featureType;
	}

	/**
	 * featureTypeListを取得する
	 * 
	 * @return Returns the featureTypeList.
	 */
	public List getFeatureTypeList() {
		return featureTypeList;
	}

	/**
	 * TargetNSリストサイズを取得する
	 * 
	 * @return TargetNSリストサイズ
	 */
	public int getTargetNSSize() {
		return featureTypeValid ? targetNSList.size() : -1;
	}

	/**
	 * 指定されたインデックスのTargetNSを取得する
	 * 
	 * @return TargetNS
	 */
	public DaRuMaTargetNS getTargetNS(int index) {
		return featureTypeValid ? ((DaRuMaTargetNS) targetNSList.get(index))
				: null;
	}

	/**
	 * targetNSListを取得する
	 * 
	 * @return Returns the targetNSList.
	 */
	public List getTargetNSList() {
		return targetNSList;
	}

	/**
	 * featureTypeValidを取得する
	 * 
	 * @return Returns the featureTypeValid.
	 */
	public boolean isFeatureTypeValid() {
		return featureTypeValid;
	}

	/**
	 * featureTypeValidをセットする
	 * 
	 * @param featureTypeValid
	 *            The featureTypeValid to set.
	 */
	public void setFeatureTypeValid(boolean featureTypeValid) {
		this.featureTypeValid = featureTypeValid;
		if (!featureTypeValid) {
			featureTypeList.clear();
			targetNSList.clear();
		}
	}

	/**
	 * FeatureTypeリストからTargetNSリストを作成する
	 *
	 */
	public void makeTargetNSList() {
		targetNSList.clear();
		for (int cnt = 0; cnt < featureTypeList.size(); cnt++) {
			DaRuMaFeatureType featureType = (DaRuMaFeatureType) featureTypeList
					.get(cnt);
			DaRuMaTargetNS targetNS = new DaRuMaTargetNS();
			targetNS.setTargetNS(featureType.getTargetNS());

			int index = targetNSList.indexOf(targetNS);
			if (index >= 0)
				targetNS = (DaRuMaTargetNS) targetNSList.get(index);
			else
				targetNSList.add(targetNS);
			targetNS.addFeatureType(featureType);
		}
	}

}
