package daruma.client.darumaviewer;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;

import daruma.client.darumaviewer.prefs.DaRuMaViewerPreference;



/**
 * The main plugin class to be used in the desktop.
 */
public class DaRuMaViewerPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static DaRuMaViewerPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public DaRuMaViewerPlugin() {
		plugin = this;
	}

	public static Preferences getPreferences()
	{
		DaRuMaViewerPreference.initializeDefaults(DaRuMaViewerPlugin.getDefault().getPreferenceStore());
		return DaRuMaViewerPlugin.getDefault().getPluginPreferences();
	}
	
	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static DaRuMaViewerPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("aist.daruma.client.darumaviewer", path);
	}
}
