package daruma.client.darumaviewer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

//import daruma.client.schemaeditor.Messages;
import daruma.client.darumaviewer.action.ExitAction;



public class ApplicationActionBarAdvisor extends ActionBarAdvisor implements
		IMenuListener {

	// Actions - important to allocate these only in makeActions, and then use
	// them
	// in the fill methods. This ensures that the actions aren't recreated
	// when fillActionBars is called with FILL_PROXY.
	private Action exitAction;
	private IWorkbenchAction aboutAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
    	
		aboutAction = ActionFactory.ABOUT.create(window);
		register(aboutAction);

		/**
		 * 終了Action
		 */
		exitAction = ExitAction.makeAction();
		exitAction.setText(Messages.getString("ApplicationActionBarAdvisor.0")); //$NON-NLS-1$
		exitAction.setToolTipText(Messages
				.getString("ApplicationActionBarAdvisor.8")); //$NON-NLS-1$
    }

    protected void fillMenuBar(IMenuManager menuBar) {
    	
		MenuManager fileMenu = new MenuManager(Messages
				.getString("ApplicationActionBarAdvisor.7"), //$NON-NLS-1$
				IWorkbenchActionConstants.M_FILE);
		menuBar.add(fileMenu);
		fileMenu.addMenuListener(this);
		fileMenu.add(exitAction);
		
    }
    
	public void menuAboutToShow(IMenuManager manager) {



		exitAction.setEnabled(true);



		manager.update();

	}
    
}
