/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.DependentPolicy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class RegisteredPolicy
extends DependentPolicy {
    public RegisteredPolicy(BundleLoader requester) {
        super(requester);
        if (this.allDependents == null) {
            return;
        }
        Iterator iter = this.allDependents.iterator();
        while (iter.hasNext()) {
            BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)iter.next());
            if (proxy == null) {
                iter.remove();
            }
            try {
                String[] allContributions = ManifestElement.getArrayFromList((String)((AbstractBundle)proxy.getBundle()).getBundleData().getManifest().get("Eclipse-RegisterBuddy"));
                if (allContributions == null) {
                    iter.remove();
                    continue;
                }
                boolean contributes = false;
                int j = 0;
                while (j < allContributions.length && !contributes) {
                    if (allContributions[j].equals(this.buddyRequester.bundle.getSymbolicName())) {
                        contributes = true;
                    }
                    ++j;
                }
                if (contributes) continue;
                iter.remove();
            }
            catch (BundleException bundleException) {
                iter.remove();
            }
        }
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    public Class loadClass(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Class result = null;
        int size = this.allDependents.size();
        int i = 0;
        while (i < size && result == null) {
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)this.allDependents.get(i));
                if (proxy != null) {
                    result = proxy.getBundleLoader().findClass(name, true);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++i;
        }
        return result;
    }

    public URL loadResource(String name) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        int size = this.allDependents.size();
        int i = 0;
        while (i < size && result == null) {
            BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)this.allDependents.get(i));
            if (proxy != null) {
                result = proxy.getBundleLoader().findResource(name, true);
            }
            ++i;
        }
        return result;
    }

    public Enumeration loadResources(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Vector resources = null;
        int size = this.allDependents.size();
        int i = 0;
        while (i < size) {
            try {
                Enumeration result;
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)this.allDependents.get(i));
                if (proxy != null && (result = proxy.getBundleLoader().findResources(name)) != null) {
                    if (resources == null) {
                        resources = new Vector();
                    }
                    while (result.hasMoreElements()) {
                        Object url = result.nextElement();
                        if (resources.contains(url)) continue;
                        resources.add(url);
                    }
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        return resources == null ? null : resources.elements();
    }
}

