/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.commands.common.AbstractBitSetEvent;
import org.eclipse.ui.internal.menus.SMenuManager;

public final class MenuManagerEvent
extends AbstractBitSetEvent {
    private static final int CHANGED_ACTION_SET_DEFINED = 1;
    private static final int CHANGED_GROUP_DEFINED = 2;
    private static final int CHANGED_ITEM_DEFINED = 4;
    private static final int CHANGED_MENU_DEFINED = 8;
    private static final int CHANGED_WIDGET_DEFINED = 16;
    private final String actionSetId;
    private final String groupId;
    private final String itemId;
    private final String menuId;
    private final SMenuManager menuManager;
    private final String widgetId;

    MenuManagerEvent(SMenuManager menuManager, String groupId, boolean groupIdAdded, String itemId, boolean itemIdAdded, String menuId, boolean menuIdAdded, String widgetId, boolean widgetIdAdded, String actionSetId, boolean actionSetIdAdded) {
        if (menuManager == null) {
            throw new NullPointerException("An event must refer to its menu manager");
        }
        this.menuManager = menuManager;
        this.groupId = groupId;
        this.itemId = itemId;
        this.menuId = menuId;
        this.widgetId = widgetId;
        this.actionSetId = actionSetId;
        if (groupIdAdded) {
            this.changedValues |= 2;
        }
        if (itemIdAdded) {
            this.changedValues |= 4;
        }
        if (menuIdAdded) {
            this.changedValues |= 8;
        }
        if (widgetIdAdded) {
            this.changedValues |= 0x10;
        }
        if (actionSetIdAdded) {
            this.changedValues |= 1;
        }
    }

    public final String getActionSetId() {
        return this.groupId;
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final String getItemId() {
        return this.itemId;
    }

    public final String getMenuId() {
        return this.menuId;
    }

    public final SMenuManager getMenuManager() {
        return this.menuManager;
    }

    public final String getWidgetId() {
        return this.widgetId;
    }

    public final boolean isActionSetChanged() {
        return this.actionSetId != null;
    }

    public final boolean isActionSetDefined() {
        return (this.changedValues & 1) != 0 && this.actionSetId != null;
    }

    public final boolean isGroupChanged() {
        return this.groupId != null;
    }

    public final boolean isGroupDefined() {
        return (this.changedValues & 2) != 0 && this.groupId != null;
    }

    public final boolean isItemChanged() {
        return this.itemId != null;
    }

    public final boolean isItemDefined() {
        return (this.changedValues & 4) != 0 && this.itemId != null;
    }

    public final boolean isMenuChanged() {
        return this.menuId != null;
    }

    public final boolean isMenuDefined() {
        return (this.changedValues & 8) != 0 && this.menuId != null;
    }

    public final boolean isWidgetChanged() {
        return this.widgetId != null;
    }

    public final boolean isWidgetDefined() {
        return (this.changedValues & 0x10) != 0 && this.widgetId != null;
    }
}

