/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.views;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.Perspective;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.datamodel.DaRuMaServerList;
import daruma.client.darumaviewer.datamodel.DaRuMaTargetNS;
import daruma.client.darumaviewer.datamodel.TreeObject;
import daruma.client.darumaviewer.dialogs.AddServerDialog;
import daruma.client.darumaviewer.dialogs.PreferenceDialog;
import daruma.client.darumaviewer.prefs.DaRuMaViewerPreference;
import daruma.client.darumaviewer.service.DaRuMaViewerService;
import daruma.client.darumaviewer.views.DaRuMaViewerViewProvider;
import daruma.client.darumaviewer.views.FeatureTypeView;
import daruma.client.darumaviewer.views.RunCommandView;
import daruma.client.darumaviewer.views.SwtUtil;
import java.io.File;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DaRuMaViewerView
extends ViewPart {
    public static DaRuMaViewerPreference dftPref = new DaRuMaViewerPreference();
    public static DaRuMaViewerService dftService = new DaRuMaViewerService();
    private TreeViewer treeViewer;
    private Composite composite;
    private DaRuMaServerList currServerList = new DaRuMaServerList();
    private Action actPref;
    private Action actGetFeatureTypes;
    private Action actGetFeatureTypeInfo;
    private Action actXmlGetFeature;
    private Action actCsvGetFeature;
    private Action actRunCommand;
    private Action actServerAdd;
    private Action actServerDel;
    private static String SEPERATOR_SERVERS = ",";
    private static String SEPERATOR_HOST_PORT = ":";
    private DaRuMaViewerViewProvider.FeatureTypeTreeContentProvider contentProvider;
    protected static Logger logger = LogManager.getLogger(DaRuMaViewerView.class.getClass());
    public static final String ID = DaRuMaViewerView.class.getName();
    public static int DFT_SERVERS_EXPAND_LEVEL = 2;
    public static int DFT_FEATURETYPES_EXPAND_LEVEL = 1;

    public void createPartControl(Composite parent) {
        this.setPartName(Messages.getString("DaRuMaViewerView.20"));
        dftPref.load();
        this.loadServerList(this.currServerList, dftPref);
        this.composite = parent;
        this.makeActions();
        this.treeViewer = new TreeViewer(this.composite, 772);
        this.contentProvider = new DaRuMaViewerViewProvider.FeatureTypeTreeContentProvider();
        this.contentProvider.setDisplayTargetNS(dftPref.isDisplayTargetNS());
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DaRuMaViewerViewProvider.FeatureTypeTreeLabelProvider());
        this.treeViewer.getTree().addMouseMoveListener((MouseMoveListener)new TreeMouseMoveListener(this, this.treeViewer));
        this.treeViewer.setInput((Object)this.currServerList);
        this.treeViewer.setSorter((ViewerSorter)new NameSorter());
        this.treeViewer.expandAll();
        this.makeTreeViewerContextMenu(this.treeViewer);
    }

    private void loadServerList(DaRuMaServerList serverList, DaRuMaViewerPreference pref) {
        serverList.clear();
        if (pref.getServers().length() > 0) {
            String[] servers = pref.getServers().split(SEPERATOR_SERVERS);
            int cnt = 0;
            while (cnt < servers.length) {
                String server = servers[cnt];
                int temp = server.indexOf(SEPERATOR_HOST_PORT);
                String host = server;
                int port = 5050;
                if (temp >= 0) {
                    host = server.substring(0, temp);
                    try {
                        port = temp = Integer.parseInt(server.substring(temp + 1));
                    }
                    catch (Exception exception) {}
                }
                serverList.add(new DaRuMaServer(host, port));
                ++cnt;
            }
        }
    }

    private void saveServerList(DaRuMaServerList serverList, DaRuMaViewerPreference pref) {
        String servers = "";
        int cnt = 0;
        while (cnt < serverList.size()) {
            if (cnt > 0) {
                servers = String.valueOf(servers) + SEPERATOR_SERVERS;
            }
            DaRuMaServer server = (DaRuMaServer)serverList.get(cnt);
            servers = String.valueOf(servers) + server.getHost() + SEPERATOR_HOST_PORT + server.getPort();
            ++cnt;
        }
        pref.setServers(servers);
        pref.save();
    }

    public void setFocus() {
    }

    private void makeTreeViewerContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new TreeViewerMenuListener());
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void makeActions() {
        Action[] actions = new Action[8];
        int cnt = 0;
        while (cnt < actions.length) {
            actions[cnt] = new Action(){

                public void run() {
                    DaRuMaViewerView.this.handleActions(this);
                }
            };
            ++cnt;
        }
        this.actPref = actions[0];
        this.actPref.setText(Messages.getString("DaRuMaViewerView.21"));
        this.actPref.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.actGetFeatureTypes = actions[1];
        this.actGetFeatureTypes.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.actGetFeatureTypeInfo = actions[2];
        this.actGetFeatureTypeInfo.setText(Messages.getString("DaRuMaViewerView.23"));
        this.actGetFeatureTypeInfo.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.actXmlGetFeature = actions[3];
        this.actXmlGetFeature.setText(Messages.getString("DaRuMaViewerView.24"));
        this.actXmlGetFeature.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.actCsvGetFeature = actions[4];
        this.actCsvGetFeature.setText(Messages.getString("DaRuMaViewerView.25"));
        this.actCsvGetFeature.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.actRunCommand = actions[5];
        this.actRunCommand.setText(Messages.getString("DaRuMaViewerView.213"));
        this.actRunCommand.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.actServerAdd = actions[6];
        this.actServerAdd.setText(Messages.getString("DaRuMaViewerView.3"));
        this.actServerAdd.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.actServerDel = actions[7];
        this.actServerDel.setText(Messages.getString("DaRuMaViewerView.4"));
        this.actServerDel.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public TreeObject getCurrTreeObject(TreeViewer viewer) {
        ISelection selection = viewer.getSelection();
        Object item = ((IStructuredSelection)selection).getFirstElement();
        if (item instanceof TreeObject) {
            return (TreeObject)item;
        }
        return null;
    }

    public DaRuMaFeatureType getCurrFeatureType(TreeViewer viewer) {
        Object data;
        TreeObject treeObj = this.getCurrTreeObject(viewer);
        if (treeObj != null && (data = treeObj.getData()) instanceof DaRuMaFeatureType) {
            return (DaRuMaFeatureType)data;
        }
        return null;
    }

    public DaRuMaServer getCurrServer(TreeViewer viewer) {
        Object data;
        TreeObject treeObj = this.getCurrTreeObject(viewer);
        if (treeObj != null && (data = treeObj.getData()) instanceof DaRuMaServer) {
            return (DaRuMaServer)data;
        }
        return null;
    }

    private void setupPref(DaRuMaViewerPreference pref) {
        PreferenceDialog dialog = new PreferenceDialog(this.getSite().getShell(), pref);
        dialog.open();
        if (dftPref.isDisplayTargetNS() != this.contentProvider.isDisplayTargetNS()) {
            this.contentProvider.setDisplayTargetNS(pref.isDisplayTargetNS());
            this.updateAll();
        }
    }

    private boolean validatePref(DaRuMaViewerPreference pref) {
        File clientDir;
        boolean rc = true;
        File workDir = new File(pref.getWorkDir());
        workDir.mkdirs();
        if (!workDir.exists() || !workDir.isDirectory()) {
            SwtUtil.showError(Messages.getString("DaRuMaViewerView.214"));
            rc = false;
        }
        if (!(clientDir = new File(pref.getClientToolDir())).exists() || !clientDir.isDirectory()) {
            SwtUtil.showError(Messages.getString("DaRuMaViewerView.215"));
            rc = false;
        }
        return rc;
    }

    private boolean checkPref(DaRuMaViewerPreference pref) {
        boolean rc = this.validatePref(pref);
        if (!rc) {
            this.setupPref(pref);
            rc = this.validatePref(pref);
        }
        return rc;
    }

    private void handleActions(Action action) {
        TreeObject currTreeObject = this.getCurrTreeObject(this.treeViewer);
        DaRuMaFeatureType currFeatureType = this.getCurrFeatureType(this.treeViewer);
        DaRuMaServer currServer = this.getCurrServer(this.treeViewer);
        if (action == this.actPref) {
            this.setupPref(dftPref);
        } else if (action == this.actServerAdd) {
            AddServerDialog dialog = new AddServerDialog(this.getSite().getShell());
            dialog.open();
            DaRuMaServer newServer = dialog.getNewServer();
            if (newServer != null) {
                this.updateServerList(newServer, true);
            }
        } else if (action == this.actServerDel) {
            if (currServer != null && SwtUtil.showQuestion(String.valueOf(Messages.getString("DaRuMaViewerView.5")) + currServer.getName() + Messages.getString("DaRuMaViewerView.6"))) {
                this.updateServerList(currServer, false);
            }
        } else if (this.checkPref(dftPref)) {
            if (action == this.actGetFeatureTypes) {
                if (!dftService.getFeatureTypes(dftPref, currServer)) {
                    SwtUtil.showError(Messages.getString("DaRuMaViewerView.29"));
                }
                this.updateFeatureTypeList(currTreeObject);
            } else if (action == this.actGetFeatureTypeInfo) {
                if (currFeatureType != null) {
                    FeatureTypeView view = (FeatureTypeView)SwtUtil.showView(Perspective.topFolder, FeatureTypeView.ID, currFeatureType.getTypeName());
                    view.setFeatureType(currFeatureType);
                }
            } else if (action == this.actRunCommand) {
                if (currServer != null) {
                    RunCommandView view = (RunCommandView)SwtUtil.showView(Perspective.topFolder, RunCommandView.ID, currServer.getName());
                    view.setCurrServer(currServer);
                }
            } else if (action == this.actXmlGetFeature || action == this.actCsvGetFeature) {
                if (currFeatureType != null) {
                    RunCommandView view = (RunCommandView)SwtUtil.showView(Perspective.topFolder, RunCommandView.ID, currFeatureType.getServer().getName());
                    view.setCurrServer(currFeatureType.getServer());
                    view.setXmlGetFeature(currFeatureType, action == this.actXmlGetFeature);
                }
            } else {
                SwtUtil.showInfo(Messages.getString("DaRuMaViewerView.9"));
            }
        }
    }

    private void updateAll() {
        this.treeViewer.refresh();
        this.treeViewer.expandToLevel(DFT_SERVERS_EXPAND_LEVEL);
    }

    private void updateServerList(DaRuMaServer server, boolean flgAdd) {
        if (flgAdd) {
            this.currServerList.add(server);
        } else {
            this.currServerList.remove(server);
        }
        this.saveServerList(this.currServerList, dftPref);
        this.updateAll();
    }

    private void updateFeatureTypeList(TreeObject treeObj) {
        this.treeViewer.refresh((Object)treeObj);
        this.treeViewer.expandToLevel((Object)treeObj, DFT_FEATURETYPES_EXPAND_LEVEL);
    }

    public boolean closeFile() {
        return this.closeFile(true);
    }

    private boolean closeFile(boolean blSave) {
        boolean rc = false;
        rc = true;
        return rc;
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private class TreeViewerMenuListener
    implements IMenuListener {
        private TreeViewerMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            ISelection selection = DaRuMaViewerView.this.treeViewer.getSelection();
            Object item = ((IStructuredSelection)selection).getFirstElement();
            if (item instanceof TreeObject) {
                TreeObject treeObj = (TreeObject)item;
                Object data = treeObj.getData();
                if (data instanceof List) {
                    manager.add((IAction)DaRuMaViewerView.this.actPref);
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)DaRuMaViewerView.this.actServerAdd);
                }
                if (data instanceof DaRuMaServer) {
                    DaRuMaViewerView.this.actGetFeatureTypes.setText(((DaRuMaServer)data).isFeatureTypeValid() ? Messages.getString("DaRuMaViewerView.12") : Messages.getString("DaRuMaViewerView.22"));
                    manager.add((IAction)DaRuMaViewerView.this.actGetFeatureTypes);
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)DaRuMaViewerView.this.actServerDel);
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)DaRuMaViewerView.this.actRunCommand);
                } else if (data instanceof DaRuMaFeatureType) {
                    manager.add((IAction)DaRuMaViewerView.this.actGetFeatureTypeInfo);
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)DaRuMaViewerView.this.actXmlGetFeature);
                    manager.add((IAction)DaRuMaViewerView.this.actCsvGetFeature);
                }
            }
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    public class TreeMouseMoveListener
    implements MouseMoveListener {
        TreeItem prevItem;
        DaRuMaViewerView view;
        TreeViewer viewer;

        public TreeMouseMoveListener(DaRuMaViewerView view, TreeViewer viewer) {
            this.view = view;
            this.viewer = viewer;
        }

        public void mouseMove(MouseEvent e) {
            if (e.widget != null && e.widget instanceof Tree) {
                Object obj;
                Tree tree = (Tree)e.widget;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && (obj = item.getData()) instanceof TreeObject) {
                    TreeObject treeObj = (TreeObject)obj;
                    Object data = treeObj.getData();
                    String tip = "";
                    if (data instanceof DaRuMaFeatureType) {
                        tip = ((DaRuMaFeatureType)data).getName();
                    } else if (data instanceof DaRuMaServer) {
                        int size = ((DaRuMaServer)data).getFeatureTypeSize();
                        if (size < 0) {
                            tip = Messages.getString("DaRuMaViewerView.2");
                        } else {
                            tip = String.valueOf(Messages.getString("DaRuMaViewerView.10")) + ((DaRuMaServer)data).getTargetNSSize();
                            tip = String.valueOf(tip) + Messages.getString("DaRuMaViewerView.11");
                            tip = String.valueOf(tip) + Messages.getString("DaRuMaViewerView.1") + size;
                        }
                    } else if (data instanceof DaRuMaTargetNS) {
                        tip = String.valueOf(Messages.getString("DaRuMaViewerView.1")) + ((DaRuMaTargetNS)data).getFeatureTypeSize();
                    } else if (data instanceof DaRuMaServerList) {
                        tip = String.valueOf(Messages.getString("DaRuMaViewerView.0")) + ((DaRuMaServerList)data).size();
                    }
                    if (this.prevItem != item) {
                        tree.setToolTipText(tip.length() > 0 ? tip : "");
                    }
                }
                this.prevItem = item;
            }
        }
    }
}

