/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.internal.commands.util.Util;

public final class Command
extends NamedHandleObject
implements Comparable {
    public static boolean DEBUG_COMMAND_EXECUTION = false;
    public static boolean DEBUG_HANDLERS = false;
    public static String DEBUG_HANDLERS_COMMAND_ID = null;
    private Category category = null;
    private transient Collection commandListeners = null;
    private transient Collection executionListeners = null;
    private transient IHandler handler = null;
    private IParameter[] parameters = null;

    Command(String id) {
        super(id);
    }

    public final void addCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException("Cannot add a null command listener");
        }
        if (this.commandListeners == null) {
            this.commandListeners = new ArrayList(1);
        } else if (this.commandListeners.contains(commandListener)) {
            return;
        }
        this.commandListeners.add(commandListener);
    }

    public final void addExecutionListener(IExecutionListener executionListener) {
        if (executionListener == null) {
            throw new NullPointerException("Cannot add a null execution listener");
        }
        if (this.executionListeners == null) {
            this.executionListeners = new ArrayList(1);
        } else if (this.executionListeners.contains(executionListener)) {
            return;
        }
        this.executionListeners.add(executionListener);
    }

    public final int compareTo(Object object) {
        Command castedObject = (Command)object;
        int compareTo = Util.compare(this.category, castedObject.category);
        if (compareTo == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)castedObject.description))) == 0 && (compareTo = Util.compare(this.handler, castedObject.handler)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0 && (compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name))) == 0) {
            compareTo = Util.compare(this.parameters, castedObject.parameters);
        }
        return compareTo;
    }

    public final void define(String name, String description, Category category, IParameter[] parameters) {
        if (name == null) {
            throw new NullPointerException("The name of a command cannot be null");
        }
        if (category == null) {
            throw new NullPointerException("The category of a command cannot be null");
        }
        boolean definedChanged = !this.defined;
        this.defined = true;
        boolean nameChanged = !Util.equals(this.name, name);
        this.name = name;
        boolean descriptionChanged = !Util.equals(this.description, description);
        this.description = description;
        boolean categoryChanged = !Util.equals(this.category, category);
        this.category = category;
        boolean parametersChanged = !Util.equals(this.parameters, parameters);
        this.parameters = parameters;
        this.fireCommandChanged(new CommandEvent(this, categoryChanged, definedChanged, descriptionChanged, false, nameChanged, parametersChanged));
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Command)) {
            return false;
        }
        Command command = (Command)object;
        return Util.equals(this.id, command.id);
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException, NotHandledException {
        this.firePreExecute(event);
        IHandler handler = this.handler;
        if (DEBUG_COMMAND_EXECUTION) {
            System.out.print("COMMANDS >>> executing ");
            if (handler == null) {
                System.out.print("no handler");
            } else {
                System.out.print('\'');
                System.out.print(handler.getClass().getName());
                System.out.print("'(");
                System.out.print(handler.hashCode());
                System.out.print(')');
            }
            System.out.println();
        }
        if (handler != null && handler.isHandled()) {
            try {
                Object returnValue = handler.execute(event);
                this.firePostExecuteSuccess(returnValue);
                return returnValue;
            }
            catch (ExecutionException e) {
                this.firePostExecuteFailure(e);
                throw e;
            }
        }
        NotHandledException e = new NotHandledException("There is no handler to execute.");
        this.fireNotHandled(e);
        throw e;
    }

    private final void fireCommandChanged(CommandEvent commandEvent) {
        int commandListenersSize;
        if (commandEvent == null) {
            throw new NullPointerException("Cannot fire a null event");
        }
        if (this.commandListeners != null && (commandListenersSize = this.commandListeners.size()) > 0) {
            ICommandListener[] listeners = this.commandListeners.toArray(new ICommandListener[commandListenersSize]);
            int i = 0;
            while (i < commandListenersSize) {
                ICommandListener listener = listeners[i];
                listener.commandChanged(commandEvent);
                ++i;
            }
        }
    }

    private final void fireNotHandled(NotHandledException e) {
        int executionListenersSize;
        if (this.executionListeners != null && (executionListenersSize = this.executionListeners.size()) > 0) {
            IExecutionListener[] listeners = this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
            int i = 0;
            while (i < executionListenersSize) {
                IExecutionListener listener = listeners[i];
                listener.notHandled(this.getId(), e);
                ++i;
            }
        }
    }

    private final void firePostExecuteFailure(ExecutionException e) {
        int executionListenersSize;
        if (this.executionListeners != null && (executionListenersSize = this.executionListeners.size()) > 0) {
            IExecutionListener[] listeners = this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
            int i = 0;
            while (i < executionListenersSize) {
                IExecutionListener listener = listeners[i];
                listener.postExecuteFailure(this.getId(), e);
                ++i;
            }
        }
    }

    private final void firePostExecuteSuccess(Object returnValue) {
        int executionListenersSize;
        if (this.executionListeners != null && (executionListenersSize = this.executionListeners.size()) > 0) {
            IExecutionListener[] listeners = this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
            int i = 0;
            while (i < executionListenersSize) {
                IExecutionListener listener = listeners[i];
                listener.postExecuteSuccess(this.getId(), returnValue);
                ++i;
            }
        }
    }

    private final void firePreExecute(ExecutionEvent event) {
        int executionListenersSize;
        if (this.executionListeners != null && (executionListenersSize = this.executionListeners.size()) > 0) {
            IExecutionListener[] listeners = this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
            int i = 0;
            while (i < executionListenersSize) {
                IExecutionListener listener = listeners[i];
                listener.preExecute(this.getId(), event);
                ++i;
            }
        }
    }

    public final Category getCategory() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the category from an undefined command");
        }
        return this.category;
    }

    public final IParameter[] getParameters() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the parameters from an undefined command");
        }
        if (this.parameters == null || this.parameters.length == 0) {
            return null;
        }
        IParameter[] returnValue = new IParameter[this.parameters.length];
        System.arraycopy(this.parameters, 0, returnValue, 0, this.parameters.length);
        return returnValue;
    }

    public final boolean isEnabled() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.isHandled() && this.handler.isEnabled();
    }

    public final boolean isHandled() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.isHandled();
    }

    public final void removeCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException("Cannot remove a null command listener");
        }
        if (this.commandListeners != null) {
            this.commandListeners.remove(commandListener);
        }
    }

    public final void removeExecutionListener(IExecutionListener executionListener) {
        if (executionListener == null) {
            throw new NullPointerException("Cannot remove a null execution listener");
        }
        if (this.executionListeners != null) {
            this.executionListeners.remove(executionListener);
        }
    }

    public final boolean setHandler(IHandler handler) {
        if (Util.equals(handler, this.handler)) {
            return false;
        }
        this.handler = handler;
        this.string = null;
        if (DEBUG_HANDLERS && (DEBUG_HANDLERS_COMMAND_ID == null || DEBUG_HANDLERS_COMMAND_ID.equals(this.id))) {
            System.out.print("HANDLERS >>> Command('" + this.id + "') has changed to ");
            if (handler == null) {
                System.out.println("no handler");
            } else {
                System.out.print("'");
                System.out.print(handler);
                System.out.println("' as its handler");
            }
        }
        this.fireCommandChanged(new CommandEvent(this, false, false, false, true, false, false));
        return true;
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Command(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.category);
            stringBuffer.append(',');
            stringBuffer.append(this.handler);
            stringBuffer.append(',');
            stringBuffer.append(this.parameters);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        boolean definedChanged = this.defined;
        this.defined = false;
        boolean nameChanged = this.name != null;
        this.name = null;
        boolean descriptionChanged = this.description != null;
        this.description = null;
        boolean categoryChanged = this.category != null;
        this.category = null;
        boolean parametersChanged = this.parameters != null;
        this.parameters = null;
        this.fireCommandChanged(new CommandEvent(this, categoryChanged, definedChanged, descriptionChanged, false, nameChanged, parametersChanged));
    }
}

