/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.components.framework.IDisposable;
import org.eclipse.ui.internal.part.IPartPropertyProvider;
import org.eclipse.ui.internal.part.components.services.IDirtyHandler;
import org.eclipse.ui.internal.part.components.services.IInputHandler;
import org.eclipse.ui.internal.part.components.services.INameable;
import org.eclipse.ui.internal.part.components.services.IPartDescriptor;
import org.eclipse.ui.internal.util.Util;

public class PartPropertyProvider
implements IPartPropertyProvider,
INameable,
IDirtyHandler,
IDisposable,
IInputHandler {
    private INameable nameable;
    private IDirtyHandler dirty;
    private List listeners = new ArrayList();
    private String tooltip = "";
    private String partName;
    private String contentDescription = "";
    private String title = "";
    private boolean isDirty = false;
    private ImageDescriptor titleImage;
    private Image image = null;
    private IEditorInput input;
    private ResourceManager mgr;

    public PartPropertyProvider(ResourceManager manager, INameable parentNameable, IDirtyHandler dirtyListener, IPartDescriptor descriptor, IEditorInput initialInput) {
        this.nameable = parentNameable;
        this.dirty = dirtyListener;
        this.partName = descriptor.getLabel();
        this.titleImage = descriptor.getImage();
        this.input = initialInput;
        this.mgr = manager;
    }

    private ResourceManager getManager() {
        if (this.mgr == null) {
            this.mgr = JFaceResources.getResources();
        }
        return this.mgr;
    }

    public void addPropertyListener(IWorkbenchPart part, IPropertyListener l) {
        this.listeners.add(new ListenerRec(l, part));
    }

    public void removePropertyListener(IWorkbenchPart part, IPropertyListener l) {
        this.listeners.remove(new ListenerRec(l, part));
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleToolTip() {
        return this.tooltip;
    }

    public Image getTitleImage() {
        if (this.image == null) {
            if (this.titleImage == null) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
            }
            this.image = this.getManager().createImageWithDefault(this.titleImage);
        }
        return this.image;
    }

    public String getPartName() {
        return this.partName;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void dispose() {
        this.listeners.clear();
        if (this.image != null) {
            this.getManager().destroy((DeviceResourceDescriptor)this.titleImage);
        }
    }

    public void setContentDescription(String contentDescription) {
        if (this.contentDescription.equals(contentDescription)) {
            return;
        }
        this.contentDescription = contentDescription;
        if (this.nameable != null) {
            this.nameable.setContentDescription(contentDescription);
        }
        this.firePropertyChange(261);
    }

    public void setDirty(boolean isDirty) {
        if (isDirty == this.isDirty) {
            return;
        }
        this.isDirty = isDirty;
        if (this.dirty != null) {
            this.dirty.setDirty(isDirty);
        }
        this.firePropertyChange(257);
    }

    public void setImage(ImageDescriptor theImage) {
        ImageDescriptor oldImageDescriptor = this.titleImage;
        Image oldImage = this.image;
        if (oldImageDescriptor == theImage) {
            return;
        }
        this.titleImage = theImage;
        this.image = null;
        if (this.nameable != null) {
            this.nameable.setImage(theImage);
        }
        this.firePropertyChange(1);
        if (oldImage != null) {
            this.getManager().destroy((DeviceResourceDescriptor)oldImageDescriptor);
        }
    }

    public void setName(String newName) {
        if (this.partName.equals(newName)) {
            return;
        }
        this.partName = newName;
        if (this.nameable != null) {
            this.nameable.setName(newName);
        }
        this.firePropertyChange(260);
        this.setDefaultTitle();
    }

    public void setTooltip(String toolTip) {
        if (this.tooltip.equals(toolTip)) {
            return;
        }
        this.tooltip = toolTip;
        if (this.nameable != null) {
            this.nameable.setTooltip(toolTip);
        }
        this.firePropertyChange(1);
    }

    public void setEditorInput(IEditorInput input) {
        if (this.input.equals(input)) {
            return;
        }
        this.input = input;
        this.firePropertyChange(258);
    }

    private void setTitle(String newTitle) {
        if (newTitle.equals(this.title)) {
            return;
        }
        this.title = newTitle;
        this.firePropertyChange(1);
    }

    void setDefaultTitle() {
        String name;
        String description = this.getContentDescription();
        String newTitle = name = this.getPartName();
        if (!Util.equals(description, "")) {
            newTitle = MessageFormat.format(WorkbenchMessages.WorkbenchPart_AutoTitleFormat, name, description);
        }
        this.setTitle(newTitle);
    }

    protected void firePropertyChange(final int propertyId) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            final ListenerRec rec = (ListenerRec)iter.next();
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    rec.l.propertyChanged(rec.part, propertyId);
                }
            });
        }
    }

    private static final class ListenerRec {
        public IPropertyListener l;
        public IWorkbenchPart part;

        public ListenerRec(IPropertyListener l, IWorkbenchPart p) {
            this.l = l;
            this.part = p;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ListenerRec)) {
                return false;
            }
            ListenerRec lr = (ListenerRec)other;
            return lr.l == this.l && lr.part == this.part;
        }
    }
}

