/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.BreakIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.internal.dialogs.PatternFilter;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;

public class PatternItemFilter
extends PatternFilter {
    private Map keywordCache = new HashMap();
    protected boolean matchItem;

    public PatternItemFilter(boolean isMatchItem) {
        this.matchItem = isMatchItem;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)viewer).getContentProvider();
        IPreferenceNode node = (IPreferenceNode)element;
        Object[] children = contentProvider.getChildren((Object)node);
        String text = node.getLabelText();
        if (this.wordMatches(text)) {
            return true;
        }
        if (this.matchItem && this.filter(viewer, element, children).length > 0) {
            return true;
        }
        if (node instanceof WorkbenchPreferenceExtensionNode) {
            WorkbenchPreferenceExtensionNode workbenchNode = (WorkbenchPreferenceExtensionNode)node;
            Collection keywordCollection = (Collection)this.keywordCache.get(node);
            if (keywordCollection == null) {
                keywordCollection = workbenchNode.getKeywordLabels();
                this.keywordCache.put(node, keywordCollection);
            }
            if (keywordCollection.isEmpty()) {
                return false;
            }
            Iterator keywords = keywordCollection.iterator();
            while (keywords.hasNext()) {
                if (!this.wordMatches((String)keywords.next())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean wordMatches(String text) {
        if (this.match(text)) {
            return true;
        }
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text);
        int i = iter.first();
        while (i != -1 && i < text.length()) {
            String word;
            int j = iter.following(i);
            if (j == -1) {
                j = text.length();
            }
            if (Character.isLetterOrDigit(text.charAt(i)) && this.match(word = text.substring(i, j))) {
                return true;
            }
            i = j;
        }
        return false;
    }
}

