/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.internal.WorkingSetComparator;
import org.eclipse.ui.internal.dialogs.WorkingSetEditWizard;
import org.eclipse.ui.internal.dialogs.WorkingSetNewWizard;
import org.eclipse.ui.internal.dialogs.WorkingSetSelectionDialog;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class AbstractWorkingSetManager
implements IWorkingSetManager,
BundleListener {
    private SortedSet workingSets = new TreeSet(new WorkingSetComparator());
    private ListenerList propertyChangeListeners = new ListenerList();
    private static final int MRU_SIZE = 5;
    private List recentWorkingSets = new ArrayList();
    private BundleContext bundleContext;
    private Map updaters = new HashMap();
    private static final IWorkingSetUpdater NULL_UPDATER = new IWorkingSetUpdater(){

        public void add(IWorkingSet workingSet) {
        }

        public boolean remove(IWorkingSet workingSet) {
            return true;
        }

        public boolean contains(IWorkingSet workingSet) {
            return true;
        }

        public void dispose() {
        }
    };

    private static WorkingSetDescriptor[] getSupportedEditableDescriptors(String[] supportedWorkingSetIds) {
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        if (supportedWorkingSetIds == null) {
            return registry.getNewPageWorkingSetDescriptors();
        }
        ArrayList<WorkingSetDescriptor> result = new ArrayList<WorkingSetDescriptor>(supportedWorkingSetIds.length);
        int i = 0;
        while (i < supportedWorkingSetIds.length) {
            WorkingSetDescriptor desc = registry.getWorkingSetDescriptor(supportedWorkingSetIds[i]);
            if (desc != null && desc.isEditable()) {
                result.add(desc);
            }
            ++i;
        }
        return result.toArray(new WorkingSetDescriptor[result.size()]);
    }

    protected AbstractWorkingSetManager(BundleContext context) {
        this.bundleContext = context;
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void dispose() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        Iterator iter = this.updaters.values().iterator();
        while (iter.hasNext()) {
            ((IWorkingSetUpdater)iter.next()).dispose();
        }
    }

    public IWorkingSet createWorkingSet(String name, IAdaptable[] elements) {
        return new WorkingSet(name, elements);
    }

    public IWorkingSet createWorkingSet(IMemento memento) {
        return this.restoreWorkingSet(memento);
    }

    public void addWorkingSet(IWorkingSet workingSet) {
        Assert.isTrue((!this.workingSets.contains(workingSet) ? 1 : 0) != 0, (String)"working set already registered");
        this.internalAddWorkingSet(workingSet);
    }

    private void internalAddWorkingSet(IWorkingSet workingSet) {
        this.workingSets.add(workingSet);
        ((WorkingSet)workingSet).connect(this);
        this.addToUpdater(workingSet);
        this.firePropertyChange("workingSetAdd", null, workingSet);
    }

    protected boolean internalRemoveWorkingSet(IWorkingSet workingSet) {
        boolean workingSetRemoved = this.workingSets.remove(workingSet);
        boolean recentWorkingSetRemoved = this.recentWorkingSets.remove(workingSet);
        if (workingSetRemoved) {
            ((WorkingSet)workingSet).disconnect();
            this.removeFromUpdater(workingSet);
            this.firePropertyChange("workingSetRemove", workingSet, null);
        }
        return workingSetRemoved || recentWorkingSetRemoved;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSets.toArray(new IWorkingSet[this.workingSets.size()]);
    }

    public IWorkingSet getWorkingSet(String name) {
        if (name == null || this.workingSets == null) {
            return null;
        }
        Iterator iter = this.workingSets.iterator();
        while (iter.hasNext()) {
            IWorkingSet workingSet = (IWorkingSet)iter.next();
            if (!name.equals(workingSet.getName())) continue;
            return workingSet;
        }
        return null;
    }

    public IWorkingSet[] getRecentWorkingSets() {
        return this.recentWorkingSets.toArray(new IWorkingSet[this.recentWorkingSets.size()]);
    }

    protected void internalAddRecentWorkingSet(IWorkingSet workingSet) {
        this.recentWorkingSets.remove(workingSet);
        this.recentWorkingSets.add(0, workingSet);
        if (this.recentWorkingSets.size() > 5) {
            this.recentWorkingSets.remove(5);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        AbstractWorkingSetManager other = (AbstractWorkingSetManager)object;
        return other.workingSets.equals(this.workingSets);
    }

    public int hashCode() {
        return this.workingSets.hashCode();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    protected void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Object[] listeners = AbstractWorkingSetManager.this.propertyChangeListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                    ++i;
                }
            }
        });
    }

    public void workingSetChanged(IWorkingSet changedWorkingSet, String propertyChangeId, Object oldValue) {
        this.firePropertyChange(propertyChangeId, oldValue, changedWorkingSet);
    }

    protected void saveWorkingSetState(IMemento memento) {
        Iterator iterator = this.workingSets.iterator();
        while (iterator.hasNext()) {
            IWorkingSet persistable = (IWorkingSet)iterator.next();
            IMemento workingSetMemento = memento.createChild("workingSet");
            workingSetMemento.putString("factoryID", persistable.getFactoryId());
            persistable.saveState(workingSetMemento);
        }
    }

    protected void restoreWorkingSetState(IMemento memento) {
        IMemento[] children = memento.getChildren("workingSet");
        int i = 0;
        while (i < children.length) {
            IWorkingSet workingSet = this.restoreWorkingSet(children[i]);
            if (workingSet != null) {
                this.internalAddWorkingSet(workingSet);
            }
            ++i;
        }
    }

    protected IWorkingSet restoreWorkingSet(IMemento memento) {
        IElementFactory factory;
        String factoryID = memento.getString("factoryID");
        if (factoryID == null) {
            factoryID = "org.eclipse.ui.internal.WorkingSetFactory";
        }
        if ((factory = PlatformUI.getWorkbench().getElementFactory(factoryID)) == null) {
            WorkbenchPlugin.log("Unable to restore working set - cannot instantiate factory: " + factoryID);
            return null;
        }
        IAdaptable adaptable = factory.createElement(memento);
        if (adaptable == null) {
            WorkbenchPlugin.log("Unable to restore working set - cannot instantiate working set: " + factoryID);
            return null;
        }
        if (!(adaptable instanceof IWorkingSet)) {
            WorkbenchPlugin.log("Unable to restore working set - element is not an IWorkingSet: " + factoryID);
            return null;
        }
        return (IWorkingSet)adaptable;
    }

    protected void saveMruList(IMemento memento) {
        Iterator iterator = this.recentWorkingSets.iterator();
        while (iterator.hasNext()) {
            IWorkingSet workingSet = (IWorkingSet)iterator.next();
            IMemento mruMemento = memento.createChild("mruList");
            mruMemento.putString("name", workingSet.getName());
        }
    }

    protected void restoreMruList(IMemento memento) {
        IMemento[] mruWorkingSets = memento.getChildren("mruList");
        int i = mruWorkingSets.length - 1;
        while (i >= 0) {
            IWorkingSet workingSet;
            String workingSetName = mruWorkingSets[i].getString("name");
            if (workingSetName != null && (workingSet = this.getWorkingSet(workingSetName)) != null) {
                this.internalAddRecentWorkingSet(workingSet);
            }
            --i;
        }
    }

    public IWorkingSetEditWizard createWorkingSetEditWizard(IWorkingSet workingSet) {
        String editPageId = workingSet.getId();
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        IWorkingSetPage editPage = null;
        if (editPageId != null) {
            editPage = registry.getWorkingSetPage(editPageId);
        }
        if (editPage == null && (editPage = registry.getDefaultWorkingSetPage()) == null) {
            return null;
        }
        WorkingSetEditWizard editWizard = new WorkingSetEditWizard(editPage);
        editWizard.setSelection(workingSet);
        return editWizard;
    }

    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell parent) {
        return this.createWorkingSetSelectionDialog(parent, true);
    }

    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell parent, boolean multi) {
        return this.createWorkingSetSelectionDialog(parent, multi, null);
    }

    public IWorkingSetNewWizard createWorkingSetNewWizard(String[] workingSetIds) {
        WorkingSetDescriptor[] descriptors = AbstractWorkingSetManager.getSupportedEditableDescriptors(workingSetIds);
        if (descriptors.length == 0) {
            return null;
        }
        return new WorkingSetNewWizard(descriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getBundle().getState() != 32) {
            return;
        }
        if (!Workbench.getInstance().isRunning()) {
            return;
        }
        WorkingSetDescriptor[] descriptors = WorkbenchPlugin.getDefault().getWorkingSetRegistry().getDescriptorsForNamespace(event.getBundle().getSymbolicName());
        AbstractWorkingSetManager abstractWorkingSetManager = this;
        synchronized (abstractWorkingSetManager) {
            int i = 0;
            while (i < descriptors.length) {
                WorkingSetDescriptor descriptor = descriptors[i];
                List workingSets = this.getWorkingSetsForId(descriptor.getId());
                if (workingSets.size() != 0) {
                    IWorkingSetUpdater updater = this.getUpdater(descriptor);
                    Iterator iter = workingSets.iterator();
                    while (iter.hasNext()) {
                        IWorkingSet workingSet = (IWorkingSet)iter.next();
                        if (updater.contains(workingSet)) continue;
                        updater.add(workingSet);
                    }
                }
                ++i;
            }
        }
    }

    private List getWorkingSetsForId(String id) {
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
        Iterator iter = this.workingSets.iterator();
        while (iter.hasNext()) {
            IWorkingSet ws = (IWorkingSet)iter.next();
            if (!id.equals(ws.getId())) continue;
            result.add(ws);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUpdater(IWorkingSet workingSet) {
        WorkingSetDescriptor descriptor = WorkbenchPlugin.getDefault().getWorkingSetRegistry().getWorkingSetDescriptor(workingSet.getId());
        if (descriptor == null || !descriptor.isDeclaringPluginActive()) {
            return;
        }
        AbstractWorkingSetManager abstractWorkingSetManager = this;
        synchronized (abstractWorkingSetManager) {
            IWorkingSetUpdater updater = this.getUpdater(descriptor);
            if (!updater.contains(workingSet)) {
                updater.add(workingSet);
            }
        }
    }

    private IWorkingSetUpdater getUpdater(WorkingSetDescriptor descriptor) {
        IWorkingSetUpdater updater = (IWorkingSetUpdater)this.updaters.get(descriptor.getId());
        if (updater == null) {
            updater = descriptor.createWorkingSetUpdater();
            if (updater == null) {
                updater = NULL_UPDATER;
            } else {
                this.firePropertyChange("workingSetUpdaterInstalled", null, updater);
            }
            this.updaters.put(descriptor.getId(), updater);
        }
        return updater;
    }

    private synchronized void removeFromUpdater(IWorkingSet workingSet) {
        IWorkingSetUpdater updater = (IWorkingSetUpdater)this.updaters.get(workingSet.getId());
        if (updater != null) {
            updater.remove(workingSet);
        }
    }

    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell parent, boolean multi, String[] workingsSetIds) {
        return new WorkingSetSelectionDialog(parent, multi, workingsSetIds);
    }
}

