/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "_Vector.hpp"

#include "Jiki.hpp"

#include "Zanzou.hpp"

#define m g_main
#define g g_main->g

/**
 * RXgN^
 */
Jiki::Jiki() {
	_first = TRUE;
	_x = -48;
	_y = 216;
	_color = 0;
	_life = JIKI_LIFE_MAX;
	_muteki = WAIT_1;
	_damage = FALSE;
	_dash_power = 0;
	_dash = FALSE;
	_dash_left = FALSE;
	_dash_dx = 0;
	_dash_dy = 0;
	_special_power = 0;
	_special = FALSE;
	_special2 = FALSE;
	zanzou = new _Vector();
}

/**
 * fXgN^
 */
Jiki::~Jiki() {
	delete zanzou;
}

void Jiki::move_dash() {
	if ( _dash ) {
		if ( _dash_dx < _dash_tx ) {
			_dash_dx++;
		} else if ( _dash_dx > _dash_tx ) {
			_dash_dx--;
		}
		_x += _dash_dx;
		if ( _x <   0 ) _x =   0;
		if ( _x > 592 ) _x = 592;

		if ( _dash_dy < _dash_ty ) {
			_dash_dy++;
		} else if ( _dash_dy > _dash_ty ) {
			_dash_dy--;
		}
		_y += _dash_dy;
		if ( _y <   0 ) _y =   0;
		if ( _y > 432 ) _y = 432;
	}
}

/**
 * ړ
 */
void Jiki::down(BOOL slow) {
	if ( !_first && !_special && !_special2 && !_damage ) {
		if ( !slow ) {
			_dash_tx = 0;
		}
		_dash_ty = (slow ? 9 : 12);

		if ( _dash ) {
			if ( (_dash_dx == 0) && (_dash_dy <= 0) ) {
				_dash_dy = _dash_ty;
			}
		} else {
			if ( !slow ) {
				_dash_dx = 0;
			}
			_dash_dy = _dash_ty;

			_y += (slow ? 3 : 4);
			if ( _y > 432 ) _y = 432;
		}
	}
}

/**
 * ړ
 */
void Jiki::left(BOOL slow) {
	if ( !_first && !_special && !_special2 && !_damage ) {
		_dash_tx = (slow ? -9 : -12);
		if ( !slow ) {
			_dash_ty = 0;
		}

		if ( _dash ) {
			if ( (_dash_dy == 0) && (_dash_dx >= 0) ) {
				_dash_dx = _dash_tx;
			}
		} else {
			_dash_dx = _dash_tx;
			if ( !slow ) {
				_dash_dy = 0;
			}

			_x -= (slow ? 3 : 4);
			if ( _x < 0 ) _x = 0;
		}

		_dash_left = TRUE;
	}
}

/**
 * Eړ
 */
void Jiki::right(BOOL slow) {
	if ( !_first && !_special && !_special2 && !_damage ) {
		_dash_tx = (slow ? 9 : 12);
		if ( !slow ) {
			_dash_ty = 0;
		}

		if ( _dash ) {
			if ( (_dash_dy == 0) && (_dash_dx <= 0) ) {
				_dash_dx = _dash_tx;
			}
		} else {
			_dash_dx = _dash_tx;
			if ( !slow ) {
				_dash_dy = 0;
			}

			_x += (slow ? 3 : 4);
			if ( _x > 592 ) _x = 592;
		}

		_dash_left = FALSE;
	}
}

/**
 * ړ
 */
void Jiki::up(BOOL slow) {
	if ( !_first && !_special && !_special2 && !_damage ) {
		if ( !slow ) {
			_dash_tx = 0;
		}
		_dash_ty = (slow ? -9 : -12);

		if ( _dash ) {
			if ( (_dash_dx == 0) && (_dash_dy >= 0) ) {
				_dash_dy = _dash_ty;
			}
		} else {
			if ( !slow ) {
				_dash_dx = 0;
			}
			_dash_dy = _dash_ty;

			_y -= (slow ? 3 : 4);
			if ( _y < 0 ) _y = 0;
		}
	}
}

/**
 * Fݒ肷
 */
void Jiki::color(int col) {
	if ( !_special && !_special2 ) {
		_color = col;
	}
}

/**
 * XV
 */
void Jiki::update() {
	// c
	for ( int i = zanzou->size() - 1; i >= 0; i-- ) {
		Zanzou* tmp = (Zanzou*)zanzou->elementAt(i);
		if ( !(tmp->update()) ) {
			zanzou->removeElementAt(i);
		}
	}

	if ( _first ) {
		_x += _muteki / 7;
		_muteki--;
		if ( _muteki == 0 ) {
			_first = FALSE;
		}
	} else {
		// XyVU...
		if ( _special ) {
			if ( (_elapse % 2) == 0 ) {
				m->jshot->addElement(new JikiShot(JSHOT_SPECIAL, _special_x, _special_y));
			}
			if ( (_elapse % 5) == 0 ) {
				m->move(m->jiki->cx(), m->jiki->cy(), _special_x, _special_y, 24);
				m->spark->addElement(new Spark(m->move_x(), m->move_y(), _color));
			}
			_elapse++;
			_special_power--;
			if ( _special_power <= 0 ) {
				_special = FALSE;
			}
		} else if ( _special2 ) {
			_elapse++;
			if ( _elapse <= 15 ) {
				m->move(_x0, _y0, _special_x, _special_y, _elapse * 5);
				_x = m->move_x() - 24;
				_y = m->move_y() - 24;
				if ( _x <   0 ) _x =   0;
				if ( _x > 592 ) _x = 592;
				if ( _y <   0 ) _y =   0;
				if ( _y > 432 ) _y = 432;
			}
			if ( _elapse == 10 ) {
				m->jshot->addElement(new JikiShot(JSHOT_SWORD, _special_x, _special_y));
			}
			if ( _elapse >= 30 ) {
				_special2 = FALSE;
			}
		}

		// _[W̏ꍇ...
		if ( _damage ) {
			if ( _life == 0 ) {
				_elapse++;
				m->move(_x0, _y0, _x1, _y1, _elapse * 2);
				_x = m->move_x();
				_y = m->move_y();
				if ( _x < -64 ) {
					_life--;
				}
			} else {
				_elapse++;
				m->move(_x0, _y0, _x1, _y1, _elapse * 4);
				_x = m->move_x();
				_y = m->move_y();
				if ( _x <   0 ) _x =   0;
				if ( _x > 592 ) _x = 592;
				if ( _y <   0 ) _y =   0;
				if ( _y > 432 ) _y = 432;
				if ( _elapse > 10 ) {
					_damage = FALSE;

					// GԂɂ
					muteki();
				}
			}
		}

		// G̏ꍇ...
		if ( _muteki > 0 ) {
			_muteki--;
		}
	}
}

/**
 * Gǂ`FbN
 */
BOOL Jiki::check_muteki() {
	return ((_life <= 0) || (_muteki > 0) || _dash || _special) ? TRUE : FALSE;
}

/**
 * XyVUǂ`FbN
 */
BOOL Jiki::check_special() {
	return (_special || _special2) ? TRUE : FALSE;
}

/**
 * 蔻̈擾
 */
int Jiki::h_left  () { return _x + 12; }
int Jiki::h_top   () { return _y + 12; }
int Jiki::h_right () { return _x + 36; }
int Jiki::h_bottom() { return _y + 36; }

/**
 * ʒumF
 */
int Jiki::x () { return _x; }
int Jiki::y () { return _y; }
int Jiki::cx() { return _x + 24; }
int Jiki::cy() { return _y + 24; }

/**
 * _[W̃gK[
 */
void Jiki::damage(int sx, int sy) {
	if ( _damage || (_muteki > 0) ) return;
#ifndef MUTEKI
	_life--;
#endif // MUTEKI
	_x0 = _x;
	_y0 = _y;
m->stop_sound(SE_SWORD);
	if ( _life > 0 ) {
m->play_sound(SE_DAMAGE);
		_x1 = _x0 - (sx - cx());
		_y1 = _y0 - (sy - cy());
	} else {
m->play_sound(SE_DOWN);
		_x1 = -320;
		_y1 = (m->rand() % 240) + 240;
	}
	_elapse = 0;
	_damage = TRUE;
	_special2 = FALSE;
}

/**
 * G̃gK[
 */
void Jiki::muteki() {
	_muteki = WAIT_1;
}

void Jiki::add_dash_power() {
	_dash_power++;
	if ( _dash_power > DASH_POWER_MAX ) {
		_dash_power = DASH_POWER_MAX;
	}
}

/**
 * _bṼgK[
 */
void Jiki::dash() {
	if ( (_life == 0) || _special || _special2 ) return;

	if ( _dash_power > 0 ) {
		_dash = TRUE;
m->play_sound(SE_DASH);
	}
}

void Jiki::add_special_power() {
m->play_sound(SE_POWER);
	_special_power += 5;
	if ( _special_power > SPECIAL_POWER_MAX ) {
		_special_power = SPECIAL_POWER_MAX;
	}
}

/**
 * XyVŨgK[
 */
void Jiki::special() {
	if ( (_life == 0) || _special || _special2 || (m->_target == 0) ) return;

	_special_x = m->_target_x;
	_special_y = m->_target_y;
	if ( m->_target == 2 ) {
		_special2 = TRUE;
		_x0 = _x + 24;
		_y0 = _y + 24;
		_elapse = 0;
		_r = atan2((double)(_special_y - _y0), (double)(_special_x - _x0));
m->play_sound(SE_SWORD);
	} else {
		if ( _special_power < SPECIAL_POWER_MAX ) {
			return;
		}
		_special = TRUE;
		_elapse = 0;
		_special_r = atan2((double)(_special_y - cy()), (double)(_special_x - cx()));
m->play_sound(SE_SPECIAL);
	}

	_muteki = 0;
	_damage = FALSE;
}

/**
 * `
 */
int Jiki::draw(double r, int id) {
	g->setRot(r);
	if ( (r <= -1.5707963267949) || (r >= 1.5707963267949) ) {
		id++;
	}
	g->drawImage(m->use_image(id), _x, _y, 0, 0, 48, 48);
	g->setRot(0.0);
	return id;
}
void Jiki::draw() {
	// c
	for ( int i = zanzou->size() - 1; i >= 0; i-- ) {
		Zanzou* tmp = (Zanzou*)zanzou->elementAt(i);
		tmp->draw();
	}

	// V[h̕\
	g->setAlpha(127);
	g->drawImage(m->use_image(DATA_SHIELD), _x - 4, _y - 4, 56 * _color, 0, 56, 56);
	g->setROP(_ROP_ADD);
	if ( (m->elapse() % WAIT_1) < WAIT_H ) {
		g->setAlpha(63 - 63 * (m->elapse() % WAIT_H) / WAIT_H);
	} else {
		g->setAlpha(63 * (m->elapse() % WAIT_H) / WAIT_H);
	}
	g->drawImage(m->use_image(DATA_SHIELD_F), _x - 4, _y - 4, 56 * _color, 0, 56, 56);
	g->setROP(_ROP_COPY);
	g->setAlpha(255);

	if ( (_muteki == 0) || (((m->elapse() / 5) % 2) > 0) ) {
		if ( _special ) {
			draw(atan2((double)(_special_y - cy()), (double)(_special_x - cx())), DATA_JIKI3);
		} else if ( _special2 ) {
			g->setRot(_r);
			if ( (_r > -1.5707963267949) && (_r < 1.5707963267949) ) {
				switch ( _elapse / 5 ) {
				case 0:
					g->drawImage(m->use_image(DATA_JIKI4), _x, _y - 21, 0, 0, 48, 75);
					if ( _elapse == 1 ) {
						zanzou->addElement(new Zanzou(DATA_JIKI4, WAIT_Q));
					}
					break;
				case 1:
					g->drawImage(m->use_image(DATA_JIKI4), _x, _y - 21, 48, 0, 48, 75);
					if ( _elapse == 6 ) {
						zanzou->addElement(new Zanzou(DATA_JIKI4, WAIT_Q));
					}
					break;
				default:
					g->drawImage(m->use_image(DATA_JIKI4), _x, _y - 21, 96, 0, 48, 75);
					break;
				}
			} else {
				switch ( _elapse / 5 ) {
				case 0:
					g->drawImage(m->use_image(DATA_JIKI4_2), _x, _y - 21, 0, 0, 48, 75);
					if ( _elapse == 1 ) {
						zanzou->addElement(new Zanzou(DATA_JIKI4_2, WAIT_Q));
					}
					break;
				case 1:
					g->drawImage(m->use_image(DATA_JIKI4_2), _x, _y - 21, 48, 0, 48, 75);
					if ( _elapse == 6 ) {
						zanzou->addElement(new Zanzou(DATA_JIKI4_2, WAIT_Q));
					}
					break;
				default:
					g->drawImage(m->use_image(DATA_JIKI4_2), _x, _y - 21, 96, 0, 48, 75);
					break;
				}
			}
			g->setRot(0.0);
		} else if ( _life == 0 ) {
			g->setRot(0.0 - (double)_elapse / 6.0);
			g->drawImage(m->use_image(DATA_JIKI1), _x, _y, 96, 0, 48, 48);
			g->setRot(0.0);
		} else if ( m->_target > 0 ) {
			int id = draw(atan2((double)(m->_target_y - cy()), (double)(m->_target_x - cx())), DATA_JIKI2);
			if ( _dash ) {
				if ( (m->m_elapse % DASH_ZANZOU) == 0 ) {
					zanzou->addElement(new Zanzou(id, WAIT_Q));
				}
			}
		} else {
			if ( _dash ) {
				if ( _dash_left ) {
					g->drawImage(m->use_image(DATA_JIKI5), _x, _y, 0, 0, 48, 48);
					if ( (m->m_elapse % DASH_ZANZOU) == 0 ) {
						zanzou->addElement(new Zanzou(DATA_JIKI5, WAIT_Q));
					}
				} else {
					g->drawImage(m->use_image(DATA_JIKI1), _x, _y, 0, 0, 48, 48);
					if ( (m->m_elapse % DASH_ZANZOU) == 0 ) {
						zanzou->addElement(new Zanzou(DATA_JIKI1, WAIT_Q));
					}
				}
			} else {
				g->drawImage(m->use_image(DATA_JIKI1), _x, _y, 48 * ((m->elapse() / 5) % 2), 0, 48, 48);
			}
		}
	}

#ifdef SHOW_AREA
	m->drawArea(h_left(), h_top(), h_right() - h_left() + 1, h_bottom() - h_top() + 1);
#endif // SHOW_AREA
}
