/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "Awa.hpp"

#define m g_main
#define g g_main->g

Awa::Awa(int x0, int y0) {
	y0 += m->_rand->nextInt() % 24;
	_x0 = x0;
	_y0 = y0;
	_x1 = (m->_rand->nextInt() % 120) - 240;
	_y1 = (m->_rand->nextInt() % 120) - 240;
	_x = _x0;
	_y = _y0;
	_elapse = 0;
m->stop_sound(SE_AWA);
m->play_sound(SE_AWA);
}

BOOL Awa::update() {
	_elapse++;
	m->move(_x0, _y0, _x1, _y1, _elapse * 8);
	_x = m->move_x();
	_y = m->move_y();
	if ( (_x < -24) || (_y < -24) ) {
		return FALSE;
	}
	return TRUE;
}

void Awa::draw() {
	g->setROP(_ROP_ADD);
	g->setAlpha(127);
	if ( _elapse < 25 ) {
		g->drawImage(m->use_image(DATA_AWA), _x - 24, _y - 24, 0, 0, 48, 48);
	} else if ( _elapse < 50 ) {
		g->drawImage(m->use_image(DATA_AWA), _x - 24, _y - 24, 48, 0, 48, 48);
	} else {
		g->drawImage(m->use_image(DATA_AWA), _x - 24, _y - 24, 96, 0, 48, 48);
	}
	g->setAlpha(255);
	g->setROP(_ROP_COPY);
}
