/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#ifndef _GRAPHICS_HPP
#define _GRAPHICS_HPP

#include <windows.h>

#include <d3dx9.h>

// OQ
class _Image;
class _ImageInfo;
class _Memory;
class _String;

class _Graphics
{
private:
	// ݐF
	D3DCOLOR _curCol;

	// X^[Iy[V
	int _rop;

	// g
	FLOAT _scaleX;
	FLOAT _scaleY;

	// ]
	FLOAT _rot;

	// x
	int _alpha;

	// x
	int _bright;

	// tbv
	int _flip;

	BOOL _lockDraw;

	_ImageInfo* _imageInfo;

public:
	_Graphics();
	virtual ~_Graphics();

	D3DCOLOR getColorOfRGB( int r255, int g255, int b255 );
	void setColor( D3DCOLOR col );
	void setROP( int mode );
private:
	void SetROP();
public:
	void setScale( FLOAT scaleX, FLOAT scaleY );
	void setScale( FLOAT scale );
	void setRot( FLOAT rot );
	void setAlpha( int a255 );
	void setBright( int bright255 );

	void lockDraw();
	void unlockDraw();

	void drawLine( int x0, int y0, int x1, int y1 );
	void drawRect( int x, int y, int w, int h );
	void fillRect( int x, int y, int w, int h );

	int stringWidth( char* str );
	int stringWidth( _String* str );
	int fontHeight();

	void drawString( char* str, int x, int y );
	void drawString( _String* str, int x, int y );
	void centerDrawString( char* str, int cx, int y );
	void centerDrawString( _String* str, int cx, int y );
	void centerDrawString( char* str, int y );
	void centerDrawString( _String* str, int y );
	void rightDrawString( char* str, int w, int y );
	void rightDrawString( _String* str, int w, int y );
	void rightDrawString( char* str, int y );
	void rightDrawString( _String* str, int y );

	void setFlipMode( int flip );

	BOOL createImage( LPDIRECT3DTEXTURE9* image, _Memory* data );
	BOOL createImage( _Image*             image, _Memory* data );
	BOOL createImage( LPDIRECT3DTEXTURE9* image, char* file );
	BOOL createImage( _Image*             image, char* file );
	void disposeImage( LPDIRECT3DTEXTURE9 image );
	void disposeImage( _Image*            image );
	void drawImage( LPDIRECT3DTEXTURE9 image, FLOAT x, FLOAT y );
	void drawImage( _Image*            image, FLOAT x, FLOAT y );
	void drawImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy );
	void drawImage( _Image*            image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy );
	void drawImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height );
	void drawImage( _Image*            image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height );
	void drawImage( LPDIRECT3DTEXTURE9 image, _ImageInfo* info );
	void drawImage( _Image*            image, _ImageInfo* info );
	void drawScaledImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int width, int height, int sx, int sy, int swidth, int sheight );
	void drawScaledImage( _Image*            image, FLOAT dx, FLOAT dy, int width, int height, int sx, int sy, int swidth, int sheight );
	void drawTransImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy, FLOAT r360, FLOAT z128x, FLOAT z128y );
	void drawTransImage( _Image*            image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy, FLOAT r360, FLOAT z128x, FLOAT z128y );

	_ImageInfo* getImageInfo();
};

#endif // _GRAPHICS_HPP
