/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ksk.contacts.widget;

import java.util.Calendar;

import com.ksk.contacts.util.CommonData;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import android.util.Log;

public final class PhoneStateReceiver extends BroadcastReceiver {

	private CommonData mData = new CommonData();

	private static  final String      UPDATE_LOG_ACTION = "com.ksk.contacts.widget.WidgetService.UPDATE_LOG_ACTION";

	@Override
	public void onReceive(Context context, Intent intent) {

		final String state = intent.getStringExtra(TelephonyManager.EXTRA_STATE);

		Log.d("WidgetService","onReceive:" + state);

		if (state.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
	      /*
	       * 着信時の処理
	       */
			//サービス起動
			//※TaskKiller等による強制終了されている可能性があるため、強制的に起動させる
			Intent serviceIntent = new Intent(context, WidgetService.class);
			serviceIntent.putExtra("layout", mData.APPWIDGET_2_1);
			context.startService(serviceIntent);

			serviceIntent.putExtra("layout", mData.APPWIDGET_3_1);
			context.startService(serviceIntent);

		} else if (state.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
	      /*
	       * 通話開始(発信の場合は呼出開始と同時)の処理
	       */

		} else if (state.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
	      /*
	       * 通話終了時の処理
	       */
       		//着信→待ち受けシーケンス時のみ、新規不在着信の確認・更新を行う
    		//TODO:このタイミングで通話ログを取得しても更新されていなかったため、
    		//     強制的に1秒のDelayを行う
    		Intent i = new Intent(UPDATE_LOG_ACTION); // ReceivedActivityを呼び出すインテントを作成
    		PendingIntent sender = PendingIntent.getBroadcast(context, 0, i, 0); // ブロードキャストを投げるPendingIntentの作成

    		Calendar calendar = Calendar.getInstance(); // Calendar取得
    		calendar.setTimeInMillis(System.currentTimeMillis()); // 現在時刻を取得
    		calendar.add(Calendar.MILLISECOND, 500); // 現時刻より0.5秒後を設定

    		AlarmManager am = (AlarmManager)context.getSystemService(Context.ALARM_SERVICE); // AlramManager取得
    		am.set(AlarmManager.RTC_WAKEUP, calendar.getTimeInMillis(), sender); // AlramManagerにPendingIntentを登録
		}
	}
}
