/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.util;

import com.ksk.contacts.util.ContactMgr.ContactInfo;

public class DataComparator implements java.util.Comparator{

	@Override
	public int compare(Object o1, Object o2) {

		return compare(((ContactInfo)o1).yomi, ((ContactInfo)o2).yomi);
	}

	public int compare(int o1, int o2) {

		//ソート順を以下にするための調整
		// 日本語 → 数値 → 英語 → その他
		if( ((o1 < 0x3041) || (o1 > 0x3093)) && ((o1 < 0xFF67) || (o1 > 0xFF9D))){
			o1 += 0xFF0000;
		}
		if( ((o2 < 0x3041) || (o2 > 0x3093)) && ((o2 < 0xFF67) || (o2 > 0xFF9D))){
			o2 += 0xFF0000;
		}

		if(o1 > o2){
			return 1;
		}else if(o1 == o2){
			return 0;
		}else{
			return -1;
		}
    }
}
