/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.util;

import java.util.List;

import com.ksk.contacts.R;
import com.ksk.contacts.tel.activity.contactinfo;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ShortCutListAdapter extends BaseAdapter implements OnClickListener {

	public class ShortCutInfo {
		public  String number;
		public  int    contact_id;
	}

	//メンバーリスト情報
	private List<ShortCutInfo> mListData;

	//Context情報
	private Context        mContext;

	//コンストラクタ
    public ShortCutListAdapter(Context context) {
    	mContext  = context;
	}

    /**
     * @param dataList
     */
    public void setDataList(List<ShortCutInfo> dataList) {
    	mListData = dataList;
	}

    public List<ShortCutInfo> getDataList() {
    	return mListData;
	}

	/* (非 Javadoc)
	 * @see android.widget.Adapter#getCount()
	 */
	@Override
    public int getCount() {
    	return mListData.size();
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getItem(int)
     */
    @Override
    public Object getItem(int position) {
    	return mListData.get(position);
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getItemId(int)
     */
    @Override
    public long getItemId(int position) {
    	return position;
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getView(int, android.view.View, android.view.ViewGroup)
     */
    public View getView(int position, View convertView, ViewGroup parent) {
		View   v = convertView;

		//選択位置を元にリスト情報を取得する。
		ShortCutInfo item = (ShortCutInfo) getItem(position);

		//レイアウトを元にViewを新規作成する
		LayoutInflater inflater = (LayoutInflater)mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		v = inflater.inflate(R.layout.shortcutdial_row, null);

		//リスト情報がNULLではない場合は、各情報の設定を行う。
		if(item != null){

			//HolderのDataに、ListData情報を登録する。
			//  →音声発信/Email/カスタムボタン押下時の各種情報取得用
			v.setTag(item);

			//リスト番号の表示
			TextView num = (TextView)v.findViewById(R.id.num);
			num.setText(String.valueOf(position));

			//短縮番号の表示
			TextView number = (TextView) v.findViewById(R.id.number);
			number.setText(item.number);

			//検索用ボタンの設定
			ImageView serch = (ImageView) v.findViewById(R.id.serch);
			serch.setOnClickListener(this);
			serch.setTag(item);
			if(item.contact_id != -1){
				if((item.number != null) && (!item.number.equals(""))){
					serch.setVisibility(View.VISIBLE);
				}else{
					serch.setVisibility(View.INVISIBLE);
				}
			}else{
				serch.setVisibility(View.INVISIBLE);
			}
		}

		return v;
    }

	/* (非 Javadoc)
	 * @see android.view.View.OnClickListener#onClick(android.view.View)
	 */
	@Override
	public void onClick(View view) {

		//ViewのTagより電話番号を取得する
		ShortCutInfo info = (ShortCutInfo) view.getTag();

		//取得したContactIDを元に詳細画面Activityに対して起動要求を行う。
		Intent intent = new Intent(mContext, contactinfo.class);
		intent.putExtra("ContactID", info.contact_id);
		mContext.startActivity(intent);
	}
}
