/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTMailSendRecvAcl;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.mail.ALPop3MailReceiveThread;
import com.aimluck.eip.mail.beans.ALMailSearchCondition;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.beans.WebMailFolderVolumeSummaryBean;
import com.aimluck.eip.webmail.beans.WebmailAccountLiteBean;
import com.aimluck.eip.webmail.util.WebMailUtils;
import com.sk_jp.mail.MailUtility;

/**
 * Webメール検索データを管理するためのクラスです。 <br />
 */
public class WebMailSelectData extends ALAbstractSelectData<EipTMail, ALMailMessage> {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WebMailSelectData.class.getName());

  /** 現在選択されているタブ (＝受信メール or 送信メール) */
  private String currentTab;

  JetspeedUser user = null;

  /** ユーザーID */
  private int userId = -1;

  /** アカウントID */
  private int accountId = -1;

  /** フォルダID */
  private int folderId = -1;

  /** フォルダに対する未読メール数のマップ */
  private Map<Integer, Integer> unreadMailSumMap;

  /** 最終受信日 */
  private String finalAccessDateStr;

  private String orgId;

  /** 受信トレイと送信トレイ */
  private ALFolder folder;

  /** 選択されたフォルダ */
  // private WebMailFolderResultData selectedFolder;
  /** メールアカウント一覧 */
  private List<WebmailAccountLiteBean> mailAccountList;

  /** メールフォルダ一覧 */
  // change start 運用保守障害５８
  // private List<WebMailFolderResultData> mailFolderList;
  private List<ExtFolderInfo> mailFolderList;

  // change end

  // add start
  /** 選択されたフォルダ情報 */
  private ExtFolderInfo selected_folderinfo;

  /** フォルダ階層リスト */
  private List<ExtFolderInfo> folder_hierarchy_list;

  /** ごみ箱フォルダID（初期表示時選択） */
  private int trash_folder_id;

  /** デフォルトフォルダID（受信処理判別用） */
  private int default_folder_id;

  /** 検索ワード 本文 */
  protected ALStringField searchWord;

  /** 検索ワード 件名 */
  protected ALStringField searchSubjectWord;

  /** 検索ワード 差出人／受取人 */
  protected ALStringField searchAddressWord;

  /** 検索 サブフォルダも含む */
  protected ALStringField includeSubFolder;

  /** １ユーザーあたりメールボックス容量上限 */
  private ALNumberField mailBoxVolumeMax;

  /** メールボックス使用容量計 */
  private ALNumberField mailBoxVolumeSummary;

  /** メールボックス使用率 */
  private ALNumberField mailBoxVolumePct;

  /** メールボックス未使用率 */
  private ALNumberField mailBoxVolumeEmptyPct;

  /** メッセージリスト */
  private List<String> msgList;

  /** 代理受信アカウントフラグ */
  private boolean isRepresent;

  /** HTTPSプロトコルか？ */
  private boolean isSSL;

  /** リクエストURL */
  private String myUrl;

  /** 接続元の端末（PC:"html", ・・・・） */
  private String mediatype;

  /** ログインユーザーのデフォルトアカウント */
  private EipMMailAccount defaultAccount;

  /** ログインユーザーのデフォルトアカウント */
  private int loginUserId;

  // add start 要件No.1 スケジュール案内受信
  /** カレントアカウントの種別、通常ユーザー：true、会議室ユーザー：false */
  private boolean isUserMailAccount = true;

  // add end

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    if (sort == null || sort.equals("")) {
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, ALEipUtils.getPortlet(rundata, context).getPortletConfig().getInitParameter("p2a-sort"));
    }

    orgId = Database.getDomainName();
    userId = ALEipUtils.getUserId(rundata);
    user = (JetspeedUser) ((JetspeedRunData) rundata).getUser();

    try {
      // 代理受信時の開封通知用情報
      loginUserId = userId;
      defaultAccount = WebMailUtils.getDefaultMailAccount(loginUserId);
      if (defaultAccount == null) {
        return;
      }
    } catch (Exception e2) {
      throw new ALDBErrorException();
    }

    // 現在選択されているタブ（受信トレイor送信トレイ）
    // change start
    // String tabParam = rundata.getParameters().getString("tab");
    // currentTab = ALEipUtils.getTemp(rundata, context, "tab");
    // if (tabParam == null && currentTab == null) {
    // ALEipUtils.setTemp(rundata, context, "tab", WebMailUtils.TAB_RECEIVE);
    // currentTab = WebMailUtils.TAB_RECEIVE;
    // } else if (tabParam != null) {
    // ALEipUtils.setTemp(rundata, context, "tab", tabParam);
    // currentTab = tabParam;
    // }
    currentTab = WebMailUtils.TAB_RECEIVE;
    ALEipUtils.setTemp(rundata, context, "tab", WebMailUtils.TAB_RECEIVE);
    // change end

    // add start
    // 表示対象の種別（受信／送信）を取得する。
    String folder_kind = ALMailUtils.FOLDER_KIND_RECEIVE;
    // msgListの初期化をinitで行う
    // スマートフォン携帯結合テスト障害No.31
    // msgList = new ArrayList<String>();
    // add end

    // 現在処理中のアカウントID
    String tmpAccoundId = ALEipUtils.getTemp(rundata, context, WebMailUtils.ACCOUNT_ID);
    if (tmpAccoundId == null || "".equals(tmpAccoundId)) {
      ALEipUtils
        .setTemp(rundata, context, WebMailUtils.ACCOUNT_ID, ALEipUtils.getPortlet(rundata, context).getPortletConfig().getInitParameter("p3a-accounts"));
    }

    // 自ポートレットからのリクエストであれば、パラメータを展開しセッションに保存する。
    if (ALEipUtils.isMatch(rundata, context)) {
      // アカウントID
      if (rundata.getParameters().containsKey(WebMailUtils.ACCOUNT_ID)) {
        ALEipUtils.setTemp(rundata, context, WebMailUtils.ACCOUNT_ID, rundata.getParameters().getString(WebMailUtils.ACCOUNT_ID));
      }

      // フォルダID
      if (rundata.getParameters().containsKey(WebMailUtils.FOLDER_ID)) {
        ALEipUtils.setTemp(rundata, context, WebMailUtils.FOLDER_ID, rundata.getParameters().getString(WebMailUtils.FOLDER_ID));
      }
    }

    try {
      accountId = Integer.parseInt(ALEipUtils.getTemp(rundata, context, WebMailUtils.ACCOUNT_ID));
    } catch (Exception e) {
      accountId = 0;
    }

    // add start
    isRepresent = false; // 代理受信フラグ初期化

    if (accountId > 0) {

      // 代理受信アカウントの場合、ユーザーIDを代理受信元のユーザーに再設定
      try {
        EipMMailAccount tmpAccount = ALMailUtils.getMailAccount(accountId);

        if (tmpAccount.getUserId() != userId) {
          // アカウントのログインユーザーに対する代理受信許可をチェック
          isRepresent = ALMailUtils.isRepresentReceiveAccount(tmpAccount, userId);
          // ログインユーザーの代理受信アカウントであればユーザーIDを代理受信元ユーザーに再設定
          if (isRepresent) {
            userId = tmpAccount.getUserId();

            // add start 要件No.1 スケジュール案内受信
            final String MEETINGROOM_ACCOUNT = "1";
            if (MEETINGROOM_ACCOUNT.equals(tmpAccount.getAccountUsage())) {
              isUserMailAccount = false;
            }
            // add end
          } else {
            throw new Exception();
          }
        }
      } catch (Exception e1) {
        logger.error("代理受信アカウント情報の取得に失敗しました。", e1);
        throw new ALPageNotFoundException();
      }
    }
    // add end

    try {
      folderId = Integer.parseInt(ALEipUtils.getTemp(rundata, context, WebMailUtils.FOLDER_ID));
    } catch (Exception e) {
      folderId = 0;
    }

    // アカウントIDが取得できなかったとき、デフォルトのアカウントIDを取得する
    if (accountId == 0) {
      try {
        // change start
        // Expression exp =
        // ExpressionFactory.matchExp(EipMMailAccount.USER_ID_PROPERTY, userId);
        // SelectQuery<EipMMailAccount> query =
        // Database.query(EipMMailAccount.class, exp);
        //
        // query.select(EipMMailAccount.ACCOUNT_ID_PK_COLUMN);
        // List<EipMMailAccount> accounts = query.fetchList();
        // if (accounts != null && accounts.size() > 0) {
        // EipMMailAccount account = accounts.get(0);
        // accountId = account.getAccountId();
        // ALEipUtils.setTemp(rundata, context, WebMailUtils.ACCOUNT_ID, Integer
        // .toString(accountId));
        // } else {
        // // アカウントが一つも見つからなかった
        // return;
        // }
        if (defaultAccount != null) {
          accountId = defaultAccount.getAccountId();
          ALEipUtils.setTemp(rundata, context, WebMailUtils.ACCOUNT_ID, Integer.toString(accountId));
        } else {
          // アカウントが一つも見つからなかった
          return;
        }
      } catch (Exception e) {
      }
    }

    // アカウントを取得
    EipMMailAccount account = ALMailUtils.getMailAccount(userId, accountId);

    // 現在選択中のフォルダを取得
    EipTMailFolder mailFolder = WebMailUtils.getEipTMailFolder(account, String.valueOf(folderId));

    // change start
    // フォルダが取得できなかったとき、アカウントに紐付いたデフォルトのフォルダIDを取得する
    // if (mailFolder == null) {
    // folderId = account.getDefaultFolderId();
    default_folder_id = account.getDefaultFolderId();

    // フォルダが取得できなかった場合、
    // またはセッションから取得したフォルダIDが受信トレイのものでない場合は
    // アカウントに紐付いた受信トレイのフォルダIDを取得する
    if (mailFolder == null || !ALMailUtils.FOLDER_KIND_RECEIVE.equals(mailFolder.getFolderKind())) {
      folderId = account.getDefaultFolderId();
      // change end

      // セッションにセット
      ALEipUtils.setTemp(rundata, context, WebMailUtils.FOLDER_ID, String.valueOf(folderId));

      // 再取得
      mailFolder = WebMailUtils.getEipTMailFolder(account, String.valueOf(folderId));
    }

    // プルダウン用のフォルダリストを取得
    try {
      // change start 運用保守障害５８
      // mailFolderList = WebMailUtils.getMailFolderAll(account, folder_kind);
      // for (int i = 0; i < mailFolderList.size(); i++) {
      // // ルートフォルダは除く
      // if (mailFolderList.get(i).getParentFolderId() == 0) {
      // mailFolderList.remove(i);
      // }
      // }
      mailFolderList = new ArrayList<ExtFolderInfo>();

      List<ExtFolderInfo> tmp = WebMailUtils.getFolderList(WebMailUtils.ROOT_PARENT_FODLER_ID, accountId, WebMailConsts.RECEIVE_FOLDER);

      mailFolderList.addAll(tmp);

      // tmp =
      // WebMailUtils.getFolderList(
      // WebMailUtils.ROOT_PARENT_FODLER_ID,
      // accountId,
      // WebMailConsts.SEND_FOLDER);
      //
      // mailFolderList.addAll(tmp);
      // change end 運用保守障害

      for (int i = 0; i < mailFolderList.size(); i++) {
        // 初期選択用ごみ箱フォルダID
        if (ALMailUtils.FOLDER_TYPE_TRASH.equals(mailFolderList.get(i).getFolderType())) {
          trash_folder_id = mailFolderList.get(i).getFolderId();
        }
      }
    } catch (Exception e) {
      throw new ALDBErrorException();
    }

    // 全文検索
    // ページャからきた場合に検索ワードをセッションへ格納する
    if (!rundata.getParameters().containsKey(ALEipConstants.LIST_START)
      && !rundata.getParameters().containsKey(ALEipConstants.LIST_SORT)
      && rundata.getParameters().containsKey("sword")) {
      ALEipUtils.setTemp(rundata, context, "WebMailWord", rundata.getParameters().getString("sword"));
    }

    if (!rundata.getParameters().containsKey(ALEipConstants.LIST_START)
      && !rundata.getParameters().containsKey(ALEipConstants.LIST_SORT)
      && rundata.getParameters().containsKey("subjectword")) {
      ALEipUtils.setTemp(rundata, context, "WebMailSubjectWord", rundata.getParameters().getString("subjectword"));
    }

    if (!rundata.getParameters().containsKey(ALEipConstants.LIST_START)
      && !rundata.getParameters().containsKey(ALEipConstants.LIST_SORT)
      && rundata.getParameters().containsKey("addressword")) {
      ALEipUtils.setTemp(rundata, context, "WebMailAddressWord", rundata.getParameters().getString("addressword"));
    }

    if (!rundata.getParameters().containsKey(ALEipConstants.LIST_START)
      && !rundata.getParameters().containsKey(ALEipConstants.LIST_SORT)
      && rundata.getParameters().containsKey("includesubfolder")) {
      ALEipUtils.setTemp(rundata, context, "WebMailIncludeSubFolder", rundata.getParameters().getString("includesubfolder"));
    }

    // add start
    String mode = rundata.getParameters().getString("mode");
    if ("condition_clear".equals(mode)) {
      // 検索条件クリア指定があった場合
      ALEipUtils.setTemp(rundata, context, "WebMailWord", "");
      ALEipUtils.setTemp(rundata, context, "WebMailSubjectWord", "");
      ALEipUtils.setTemp(rundata, context, "WebMailAddressWord", "");
      ALEipUtils.setTemp(rundata, context, "WebMailIncludeSubFolder", "");
    }

    // 検索ワードの設定
    searchWord = new ALStringField();
    searchWord.setTrim(true);
    // if ("ajaxsearch".equals(mode) || "recieve".equals(mode)) {
    searchWord.setValue(ALEipUtils.getTemp(rundata, context, "WebMailWord"));
    // }

    searchSubjectWord = new ALStringField();
    searchSubjectWord.setTrim(true);
    // if ("ajaxsearch".equals(mode) || "recieve".equals(mode)) {
    searchSubjectWord.setValue(ALEipUtils.getTemp(rundata, context, "WebMailSubjectWord"));
    // }

    searchAddressWord = new ALStringField();
    searchAddressWord.setTrim(true);
    // if ("ajaxsearch".equals(mode) || "recieve".equals(mode)) {
    searchAddressWord.setValue(ALEipUtils.getTemp(rundata, context, "WebMailAddressWord"));
    // }

    includeSubFolder = new ALStringField();
    includeSubFolder.setTrim(true);
    includeSubFolder.setValue(ALEipUtils.getTemp(rundata, context, "WebMailIncludeSubFolder"));

    // add end

    // 現在選択しているタブが受信トレイか送信トレイか
    if (accountId > 0) {
      int type_mail = (WebMailUtils.TAB_RECEIVE.equals(currentTab)) ? ALFolder.TYPE_RECEIVE : ALFolder.TYPE_SEND;
      ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();

      // add by motegi start 全文検索
      ALMailSearchCondition cond = new ALMailSearchCondition();
      cond.setSearchWord(searchWord.getValue());
      cond.setSearchSubjectWord(searchSubjectWord.getValue());
      cond.setSearchAddressWord(searchAddressWord.getValue());
      cond.setIncludeSubFolder(includeSubFolder.getValue());
      // add end

      // change start
      // folder =
      // handler.getALFolder(type_mail, orgId, userId, Integer
      // .valueOf(accountId));
      folder = handler.getALFolder(type_mail, orgId, userId, Integer.valueOf(accountId), cond);
      // change end
      folder.setRowsNum(super.getRowsNum());
    }

    super.init(action, rundata, context);

    // ソート対象が日時だった場合、ソート順を逆にする．
    if ("date".equals(ALEipUtils.getTemp(rundata, context, LIST_SORT_STR))) {
      String sort_type = ALEipUtils.getTemp(rundata, context, LIST_SORT_TYPE_STR);
      if (sort_type == null || sort_type.equals("")) {
        ALEipUtils.setTemp(rundata, context, LIST_SORT_TYPE_STR, ALEipConstants.LIST_SORT_TYPE_DESC);
      }
    }

    // change start
    // 表示用のフォルダーリストを取得して、選択されているフォルダーもあわせて取得
    // int fid = WebMailUtils.ROOT_FODLER_ID;
    // String tmpfid =
    // ALEipUtils.getTemp(rundata, context, WebMailUtils.SESSION_KEY_FOLDER_ID);
    // if (tmpfid != null && !"".equals(tmpfid)) {
    // fid = Integer.parseInt(tmpfid);
    // }

    // 自ポートレットからのリクエストであれば、パラメータを展開しセッションに保存する。
    // if (ALEipUtils.isMatch(rundata, context)) {
    // // リクエストにフォルダーIDがあればセッションの値を変更します。
    // if (rundata.getParameters().containsKey(
    // WebMailUtils.REQUEST_KEY_FOLDER_ID)) {
    // // リクエストにフォルダーIDがあればこちらを設定します。
    // fid =
    // Integer.parseInt(rundata.getParameters().getString(
    // WebMailUtils.REQUEST_KEY_FOLDER_ID));
    // }
    // }

    // List<EipTMailFolder> rootList = WebMailUtils.getRootFolderId(accountId);
    // folder_hierarchy_list = new ArrayList<ExtFolderInfo>();
    // for (EipTMailFolder root : rootList) {
    // List<ExtFolderInfo> tmpList =
    // WebMailUtils.getFolderList2(WebMailUtils.ROOT_PARENT_FODLER_ID, root
    // .getFolderId(), accountId);
    // if (tmpList != null) {
    // folder_hierarchy_list.addAll(tmpList);
    // }
    // }

    folder_hierarchy_list = WebMailUtils.getFolderList(WebMailUtils.ROOT_PARENT_FODLER_ID, accountId, folder_kind);

    if (folder_hierarchy_list != null && folder_hierarchy_list.size() > 0) {
      int size = folder_hierarchy_list.size();
      for (int i = 0; i < size; i++) {
        ExtFolderInfo info = folder_hierarchy_list.get(i);
        if (info.getFolderId() == folderId) {
          selected_folderinfo = info;
          break;
        }
      }
      if (selected_folderinfo == null) {
        selected_folderinfo = folder_hierarchy_list.get(0);
      }
    }

    // change end
  }

  /**
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void loadMailAccountList(RunData rundata, Context context) throws Exception {
    try {
      // メールアカウント一覧
      mailAccountList = new ArrayList<WebmailAccountLiteBean>();

      List<EipMMailAccount> aList = WebMailUtils.getMailAccountNameList(ALEipUtils.getUserId(rundata));

      if (aList == null) {
        return;
      }

      WebmailAccountLiteBean bean = null;
      Iterator<EipMMailAccount> iter = aList.iterator();
      while (iter.hasNext()) {
        EipMMailAccount account = iter.next();
        // change start
        // bean = new WebmailAccountLiteBean();
        // bean.initField();
        // bean.setAccountId(account.getAccountId());
        // bean.setAccountName(account.getAccountName());
        bean = WebMailUtils.getWebmailAccountLiteBean(account, false);
        mailAccountList.add(bean);
        // change end
      }

      // add start
      // 代理受信アカウントの取得
      List<AvzTMailSendRecvAcl> deputyList = ALMailUtils.getRepresentReceiveAccount(ALEipUtils.getUserId(rundata));
      // メールアカウント一覧に追加
      for (AvzTMailSendRecvAcl deputyAccount : deputyList) {
        EipMMailAccount account = ALMailUtils.getMailAccount(deputyAccount.getAccountId());
        bean = WebMailUtils.getWebmailAccountLiteBean(account, true);
        mailAccountList.add(bean);
      }
      // add end

    } catch (Exception ex) {
      // logger.error("Exception", ex);
      throw ex;
    }
  }

  // add start
  /**
   * メールボックス容量情報を取得して設定します。
   * <p>
   * 設定内容:<BR>
   * メールボックス容量上限(MB) <BR>
   * メールボックス使用率 <BR>
   * メールボックス未使用率 <BR>
   * メールボックス使用容量計(MB) <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @throws Exception
   */
  public void loadMailBoxVolume(RunData rundata, Context context) throws Exception {
    try {

      // ログインユーザーの全アカウントID取得
      List<EipMMailAccount> accountList = WebMailUtils.getMailAccountNameList(ALEipUtils.getUserId(rundata));
      List<Integer> accountIdList = new ArrayList<Integer>();
      for (int i = 0; i < accountList.size(); i++) {
        accountIdList.add(accountList.get(i).getAccountId());
      }
      // メールボックス容量上限取得
      mailBoxVolumeMax = new ALNumberField();
      mailBoxVolumeMax.setValue(WebMailUtils.getMailVolumeMax());

      // ログインユーザーの全フォルダ使用容量計取得
      WebMailFolderVolumeSummaryBean folderVolumeSummaryBean = new WebMailFolderVolumeSummaryBean();

      folderVolumeSummaryBean = WebMailUtils.getFolderVolumeSummaryBean(accountIdList);
      // メールボックス使用率
      mailBoxVolumePct = new ALNumberField();
      mailBoxVolumePct = folderVolumeSummaryBean.getMailBoxVolumePct();
      // メールボックス未使用率
      mailBoxVolumeEmptyPct = new ALNumberField();
      mailBoxVolumeEmptyPct = folderVolumeSummaryBean.getMailBoxVolumeEmptyPct();
      // フォルダ使用容量計
      mailBoxVolumeSummary = new ALNumberField();
      mailBoxVolumeSummary = folderVolumeSummaryBean.getFolderVolumeSummary();

      // メールボックス使用率が100%以上の場合
      msgList = new ArrayList<String>();
      // change start 受入障害対応No.218
      // if (Integer.parseInt(mailBoxVolumePct.toString()) >= 100) {
      if (Long.parseLong(mailBoxVolumePct.toString()) >= 100) {
        // change end
        msgList.add("メールボックスがいっぱいの為メール送信が行えません。下の「メール退避・削除・移動」より退避、削除を行ってください。 ");
      }

    } catch (Exception ex) {
      throw ex;
    }

  }

  // add end

  /**
   * メールの一覧を取得する．
   * 
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected ResultList<EipTMail> selectList(RunData rundata, Context context) {
    try {
      if (folder == null) {
        return null;
      }

      // add start 要件No.1 スケジュール案内受信
      // リクエストURLを取得
      JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      myUrl = jsLink.getPortletById(rundata.getParameters().getString(JetspeedResources.PATH_PORTLETID_KEY)).toString();
      // add end

      // add start
      WebMailUtils.setFolderVisible(folder_hierarchy_list, selected_folderinfo);
      // add end

      // フォルダごとの未読メール数を取得
      // ・フォルダの切り替え、受信送信タブの移動、ソート時には未読メール数をセッションから取得する
      // ・メールのフォルダ間移動、メール詳細画面を出した後は未読メール数をデータベースから取得する
      // ・セッションが空の場合は未読メール数をデータベースから取得する
      String unreadMailSumMapString = ALEipUtils.getTemp(rundata, context, "unreadmailsummap");
      if ((rundata.getParameters().containsKey("noupdateunread") || rundata.getParameters().containsKey("sort") || rundata.getParameters().containsKey("tab"))
        && unreadMailSumMapString != null
        && !rundata.getParameters().containsKey("updateunread")) {
        // セッションから得た文字列をHashMapに再構成
        unreadMailSumMap = WebMailUtils.getUnreadMailSumMapFromString(unreadMailSumMapString);
      } else {
        // セッションが空か、パラメータが指定されていなければ取得しなおす
        unreadMailSumMap = WebMailUtils.getUnreadMailNumberMap(rundata, userId, accountId);
      }

      // セッションに保存
      ALEipUtils.setTemp(rundata, context, "unreadmailsummap", unreadMailSumMap.toString());

      return folder.getIndexRows(rundata, context);
    } catch (Exception ex) {
      logger.error("受信メール一覧取得に失敗しました。　" + ALEipUtils.getUserFullName(userId), ex);
      return null;
    }
  }

  /**
   * 
   * @param rundata
   * @param context
   * @return
   * @throws ALPageNotFoundException
   */
  @Override
  protected ALMailMessage selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
    try {

      // add start
      JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);

      // リクエストURLを取得
      myUrl = jsLink.getPortletById(rundata.getParameters().getString(JetspeedResources.PATH_PORTLETID_KEY)).toString();

      // 現通信がHTTPかHTTPSかを判別
      if (myUrl != null && myUrl.startsWith("https:")) {
        isSSL = true;
      } else {
        isSSL = false;
      }

      // ポートレット ID を取得する．
      String portletId = ((JetspeedRunData) rundata).getJs_peid();
      CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(rundata.getRequest().getHeader("User-Agent"));
      MediaTypeEntry media = (MediaTypeEntry) Registry.getEntry(Registry.MEDIA_TYPE, cm.getPreferredMediaType());
      mediatype = media.getName();

      // add end

      String mailid = ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);

      if (mailid == null || Integer.valueOf(mailid) == null) {
        // Mail IDが空の場合
        logger.debug("[Mail] Empty ID...");
        return null;
      }
      // change start 2012.2.7 受入障害No.272
      // 代理受信の場合はステータスの変更は行わない
      // return folder.getMail(Integer.valueOf(mailid));
      // change start 2012.2.24 受入障害No.294
      // return folder.getMail(Integer.valueOf(mailid), isRepresent);
      // アカウントを取得
      EipMMailAccount account = ALMailUtils.getMailAccount(accountId);
      return folder.getMail(Integer.valueOf(mailid), isRepresent, account.getAccountUsage());
      // change end 2012.2.24
      // change end 2012.2.7
    } catch (Throwable e) {
      logger.error("受信メール情報の詳細取得に失敗しました。", e);
      throw new ALPageNotFoundException();
    }
  }

  /**
   * ResultDataを取得する（メールの一覧） <BR>
   * 
   * 
   */
  @Override
  protected Object getResultData(EipTMail record) {

    WebMailIndexRowResultData rd = new WebMailIndexRowResultData();
    rd.initField();

    // add start
    // メールファイルが存在しないデータは件名をリンクとしない
    ALLocalMailMessage msg = null;
    // メールファイルの内容を取得
    try {
      msg = ALMailUtils.readMail(folder.getFullName() + ALStorageService.separator() + record.getFilePath());

      // add start 要件No.1 スケジュール案内受信
      // Aipoスケジュールポートレットから自動配信されたメールなのかを判別
      if (isDirectLinkTarget(msg, record)) {
        String tmpBody = msg.getBodyText();
        Pattern pattern = Pattern.compile("(https|http)\\:([\\w|\\:\\!\\#\\$\\%\\=\\&\\-\\^\\`\\\\|\\@\\~\\[\\{\\]\\}\\;\\+\\*\\,\\.\\?\\/]+)");
        Matcher matcher = pattern.matcher(tmpBody);

        String chunk = null;
        while (matcher.find()) {
          chunk = matcher.group();
        }
        if (chunk != null && chunk.contains("ScheduleDetailScreen")) {
          // 最後にヒットしたものからリクエストパラメータを抽出する。
          // （本文などで誤検知させないため）
          boolean tmpRepresent = false;
          if (isUserMailAccount && isRepresent) {
            tmpRepresent = true;
          }
          String t = myUrl + "?" + chunk.split("[?]")[1] + "&mailid=" + record.getMailId() + "&represent=" + tmpRepresent;
          rd.setScheduleDetailUrl(t);
          rd.setFromAipoSchedulePortlet(true);
        }
      }
      // add end
    } catch (Exception e) {
      logger.warn("メールファイルがありません。", e);
      msg = null;
    }
    if (null == msg) {
      // メールファイルがない場合はフラグON
      rd.setNoMailFile(true);
    } else {
      rd.setNoMailFile(false);
    }
    // add end

    rd.setMailId(record.getMailId().toString());

    // 状態
    String isRead = record.getReadFlg();
    // 既読
    if ("T".equals(isRead)) {
      rd.setReadImage("themes/" + getTheme() + "/images/icon/webmail_readmail.gif");
      rd.setReadImageDescription("既読");
      rd.setRead(false);
    } else {
      // 未読
      rd.setReadImage("themes/" + getTheme() + "/images/icon/webmail_unreadmail.gif");
      rd.setReadImageDescription("未読");
      rd.setRead(true);
    }

    // add start
    String replyForward = record.getReplyForward();
    // 返信済メールの場合 状態に返信画像を設定
    if ("R".equals(replyForward)) {
      rd.setReadImage("images/webmail/webmail_reply_mail.gif");
      rd.setReadImageDescription("返信");
    }
    // 転送済メールの場合 状態に転送画像を設定
    if ("F".equals(replyForward)) {
      rd.setReadImage("images/webmail/webmail_forward_mail.gif");
      rd.setReadImageDescription("転送");
    }
    // add end

    // 件名のデコード
    String subject = ALMailUtils.decodeSubject(record.getSubject());
    rd.setSubject(ALCommonUtils.compressString(subject, getStrLength()));

    // remove start 受入テスト障害331
    // 差出人のデコード
    // change start
    // rd.setPerson(MailUtility.decodeText(record.getPerson()));
    // 表示名<メールアドレス>のうち、表示名だけを設定
    // 表示名<メールアドレス>の形式になっていない場合はそのまま設定する
    // String[] person = MailUtility.decodeText(record.getPerson()).split("<");
    // rd.setPerson(person[0]);
    // change end
    // remove end

    // add start 受入テスト障害331
    InternetAddress address = null;
    try {
      address = (InternetAddress) msg.getFrom()[0];
    } catch (Exception e) {
      logger.error("差出人情報取得に失敗しました。" + ALEipUtils.getUserFullName(userId), e);
    }
    if (address != null) {
      String tmp = WebMailUtils.getDisplayName(address.getAddress(), loginUserId);
      if (tmp != null) {
        rd.setPerson(tmp);
      } else {
        String[] person = MailUtility.decodeText(record.getPerson()).split("<");
        rd.setPerson(person[0]);
      }
      // if (address.getPersonal() != null && !"".equals(address.getPersonal()))
      // {
      // String[] person =
      // MailUtility.decodeText(record.getPerson()).split("<");
      // rd.setPerson(person[0]);
      // } else {
      // rd.setPerson(WebMailUtils.getDisplayName(
      // address.getAddress(),
      // loginUserId));
      // }
    }
    // add end

    // 日付
    rd.setDate(record.getEventDate());
    // 容量
    rd.setFileVolume(record.getFileVolume().toString());

    // 添付ファイルの有無
    boolean hasAttachments = ("T".equals(record.getHasFiles()));
    // 添付ファイルがある場合は画像を設定
    if (hasAttachments) {
      rd.setWithFilesImage("images/webmail/webmail_withfiles.gif");
      rd.setWithFilesImageDescription("添付有");
    }
    rd.hasAttachments(hasAttachments);

    return rd;
  }

  /**
   * 
   * @param obj
   * @return
   * @throws ALPageNotFoundException
   */
  @Override
  protected Object getResultDataDetail(ALMailMessage obj) throws ALPageNotFoundException {
    WebMailResultData rd = null;
    try {
      ALLocalMailMessage msg = (ALLocalMailMessage) obj;

      String date = "";

      Date sentDate = msg.getSentDate();
      if (sentDate == null) {
        date = "Unknown";
      } else {
        date = ALMailUtils.translateDate(sentDate);
      }
      rd = new WebMailResultData();
      rd.initField();
      rd.setHeaders(msg.getHeaderArray());

      // change start 2011/12/20 IBM拡張文字対応
      // rd.setSubject(msg.getSubject());
      rd.setSubject(ALMailUtils.decodeSubject(msg.getHeader("Subject", null)));
      // change end

      rd.setFrom(ALMailUtils.getAddressString(msg.getFrom()));
      rd.setTo(ALMailUtils.getAddressString(msg.getRecipients(Message.RecipientType.TO)));
      rd.setDate(date);

      rd.setBody(msg.getBodyText());
      rd.setAttachmentFileNames(msg.getAttachmentFileNameArray());

      // add start
      // Aipoスケジュールポートレットから自動配信されたメールなのかを判別
      String[] aipoFlg = msg.getHeader("X-Aipo-Portlet");
      if (aipoFlg != null && aipoFlg.length > 0) {
        rd.setFromAipoSchedulePortlet(true);
      }

      // 現通信はHTTPSかを設定
      rd.setSSL(isSSL);

      // リクエストURLを設定
      rd.setUrl(myUrl);

      // メディアタイプを設定
      rd.setMediatype(mediatype);

      // 開封確認要求付きメッセージなのかどうか判断して、要求があればここで返信
      String str = msg.getDispositionNotificationTo();
      if (str != null && !msg.isNotificationFlg()) {

        int replyAccountid = accountId;
        int representAccountid = 0;
        if (isRepresent) {
          replyAccountid = defaultAccount.getAccountId();
          representAccountid = accountId;
        }

        WebMailUtils.sendReplyForDispositionNotification(str, msg, loginUserId, replyAccountid, representAccountid, orgId);
        // 開封確認送信済みフラグ更新
        EipTMail email = ALMailUtils.getEipTMail(Integer.toString(msg.getMailId()));
        email.setNotificationFlg("T");
        Database.commit();
      }
      // add end

      // add start
      Address[] ccs = msg.getRecipients(Message.RecipientType.CC);
      rd.setCc(ALMailUtils.getAddressString(ccs));
      // add end
    } catch (Exception e) {
      // change start
      Database.rollback();
      // logger.error("Exception", e);
      logger.error("受信メール情報の詳細取得に失敗しました。", e);
      throw new ALPageNotFoundException();
    }
    return rd;
  }

  /**
   * 現在選択されているタブを取得します。 <BR>
   * 
   * @return
   */
  public String getCurrentTab() {
    return currentTab;
  }

  /**
   * 現在のアカウントが持つメールフォルダを取得します。
   * 
   * @return
   */
  // change start 運用障害５８
  // public List<WebMailFolderResultData> getFolderList() {
  public List<ExtFolderInfo> getFolderList() {
    // change end
    return mailFolderList;
  }

  /**
   * @return
   * 
   */
  @Override
  protected Attributes getColumnMap() {
    return null;
  }

  /**
   * 
   * @return
   */
  public List<WebmailAccountLiteBean> getMailAccountList() {
    return mailAccountList;
  }

  /**
   * 現在選択中のアカウントIDを取得します。
   * 
   * @return
   */
  public int getAccountId() {
    return accountId;
  }

  /**
   * 現在選択中のフォルダIDを取得します。
   * 
   * @return
   */
  public int getFolderId() {
    return folderId;
  }

  // remove start
  // /**
  // * 現在選択中のフォルダを取得します。
  // *
  // * @return
  // */
  // public WebMailFolderResultData getSelectedFolder() {
  // return selectedFolder;
  // }
  // remove end

  public int getNewMailSum() {
    try {
      return WebMailUtils.getNewMailNumThread(orgId, user, accountId);
    } catch (Exception ex) {
      return 0;
    }
  }

  /**
   * フォルダ別未読メール数を取得する。
   * 
   * @return
   */
  public int getUnReadMailSumByFolderId(int folder_id) {
    return unreadMailSumMap.get(folder_id);
  }

  public String getFinalAccessDate() {
    return finalAccessDateStr;
  }

  /**
   * 表示する項目数を取得します。
   * 
   * @return
   */
  @Override
  public int getRowsNum() {
    return folder.getRowsNum();
  }

  /**
   * 総件数を取得します。
   * 
   * @return
   */
  @Override
  public int getCount() {
    return folder.getCount();
  }

  /**
   * 総ページ数を取得します。
   * 
   * @return
   */
  @Override
  public int getPagesNum() {
    return folder.getPagesNum();
  }

  /**
   * 現在表示されているページを取得します。
   * 
   * @return
   */
  @Override
  public int getCurrentPage() {
    return folder.getCurrentPage();
  }

  /**
   * 
   * @return
   */
  @Override
  public String getCurrentSort() {
    return folder.getCurrentSort();
  }

  /**
   * 
   * @return
   */
  @Override
  public String getCurrentSortType() {
    return folder.getCurrentSortType();
  }

  /**
   * @return
   */
  @Override
  public int getStart() {
    return folder.getStart();
  }

  /**
   * 
   * @param id
   * @return
   */
  public boolean isMatch(int id1, long id2) {
    return id1 == (int) id2;
  }

  /**
   * メール受信処理のメッセージを返します。
   * <p>
   * ログインユーザーの全アカウントに対して行います。<BR>
   * ※受信処理メッセージ <BR>
   * ・メールを受信中です <BR>
   * ・メールを受信しました etc
   * 
   * @return メール受信処理メッセージ
   * @throws Exception
   */
  public String getStatStr() throws Exception {
    // change start
    // ログインユーザーの全アカウント取得
    List<EipMMailAccount> accountList = WebMailUtils.getMailAccountNameList(userId);

    // 代理受信アカウントの取得
    List<AvzTMailSendRecvAcl> deputyList = new ArrayList<AvzTMailSendRecvAcl>();
    try {
      deputyList = ALMailUtils.getRepresentReceiveAccount(userId);
    } catch (Exception e) {
      logger.error("メール受信　代理受信アカウント取得に失敗しました。", e);
    }

    // アカウントIDリスト作成
    List<Integer> accountIdList = new ArrayList<Integer>();
    // ログインユーザーアカウント
    for (EipMMailAccount account : accountList) {
      accountIdList.add(account.getAccountId());
    }
    // 代理受信アカウント
    for (AvzTMailSendRecvAcl avzTMailSendRecvAcl : deputyList) {
      accountIdList.add(avzTMailSendRecvAcl.getAccountId());
    }
    // int accountId = 0;
    String msg = null;
    StringBuffer statStr = new StringBuffer();

    // 全アカウントで受信メッセージ取得
    for (Integer accountId : accountIdList) {

      // 受信メッセージ取得
      msg = ALPop3MailReceiveThread.getReceiveMailResultStr(user, accountId);
      if (null != msg && msg.length() > 0) {
        if (statStr.length() > 0) {
          statStr.append("<br/>");
        }
        EipMMailAccount account = ALMailUtils.getMailAccount(accountId);
        statStr.append(account.getAccountName());
        statStr.append(" ");
        statStr.append(msg);

        if (null != msg && msg.equals("メールを受信しました。")) {
          msgList.add(account.getAccountName() + "に新着メールがあります。");
        }
      }
    }

    // return ALPop3MailReceiveThread.getReceiveMailResultStr(user, accountId);
    return statStr.toString();
  }

  // change end

  // add start 2012.1.31 受入障害対応No.253
  /**
   * メール受信処理のメッセージを返します。
   * <p>
   * ログインユーザーの全アカウントに対して行います。<BR>
   * ※受信処理メッセージ <BR>
   * ・メールを受信中です <BR>
   * ・メールを受信しました etc
   * 
   * @return メール受信処理メッセージ
   * @throws Exception
   */
  public String getStatStrMobile() throws Exception {
    StringBuffer statStr = new StringBuffer();
    try {
      // ログインユーザーの全アカウント取得
      List<EipMMailAccount> accountList = WebMailUtils.getMailAccountNameList(userId);

      // delete start 2012.4.2 受入障害対応No.351
      // 代理受信アカウントの取得
      // List<AvzTMailSendRecvAcl> deputyList =
      // new ArrayList<AvzTMailSendRecvAcl>();
      //
      // try {
      // deputyList = ALMailUtils.getRepresentReceiveAccount(userId);
      // } catch (Exception e) {
      // logger.error("メール受信 代理受信アカウント取得に失敗しました。", e);
      // }
      // delete end 2012.4.2

      // アカウントIDリスト作成
      List<Integer> accountIdList = new ArrayList<Integer>();
      // ログインユーザーアカウント
      for (EipMMailAccount account : accountList) {
        accountIdList.add(account.getAccountId());
      }
      // delete start 2012.4.2 受入障害対応No.351
      // 代理受信アカウント
      // for (AvzTMailSendRecvAcl avzTMailSendRecvAcl : deputyList) {
      // accountIdList.add(avzTMailSendRecvAcl.getAccountId());
      // }
      // delete end 2012.4.2

      String msg = null;

      // 全アカウントで受信メッセージ取得
      for (Integer accountId : accountIdList) {

        // 受信メッセージ取得
        msg = ALPop3MailReceiveThread.getReceiveMailResultStr(user, accountId);
        if (null != msg && msg.length() > 0) {
          if (statStr.length() > 0) {
            statStr.append("<br/>");
          }
          EipMMailAccount account = ALMailUtils.getMailAccount(accountId);
          statStr.append(account.getAccountName());
          statStr.append(" ");
          statStr.append(msg);

          if (null != msg && msg.equals("メールを受信しました。")) {
            msgList = new ArrayList<String>();
            msgList.add(account.getAccountName() + "に新着メールがあります。");
          }
        }
      }
    } catch (Exception e) {
      logger.error("メール受信処理のメッセージ取得に失敗しました。", e);
    }
    return statStr.toString();
  }

  // add end

  // add start
  public List<ExtFolderInfo> getFolderHierarchyList() {
    return folder_hierarchy_list;
  }

  // add end

  // change start
  // public ExtFolderInfo getSelectedFolderInfo() {
  public ExtFolderInfo getSelectedFolder() {
    return selected_folderinfo;
  }

  // change end

  // add start
  // /**
  // * 開封確認
  // * <p>
  // * 受信メールが開封確認要求付きメッセージであれば返信する。<BR>
  // *
  // * @param to
  // * 開封通知送信先アドレス
  // * @param msg
  // * 受信メール情報
  // * @throws MessagingException
  // * 受信メール情報の取得に失敗した場合スローします。
  // * @throws Exception
  // * 異常発生時にスローします。
  // */
  // private void sendReplyForDispositionNotification(String to,
  // ALLocalMailMessage msg) throws MessagingException, Exception {
  //
  // try {
  // String subject = "開封済み_" + msg.getSubject();
  // String body = "";
  // String delim = ",";
  //
  // String messageID = msg.getMessageID();
  // Map<String, String> map = new LinkedHashMap<String, String>();
  // map.put("References", messageID);
  //
  // // オブジェクトモデルを取得
  // EipMMailAccount account = ALMailUtils.getMailAccount(userId, accountId);
  //
  // ALMailHandler handler =
  // ALMailFactoryService.getInstance().getMailHandler();
  // // 送信サーバ情報
  // ALMailSenderContext scontext =
  // ALMailUtils.getALSmtpMailSenderContext(orgId, account);
  //
  // ALSmtpMailContext mailcontext =
  // ALMailUtils.getALSmtpMailContext(
  // ALMailUtils.getTokens(ALStringUtil.unsanitizing(to), delim),
  // null,
  // null,
  // account.getMailAddress(),
  // ALStringUtil.unsanitizing(account.getMailUserName()),
  // ALStringUtil.unsanitizing(subject),
  // ALStringUtil.unsanitizing(body),
  // null,
  // map,
  // false,
  // true);
  //
  // int success_send = handler.send(scontext, mailcontext);
  // if (success_send == ALSmtpMailSender.SEND_MSG_SUCCESS) {
  //
  // } else {
  // if (success_send == ALSmtpMailSender.SEND_MSG_FAIL) {
  // logger.error("メールを送信できませんでした。アカウント設定が間違っている可能性があります。");
  // } else if (success_send == ALSmtpMailSender.SEND_MSG_OVER_MAIL_MAX_SIZE) {
  // logger.error("7MB を超えるサイズのメールは送信できません。");
  // } else if (success_send == ALSmtpMailSender.SEND_MSG_FAIL_SMTP_AUTH) {
  // logger.error("メールを送信できませんでした。SMTP認証の認証に失敗しました。");
  // }
  // }
  // } catch (MessagingException e) {
  // String Errmsg =
  // "開封確認メールを送信できませんでした。["
  // + ALEipUtils.getBaseUser(userId).getUserName()
  // + "]";
  // logger.error(Errmsg, e);
  // throw e;
  // } catch (Exception e) {
  // String Errmsg =
  // "開封確認メールを送信できませんでした。["
  // + ALEipUtils.getBaseUser(userId).getUserName()
  // + "]";
  // logger.error(Errmsg, e);
  // throw e;
  // }
  // }

  /**
   * 検索ワード 本文を返す。<BR>
   * 
   * @return 検索ワード 本文
   */
  public ALStringField getSearchWord() {
    return searchWord;
  }

  /**
   * 検索ワード 件名を返す。<BR>
   * 
   * @return 検索ワード 件名
   */
  public ALStringField getSearchSubjectWord() {
    return searchSubjectWord;
  }

  /**
   * 検索ワード 差出人を返す。<BR>
   * 
   * @return 検索ワード 差出人
   * @return
   */
  public ALStringField getSearchAddressWord() {
    return searchAddressWord;
  }

  /**
   * 検索 サブフォルダを含む を返す。<BR>
   * 
   * @return 検索ワード 差出人
   * @return
   */
  public ALStringField getIncludeSubFolder() {
    return includeSubFolder;
  }

  /**
   * ごみ箱フォルダIDを返す。<BR>
   * 
   * @return ごみ箱フォルダID
   */
  public int getTrashFolderId() {
    return trash_folder_id;
  }

  /**
   * デフォルトフォルダ（受信トレイ）IDを返す。<BR>
   * 
   * @return デフォルトフォルダID
   */
  public int getDefaultFolderId() {
    return default_folder_id;
  }

  /**
   * １ユーザーあたりメールボックス容量上限を返す<BR>
   * 
   * @return mailBoxVolumeMax
   */
  public ALNumberField getMailBoxVolumeMax() {
    return mailBoxVolumeMax;
  }

  /**
   * メールボックス容量計を返す。<BR>
   * 
   * @return mailBoxVolumeSummary
   */
  public ALNumberField getMailBoxVolumeSummary() {
    return mailBoxVolumeSummary;
  }

  /**
   * メールボックス使用率を返す。<BR>
   * 
   * @return mailBoxVolumePct
   */
  public ALNumberField getMailBoxVolumePct() {
    return mailBoxVolumePct;
  }

  /**
   * メールボックス未使用率を返す。<BR>
   * 
   * @return mailBoxVolumeEmptyPct
   */
  public ALNumberField getMailBoxVolumeEmptyPct() {
    return mailBoxVolumeEmptyPct;
  }

  /**
   * メッセージリストを返す。<BR>
   * 
   * @return msgList
   * @throws Exception
   */
  public List<String> getMsgList() throws Exception {
    return msgList;
  }

  /**
   * 代理受信アカウントフラグを返す。<BR>
   * 
   * @return isRepresent
   */
  public boolean isRepresent() {
    return isRepresent;
  }

  // add start 要件No.1 スケジュール案内受信
  private boolean isDirectLinkTarget(ALLocalMailMessage msg, EipTMail record) throws MessagingException {

    boolean direct = false;

    // Aipoスケジュールポートレットから自動配信されたメールなのかを判別
    String[] aipoFlg = msg.getHeader("X-Aipo-Portlet");
    if (aipoFlg != null && aipoFlg.length > 0) {
      String[] directLinkFlg = msg.getHeader("X-Aipo-Portlet-Schedule-DirectLink");
      if (directLinkFlg != null && directLinkFlg.length > 0) {
        String flg = directLinkFlg[0];
        if ("true".equals(flg)) {
          direct = true;
        }
      } else {
        // 回答メール もしくは 旧バージョンのメール
        String subject = ALMailUtils.decodeSubject(record.getSubject());
        if (subject.startsWith("[会議案内]予定")) {
          // 旧バージョンのメール
          if (!subject.startsWith("[会議案内]予定回答")) {
            direct = true;
          }
        }
      }
    }
    return direct;
  }
  // add end
}
