/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailFolderSelectData;

/**
 * Webメールフォルダの一覧を処理するクラスです。 <br />
 * 
 */
public class WebMailFolderListScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService
      .getLogger(WebMailFolderListScreen.class.getName());

  /**
   * 一覧画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {
      WebMailFolderSelectData listData = new WebMailFolderSelectData();
      listData.initField();
      listData.loadMailAccountList(rundata, context);
      // 最大20件表示
      listData.setRowsNum(20);
      listData.doViewList(this, rundata, context);
      setTemplate(
        rundata,
        context,
        "portlets/html/ja/ajax-webmail-folder-list.vm");
    } catch (Exception ex) {
      logger.error("[WebMailFolderListScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
