if(!dojo._hasResource["aipo.schedule.dnd.OneDaySpanScheduleMove"]){
dojo._hasResource["aipo.schedule.dnd.OneDaySpanScheduleMove"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// 1日スケジュール期間予定クリック・ドラッグ＆ドロップ
dojo.provide("aipo.schedule.dnd.OneDaySpanScheduleMove");

dojo.require("aimluck.dnd.Draggable");
dojo.require("aipo.common");
dojo.require("aipo.widget.ToolTip");
dojo.require("aipo.schedule");
dojo.require("aipo.schedule.common");
dojo.require("aipo.schedule.oneday");

/**
 *1日スケジュール用期間予定ドラッグ＆ドロップコントローラー
 */
dojo.declare("aipo.schedule.dnd.OneDaySpanScheduleDraggable", [aimluck.dnd.Draggable], {
    // ツールチップ
    tooltipObject: null,
    // ドラッグ対象要素のスケジュール
    schedule: null,
    // 照会可否
    canReference: false,
    /** コンストラクタ */
    constructor: function(node, params){
    },
    /** マウス押下 */
    onMouseDown: function(e){
        // 処理なし
    },
    /** クリック */
    onScheduleClick: function(e) {
        // add start 要件No.16　スケジュール画面（月単位／週単位／日単位）右クリックメニュー
        if( e.button == 2 || e.button == 4 ) return;
        // addd end

        // ツールチップ土台を削除する
        if(!!this.tooltipObject){
            this.tooltipObject.close();
        }
        // 照会可否フラグで操作可否をチェック
        if(!this.canReference) {
            return;
        }
        // スケジュール詳細を開く
        aipo.common.showWindow(
            ptConfig[this.portletId].detailUrl
            + "&entityId=" + this.schedule.scheduleId
            + "&view_date=" + ptConfig[this.portletId].jsonData.formDateTime
            + "&userid=" + this.schedule.ownerId,
            this.portletId,
            aipo.schedule.onLoadScheduleDetail);
        // IEで追加ダイアログを閉じるとスクロールバーのｙ座標が強制的に0になってしまう現象の対策用
        aipo.schedule.tmpScroll = parseInt(dojo.byId('weeklyScrollPane_'+this.portletId)["scrollTop"], 10);
    },
    // add start 要件No.16　スケジュール画面（月単位／週単位／日単位）右クリックメニュー
    onRightClick: function(e) {
      var uid = this.schedule.ownerId;
      var secid = dojo.byId('secid-' + this.portletId).value;
      var baseUrl = ptConfig[this.portletId].thisUrl + "?entityId=" + this.schedule.scheduleId + "&view_date=" + ptConfig[this.portletId].jsonData.formDateTime;
      var detailUrl = ptConfig[this.portletId].detailUrl + "&entityId=" + this.schedule.scheduleId + "&view_date=" + ptConfig[this.portletId].jsonData.formDateTime + "&userid=" + uid;
      var hasMember = "false";
      var item = this.schedule;
      if(item.memberList){
          var ucount = 0;
          var fcount = 0;
          for (j = 0 ; j < item.memberList.length ; j ++){
              if(item.memberList[j].charAt(0) == 'f'){
                  fcount++;
              }else{
                  ucount++;
              }
          }
          if( ucount > 1 ) {
            hasMember = "true";
          }
      }
      // ツールチップ土台を削除する
      if(this.tooltipObject)this.tooltipObject.close();

      //コンテキストメニュー表示
      aipo.schedule.common.showMenu(
          e,
          this.portletId,
          detailUrl,
          baseUrl,
          this.schedule.status,
          this.schedule.priority ? "true" : "false",
          this.schedule.repeat ? "true" : "false",
          this.schedule.member ? "true" : "false",
          this.schedule.organizer ? "true" : "false",
          hasMember,
          this.schedule.loginuser ? "true" : "false",
          uid,
          secid,
          this.node,
          aipo.schedule.oneday.loadSchedule);
      e.preventDefault();
      e.stopPropagation();
    },
    onRightClickForNonPulic: function(e) {
      //非公開のスケジュールを右クリックした場合に標準のコンテキストメニューの表示を抑止
      e.preventDefault();
      e.stopPropagation();
    },
    // add end
    /** マウスオーバー */
    onScheduleOver: function(e) {
        // 照会可否フラグで操作可否をチェック
        if(!this.canReference){
            return;
        }
        // ツールチップ無効中は処理を終了する
        if(ptConfig[this.portletId].isTooltipEnable == false){
            return;
        }
        // IPADではツールチップ非表示
        if (scheduleTooltipEnable) {
            this.setupTooltip();
        }
    },
    /** ツールチップ表示 */
    setupTooltip: function() {
        if(!this.tooltipObject){
            var pid = this.portletId;
            var sid = this.schedule.scheduleId;
            this.tooltipObject = new aipo.widget.ToolTip({
                label: "<div class='indicator'>読み込み中...</div>",
                connectId: [this.node.id]},
                this.portletId,
                function(containerNode, node){
                    var request_url = ptConfig[pid].jsonUrl.split("?")[0]
                        + "?template=ScheduleDetailJSONScreen"
                        + "&view_date=" + ptConfig[pid].jsonData.startDate
                        + "&scheduleid=" + sid;
                    aipo.schedule.oneday.showTooltip(request_url, pid, containerNode);
                }
            );
        }
        aipo.schedule.oneday.objectlist.push(this.tooltipObject);
    }
});

}