/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.AvzTScheduleFile;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormWindow;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.ScheduleConst.DayOfWeek;
import com.aimluck.eip.schedule.ScheduleConst.DayType;
import com.aimluck.eip.schedule.ScheduleConst.ScheduleWeekNumber;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.services.eventlog.ALEventlogConstants;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.user.beans.UserGroupPositionLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュールのフォームデータを管理するクラスです。
 * 
 */
public class ScheduleFormData
// change start
    // 運用課題No.68
    // extends ALAbstractFormData {
    extends ALAbstractFormWindow {
  // change end

  /** <code>logger</code> logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleFormData.class.getName());

  /** <code>FLAG_EDIT_REPEAT_DEF</code> デフォルト値（繰り返し編集範囲） */
  private static final int FLAG_EDIT_REPEAT_DEF = -1;

  /** <code>FLAG_EDIT_REPEAT_ALL</code> 個別日程を編集（繰り返し編集範囲） */
  private static final int FLAG_EDIT_REPEAT_ALL = 0;

  /** <code>FLAG_EDIT_SCHEDULE_ONE</code> 全日程を編集（繰り返し編集範囲） */
  private static final int FLAG_EDIT_REPEAT_ONE = 1;

  /** <code>FLAG_DEL_MEMBER_ALL</code> [削除フラグ] すべての共有メンバーからこのスケジュールを削除する */
  public static final int FLAG_DEL_MEMBER_ALL = 0;

  /** <code>FLAG_DEL_MEMBER_ONE</code> [削除フラグ] このスケジュールからログインユーザーだけを削除する */
  public static final int FLAG_DEL_MEMBER_ONE = 1;

  /** <code>FLAG_DEL_RANGE_ALL</code> [削除フラグ] この繰り返しスケジュールを削除する */
  public static final int FLAG_DEL_RANGE_ALL = 0;

  /** <code>FLAG_DEL_RANGE_ONE</code> [削除フラグ] この繰り返しスケジュールの特定スケジュールのみを削除する */
  public static final int FLAG_DEL_RANGE_ONE = 1;

  /** <code>start_date</code> 開始日時 */
  private ALDateTimeField start_date;

  /** <code>end_date</code> 終了日時 */
  private ALDateTimeField end_date;

  // add start
  // 直接/選択入力対応
  /** 開始時刻入力 */
  private ALStringField tx_start_time;

  /** 終了時刻入力 */
  private ALStringField tx_end_time;

  /** 直接入力フラグ */
  private String time_input_type = null;

  /** 処理モード */
  private String mode = null;

  // add end

  /** <code>name</code> 予定 */
  private ALStringField name;

  /** <code>place</code> 場所 */
  private ALStringField place;

  /** <code>note</code> 内容 */
  private ALStringField note;

  /** <code>public_flag</code> 公開/非公開フラグ */
  private ALStringField public_flag;

  /** <code>repeat_type</code> 繰り返し種別 */
  private ALStringField repeat_type;

  /** <code>week_0</code> 繰り返し曜日 */
  private ALStringField week_0;

  /** <code>week_1</code> 繰り返し曜日 */
  private ALStringField week_1;

  /** <code>week_2</code> 繰り返し曜日 */
  private ALStringField week_2;

  /** <code>week_3</code> 繰り返し曜日 */
  private ALStringField week_3;

  /** <code>week_4</code> 繰り返し曜日 */
  private ALStringField week_4;

  /** <code>week_5</code> 繰り返し曜日 */
  private ALStringField week_5;

  /** <code>week_6</code> 繰り返し曜日 */
  private ALStringField week_6;

  /** <code>limit_flag</code> 期限ありなし */
  private ALStringField limit_flag;

  /** <code>limit_date</code> 繰り返し期限（開始日） */
  private ALDateField limit_start_date;

  /** <code>limit_date</code> 繰り返し期限（終了日） */
  private ALDateField limit_end_date;

  /** <code>month_day</code> 繰り返す日 */
  private ALNumberField month_day;

  /** <code>memberList</code> メンバーリスト */
  private List<ALEipUser> memberList;

  // add start
  // 必須/任意メンバー対応
  /** <code>reqMemberList</code> 必須メンバーリスト */
  private List<ALEipUser> reqMemberList;

  /** <code>subMemberList</code> 任意メンバーリスト */
  private List<ALEipUser> subMemberList;

  // add end
  /** <code>currentYear</code> 現在の年 */
  private int currentYear;

  /** <code>is_member</code> スケジュールを共有するかどうか */
  private boolean is_member;

  /** <code>is_repeat</code> 繰り返すかどうか */
  private boolean is_repeat;

  /** <code>is_span</code> 期間指定かどうか */
  private boolean is_span;

  // add start
  /** 日またぎか */
  private boolean is_straddle;

  // add end

  // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
  /** 仮の予定か */
  private boolean is_temporary;

  // add end

  /** <code>all_day_flag</code> 終日予定フラグ */
  private ALStringField all_day_flag;

  // remove start
  // 同一用途のフィールド変数があるため統一
  // /** <code>login_user</code> ログインユーザー */
  // private ALEipUser login_user;
  // remove start

  /** <code>tmpStart</code> 開始日時の初期値 */
  private String tmpStart;

  /** <code>tmpEnd</code> 終了日時の初期値 */
  private String tmpEnd;

  /** <code>selectData</code> 編集するスケジュールの1日の情報 */
  private ScheduleOnedayGroupSelectData selectData;

  /** <code>groups</code> グループ */
  private List<ALEipGroup> groups;

  /** <code>edit_schedule_flag</code> 繰り返しスケジュールの編集フラグ */
  private ALNumberField edit_repeat_flag;

  /** <code>tmpView</code> 表示する日 */
  private String tmpView;

  /** <code>end_date</code> 終了日時 */
  private ALDateTimeField view_date;

  /** <code>edit_control_flag</code> 共有メンバーによる編集／削除権限フラグ */
  private ALStringField edit_flag;

  /** <code>enable_change_tmpreserve</code> 仮スケジュールに戻すかどうか */
  private ALStringField change_tmpreserve_flag;

  /** <code>del_member_flag</code> [削除フラグ] 共有メンバーを削除するフラグ */
  private ALNumberField del_member_flag;

  /** <code>del_range_flag</code> [削除フラグ] 削除範囲のフラグ */
  private ALNumberField del_range_flag;

  /** <code>isOwner</code> 所有者かどうか */
  private boolean is_owner;

  /** <code>is_facility</code> 施設を予約するかどうか */
  private boolean is_facility;

  /** 施設リスト */
  private List<Object> facilityList;

  /** 全施設リスト */
  private List<FacilityResultData> facilityAllList;

  /** <code>todo_id</code> ToDo ID */
  private ALNumberField common_category_id;

  private final int msg_type = 0;

  // remove start
  // 使用していないため削除
  // private String orgId;
  // remove end

  /** ログインユーザー情報 */
  private ALEipUser loginUser;

  // remove start
  // 使用していないため削除
  // private boolean ignore_duplicate_facility;
  // remove end

  private boolean is_copy;

  /** <code>is_same_date</code> 開始日時と終了日時が同じかどうか */
  private boolean is_same_date;

  /** アクセス権限の機能名 */
  private String aclPortletFeature = null;

  // add start

  /** 対象ユーザー */
  private ALEipUser currentUser = null;

  /** 対象ユーザー部署 */
  private UserGroupPositionLiteBean currentUserGroupPosition = null;

  // 定期パターン追加
  // 日パターン
  /** 日間隔 * */
  private ALNumberField day_interval;

  // 週パターン
  /** 週間隔 */
  private ALNumberField week_interval;

  private ALStringField week_dow_1;

  private ALStringField week_dow_2;

  private ALStringField week_dow_3;

  private ALStringField week_dow_4;

  private ALStringField week_dow_5;

  private ALStringField week_dow_6;

  private ALStringField week_dow_7;

  // 月パターン
  /** 月パターン */
  private ALStringField month_type;

  private ALNumberField md_month_interval;

  private ALNumberField md_day;

  private ALNumberField mw_month_interval;

  private ALNumberField mw_count;

  private ALStringField mw_dow;

  // 年パターン
  /** 年パターン */
  private ALStringField year_type;

  /** 年パターン：月日 */
  private ALNumberField ymd_month;

  private ALNumberField ymd_day;

  private ALNumberField ymw_month;

  private ALNumberField ymw_count;

  private ALStringField ymw_dow;

  /** 繰り返し期間終了パターン */
  private ALStringField limit_type;

  /** 反復回数 */
  private ALNumberField repeat_num;

  /** 時刻入力形式:直接入力 */
  private static final String TIME_INPUT_TYPE_TEXT = "T";

  /** セッションキー：メール送信用スケジュール（削除時のメール送信リトライ用） */
  private static final String S_SCHDULE_FOR_SENDMAIL = "session.ScheduleFormData.ScheduleForSendMail";

  /** セッションキー：メール送信用送信先（削除時のメール送信リトライ用） */
  private static final String S_USERS_FOR_SENDMAIL = "session.ScheduleFormData.UsersForSendMail";

  /** セッションキー：メール送信用必須参加メンバー（削除時のメール送信リトライ用） */
  private static final String S_REQUSERS_FOR_SENDMAIL = "session.ScheduleFormData.ReqUsersForSendMail";

  /** セッションキー：メール送信用任意参加メンバー（削除時のメール送信リトライ用） */
  private static final String S_SUBUSERS_FOR_SENDMAIL = "session.ScheduleFormData.SubUsersForSendMail";

  /** セッションキー：メール送信用削除範囲フラグ（削除時のメール送信リトライ用） */
  private static final String S_RANGEFLAG_FOR_SENDMAIL = "session.ScheduleFormData.RangeFlagForSendMail";

  // add end

  // add start 要件No.2 スケジュール案内送信
  /** キャンセル理由 */
  private ALStringField cancel_reason;

  // add end

  // add start 要件No.18 会議案内ファイル添付
  /** 添付ファイルリスト */
  private List<FileuploadLiteBean> fileuploadList = null;

  /** 添付フォルダ名 */
  private String folderName;

  // add end

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#doViewForm(ALAction,
   * RunData, Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    is_facility = rundata.getParameters().getBoolean("is_facility");
    is_member = rundata.getParameters().getBoolean("is_member");
    is_repeat = rundata.getParameters().getBoolean("is_repeat");
    is_span = rundata.getParameters().getBoolean("is_span");
    is_copy = rundata.getParameters().getBoolean("is_copy");
    // add start
    // 日またぎ
    is_straddle = rundata.getParameters().getBoolean("is_straddle");
    // 処理モード
    mode = rundata.getParameters().getString("mode");
    // add end

    // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
    is_temporary = rundata.getParameters().getBoolean("is_temporary");
    // add end

    // remove start
    // 使用していないため削除
    // ignore_duplicate_facility =
    // rundata.getParameters().getBoolean("ignore_duplicate_facility", false);
    // ログインユーザー情報
    // login_user = ALEipUtils.getALEipUser(rundata);
    // remove end
    groups = ALEipUtils.getMyGroups(rundata);

    is_owner = true;

    // remove start
    // 使用していないため削除
    // orgId = Database.getDomainName();
    // remove end
    loginUser = ALEipUtils.getALEipUser(rundata);

    // add start
    // 対象ユーザーを取得
    int currentUserId = 0;
    if (rundata.getParameters().containsKey("userid")) {
      currentUserId = rundata.getParameters().getInt("userid");
    } else {
      // 得られない場合はログインユーザーを対象ユーザーとする
      currentUserId = (int) loginUser.getUserId().getValue();
    }
    currentUser = ALEipUtils.getALEipUser(currentUserId);

    // 対象ユーザーの部署情報を取得
    List<UserGroupPositionLiteBean> sendToUserPostionList = UserUtils.getPostPositionBeanList((int) currentUser.getUserId().getValue());
    if (null != sendToUserPostionList) {
      currentUserGroupPosition = sendToUserPostionList.get(0);
    }
    // add end

    facilityAllList = new ArrayList<FacilityResultData>();
    facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());

    // 新規作成時の終日設定
    // change start
    // 追加/更新以外を対象とする
    // if (tmpEnd != null
    // && !tmpEnd.equals("")
    // && tmpStart != null
    // && !tmpStart.equals("")
    // && is_span
    // && tmpStart.equals(tmpEnd)) {
    if (!"insert".equals(mode)
      && !"update".equals(mode)
      && tmpEnd != null
      && !tmpEnd.equals("")
      && tmpStart != null
      && !tmpStart.equals("")
      && is_span
      && tmpStart.equals(tmpEnd)) {
      // change end
      // 新しい予定追加で終日の場合
      all_day_flag.setValue("ON");
    }

    // change start
    // 権限は「自分の予定」固定にする
    // String scheduleId =
    // rundata.getParameters().getString(ALEipConstants.ENTITY_ID);
    // if (scheduleId == null || scheduleId.equals("new")) {
    // String members[] = rundata.getParameters().getStrings("member_to");
    // if (members != null && members.length > 0) {
    // aclPortletFeature =
    // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_OTHER;
    //
    // String user_name = login_user.getName().toString();
    // for (String member : members) {
    // if (user_name.equals(member)) {
    // aclPortletFeature =
    // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF;
    // break;
    // }
    // }
    // } else {
    // aclPortletFeature =
    // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF;
    // }
    // } else if (ScheduleUtils.hasRelation(rundata)) {
    // aclPortletFeature =
    // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF;
    // } else {
    // aclPortletFeature =
    // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_OTHER;
    // }
    aclPortletFeature = ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF;
    // change end

    // add start 要件No.18 会議案内ファイル添付
    folderName = rundata.getParameters().getString("folderName");
    // add end

    /*
     */
    // スーパークラスのメソッドを呼び出す。
    super.init(action, rundata, context);
  }

  /**
   * 基準日を読み込みます。
   * 
   * @param rundata
   *          実行データ
   * @param context
   *          コンテキスト
   */
  public void loadParametersViewDate(RunData rundata, Context context) {
    if (ALEipUtils.isMatch(rundata, context)) {
      if (rundata.getParameters().containsKey("view_date")) {
        ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd");
        tmpView = rundata.getParameters().getString("view_date");
        ALEipUtils.setTemp(rundata, context, "tmpView", tmpView);
        dummy.setValue(tmpView);
        if (!dummy.validate(new ArrayList<String>())) {
          ALEipUtils.removeTemp(rundata, context, "tmpView");
          logger.debug("[ScheduleFormData] Parameter cannot validate");
          ALEipUtils.redirectPageNotFound(rundata);
          return;
        }
      } else {
        if (tmpView == null || tmpView.equals("")) {
          if (tmpStart != null && !tmpStart.equals("")) {
            tmpView = tmpStart;
            ALEipUtils.setTemp(rundata, context, "tmpView", tmpView);
          }
        }
      }
    }
  }

  /**
   * パラメータを読み込みます。
   * 
   * @param rundata
   *          実行データ
   * @param context
   *          コンテキスト
   */
  public void loadParameters(RunData rundata, Context context) {
    ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd-HH-mm");
    dummy.setNotNull(true);
    if (ALEipUtils.isMatch(rundata, context)) {
      if (rundata.getParameters().containsKey("form_start")) {
        tmpStart = rundata.getParameters().getString("form_start");
        ALEipUtils.setTemp(rundata, context, "tmpStart", tmpStart);
        dummy.setValue(tmpStart);
        if (!dummy.validate(new ArrayList<String>())) {
          // change start
          // セッション格納値を削除するよう修正
          // ALEipUtils.removeTemp(rundata, context, "form_start");
          // ALEipUtils.removeTemp(rundata, context, "form_end");
          ALEipUtils.removeTemp(rundata, context, "tmpStart");
          ALEipUtils.removeTemp(rundata, context, "tmpEnd");
          // change end
          logger.debug("[ScheduleFormData] Parameter cannot validate");
          ALEipUtils.redirectPageNotFound(rundata);
          return;
        }
      } else {
        dummy.setValue(new Date());
        ALEipUtils.setTemp(rundata, context, "tmpStart", dummy.toString());
      }
      if (rundata.getParameters().containsKey("form_end")) {
        tmpEnd = rundata.getParameters().getString("form_end");
        ALEipUtils.setTemp(rundata, context, "tmpEnd", tmpEnd);
        dummy.setValue(tmpEnd);
        if (!dummy.validate(new ArrayList<String>())) {
          // change start
          // セッション格納値を削除するよう修正
          // ALEipUtils.removeTemp(rundata, context, "form_start");
          // ALEipUtils.removeTemp(rundata, context, "form_end");
          ALEipUtils.removeTemp(rundata, context, "tmpStart");
          ALEipUtils.removeTemp(rundata, context, "tmpEnd");
          // change end
          logger.debug("[ScheduleFormData] Parameter cannot validate");
          ALEipUtils.redirectPageNotFound(rundata);
          return;
        }
      } else {
        dummy.setValue(new Date());
        ALEipUtils.setTemp(rundata, context, "tmpEnd", dummy.toString());
      }
    }
    tmpStart = ALEipUtils.getTemp(rundata, context, "tmpStart");
    tmpEnd = ALEipUtils.getTemp(rundata, context, "tmpEnd");

    loadParametersViewDate(rundata, context);
  }

  /**
   * 入力フィールドを初期化します。
   * 
   */
  public void initField() {
    Date now = new Date();
    Calendar cal = Calendar.getInstance();
    int min = cal.get(Calendar.MINUTE);

    for (int _min = 5; _min <= 60; _min += 5) {
      if (_min - 5 <= min && min <= _min) {
        cal.set(Calendar.MINUTE, _min);
        break;
      }
    }
    // 開始日時
    start_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
    if (tmpStart == null || tmpStart.equals("")) {
      start_date.setValue(now);
    } else {
      start_date.setValue(tmpStart);
    }
    start_date.setFieldName("開始日時");
    // 終了日時
    end_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
    if (tmpEnd == null || tmpEnd.equals("")) {
      if (tmpStart == null || tmpStart.equals("")) {
        end_date.setValue(now);
      } else {
        end_date.setValue(tmpStart);
      }
    } else {
      end_date.setValue(tmpEnd);
    }
    end_date.setFieldName("終了日時");
    // 開始日時と終了日時が同じか
    if (start_date.toString().equals(end_date.toString())) {
      is_same_date = true;
    } else {
      is_same_date = false;
    }
    // add start
    // 直接/選択入力対応
    // 開始時刻入力
    tx_start_time = new ALStringField("");
    tx_start_time.setFieldName("開始時刻（直接入力）");
    tx_start_time.setTrim(true);

    // 終了時刻入力
    tx_end_time = new ALStringField("");
    tx_end_time.setFieldName("終了時刻（直接入力）");
    tx_end_time.setTrim(true);
    // add end

    // 繰り返しタイプ
    repeat_type = new ALStringField();
    repeat_type.setFieldName("繰り返しタイプ");
    // remove start
    // repeat_type.setValue("D");
    // remove end
    repeat_type.setTrim(true);
    // 日
    week_0 = new ALStringField();
    week_0.setFieldName("日");
    week_0.setTrim(true);
    // 月
    week_1 = new ALStringField();
    week_1.setFieldName("月");
    week_1.setTrim(true);
    // 火
    week_2 = new ALStringField();
    week_2.setFieldName("火");
    week_2.setTrim(true);
    // 水
    week_3 = new ALStringField();
    week_3.setFieldName("水");
    week_3.setTrim(true);
    // 木
    week_4 = new ALStringField();
    week_4.setFieldName("木");
    week_4.setTrim(true);
    // 金
    week_5 = new ALStringField();
    week_5.setFieldName("金");
    week_5.setTrim(true);
    // 土
    week_6 = new ALStringField();
    week_6.setFieldName("土");
    week_6.setTrim(true);
    // 繰り返し日
    month_day = new ALNumberField();
    month_day.setFieldName("繰り返す月");
    // 繰り返しフラグ
    limit_flag = new ALStringField();
    limit_flag.setFieldName("繰り返し");
    limit_flag.setValue("OFF");
    limit_flag.setTrim(true);
    // 繰り返し期限
    limit_start_date = new ALDateField();
    limit_start_date.setFieldName("繰り返し期限");
    limit_start_date.setValue(start_date.getValue());
    limit_end_date = new ALDateField();
    limit_end_date.setFieldName("繰り返し期限");
    ALDateTimeField tmp_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
    if (tmpEnd == null || tmpEnd.equals("")) {
      if (tmpStart == null || tmpStart.equals("")) {
        tmp_date.setValue(now);
        limit_end_date.setValue(tmp_date.getValue());
      } else {
        tmp_date.setValue(tmpStart);
        limit_end_date.setValue(tmp_date.getValue());
      }
    } else {
      tmp_date.setValue(tmpEnd);
      limit_end_date.setValue(tmp_date.getValue());
    }
    // 終日フラグ
    all_day_flag = new ALStringField();
    all_day_flag.setFieldName("終日");
    all_day_flag.setTrim(true);
    all_day_flag.setValue("OFF");
    // 予定
    name = new ALStringField();
    name.setFieldName("予定");
    name.setTrim(true);
    // 場所
    place = new ALStringField();
    place.setFieldName("場所");
    place.setTrim(true);
    // 内容
    note = new ALStringField();
    note.setFieldName("内容");
    note.setTrim(false);
    // 公開区分
    public_flag = new ALStringField();
    public_flag.setFieldName("公開区分");
    public_flag.setTrim(true);
    public_flag.setValue("O");
    // 繰り返しスケジュールの編集フラグ
    edit_repeat_flag = new ALNumberField();
    edit_repeat_flag.setFieldName("繰り返し編集範囲");
    edit_repeat_flag.setValue(FLAG_EDIT_REPEAT_DEF);

    // 指定日時
    view_date = new ALDateTimeField("yyyy-MM-dd");
    if (tmpView == null || tmpView.equals("")) {
      view_date.setValue(now);
    } else {
      view_date.setValue(tmpView);
    }
    view_date.setFieldName("指定日時");

    // 共有メンバーによる編集／削除権限フラグ
    edit_flag = new ALStringField();
    edit_flag.setFieldName("編集／削除権限");
    edit_flag.setTrim(true);
    // chage start
    // 不可固定
    edit_flag.setValue("F");
    // edit_flag.setValue("T");
    // chage end

    // 仮スケジュールに戻すかどうか
    change_tmpreserve_flag = new ALStringField();
    change_tmpreserve_flag.setFieldName("仮スケジュール");
    change_tmpreserve_flag.setTrim(true);
    change_tmpreserve_flag.setValue("F");

    // メンバーリスト
    memberList = new ArrayList<ALEipUser>();
    // add start
    // 必須メンバーリスト
    reqMemberList = new ArrayList<ALEipUser>();
    // 任意メンバーリスト
    subMemberList = new ArrayList<ALEipUser>();
    // add end
    // 現在の年（年を選択するリストボックスに利用）
    currentYear = Calendar.getInstance().get(Calendar.YEAR);

    // [削除フラグ] 共有メンバーを削除するフラグ
    del_member_flag = new ALNumberField();
    del_member_flag.setValue(FLAG_DEL_MEMBER_ALL);
    // [削除フラグ] 削除範囲のフラグ
    del_range_flag = new ALNumberField();
    del_range_flag.setValue(FLAG_DEL_RANGE_ALL);

    // 施設リスト
    facilityList = new ArrayList<Object>();

    // 2007.3.28 ToDo連携
    common_category_id = new ALNumberField();
    common_category_id.setFieldName("カテゴリ");
    common_category_id.setValue(1);

    // add start
    // 定期パターン増加対応

    // 日パターン
    day_interval = new ALNumberField();
    day_interval.setFieldName("日間隔");

    // 週パターン
    week_interval = new ALNumberField();
    week_interval.setFieldName("週間隔");
    week_dow_1 = new ALStringField();
    week_dow_1.setFieldName("日");
    week_dow_1.setTrim(true);
    week_dow_2 = new ALStringField();
    week_dow_2.setFieldName("月");
    week_dow_2.setTrim(true);
    week_dow_3 = new ALStringField();
    week_dow_3.setFieldName("火");
    week_dow_3.setTrim(true);
    week_dow_4 = new ALStringField();
    week_dow_4.setFieldName("水");
    week_dow_4.setTrim(true);
    week_dow_5 = new ALStringField();
    week_dow_5.setFieldName("木");
    week_dow_5.setTrim(true);
    week_dow_6 = new ALStringField();
    week_dow_6.setFieldName("金");
    week_dow_6.setTrim(true);
    week_dow_7 = new ALStringField();
    week_dow_7.setFieldName("土");
    week_dow_7.setTrim(true);

    // 月パターン
    month_type = new ALStringField();
    // 月・日パターン
    md_month_interval = new ALNumberField();
    md_month_interval.setFieldName("月間隔");
    md_day = new ALNumberField();

    // 月・曜日パターン
    mw_month_interval = new ALNumberField();
    mw_month_interval.setFieldName("月間隔");
    mw_count = new ALNumberField();
    mw_dow = new ALStringField();

    // 年パターン
    year_type = new ALStringField();
    // 年・月・日パターン
    ymd_month = new ALNumberField();
    ymd_day = new ALNumberField();

    // 年・月・曜日パターン
    ymw_month = new ALNumberField();
    ymw_count = new ALNumberField();
    ymw_dow = new ALStringField();

    // 繰り返しパターン初期化
    repeat_type.setValue(ScheduleConst.REPEAT_TYPE_DAY);
    month_type.setValue(ScheduleConst.MONTH_TYPE_MD);
    year_type.setValue(ScheduleConst.YEAR_TYPE_MD);

    // 有効期限パターン
    limit_type = new ALStringField();
    // 反復回数
    repeat_num = new ALNumberField();
    repeat_num.setFieldName("反復回数");

    // 有効期限パターン初期化
    limit_type.setValue(ScheduleConst.LIMIT_TYPE_NONEND);
    // add end

    // add start 要件No.2 スケジュール案内送信
    // キャンセル理由
    cancel_reason = new ALStringField();
    cancel_reason.setFieldName("内容");
    cancel_reason.setTrim(true);
    // add end

    // add start 要件No.18 会議案内ファイル添付
    fileuploadList = new ArrayList<FileuploadLiteBean>();
    // add end
  }

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#setFormData(RunData,
   * Context, List<String>)
   */
  @Override
  protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    boolean res = super.setFormData(rundata, context, msgList);
    // add start
    // 時刻の入力形式を取得
    if (rundata.getParameters().containsKey("time_input_type")) {
      time_input_type = rundata.getParameters().getString("time_input_type");
    }
    // add end

    if (res) {
      try {
        // add start 要件No.24 メール添付ファイルタイムアウト対応
        if (!FileuploadUtils.checkFileuploadList(rundata, msgList, "スケジュール")) {
          return false;
        }
        // add end

        // change start
        // if (!is_span) {
        // if (rundata.getParameters().containsKey("end_date_hour")
        // && rundata.getParameters().containsKey("end_date_minute")) {
        // if ("".equals(rundata.getParameters().get("end_date_hour"))
        // && "".equals(rundata.getParameters().get("end_date_minute"))) {
        // end_date = start_date;
        // } else if ("".equals(rundata.getParameters().get("end_date_hour"))
        // || "".equals(rundata.getParameters().get("end_date_minute"))) {
        // end_date = null;
        // }
        // }
        // }
        // 追加/更新時のみ実行
        if (("insert".equals(mode) || "update".equals(mode))) {

          // add start 要件No.18 会議案内ファイル添付
          fileuploadList = ScheduleUtils.getFileuploadList(rundata);
          // add end

          // 期間予定でない かつ 直接入力の場合、直接入力欄を先行入力チェック・開始日時と終了日時へ設定
          if (!is_span && isTimeTextInput()) {
            // 入力形式パラメータがある かつ 直接入力の場合

            SimpleDateFormat timeFormat = new SimpleDateFormat("H:mm");
            timeFormat.setLenient(false);

            // 開始時刻入力
            if ("".equals(tx_start_time.getValue())) {

              msgList.add("『 <span class='em'>開始時刻</span> 』を入力してください。");

              // 以降の代入や入力チェックでnullエラーが発生しないよう、開始時刻を00：00にする。
              Calendar tmp_date = Calendar.getInstance();
              tmp_date.setTime(start_date.getValue());
              tmp_date.set(Calendar.HOUR_OF_DAY, 0);
              tmp_date.set(Calendar.MINUTE, 0);
              tmp_date.set(Calendar.SECOND, 0);
              start_date.setValue(tmp_date.getTime());

            } else {

              Calendar startTime = Calendar.getInstance();
              try {
                // 変換 兼 形式チェック
                startTime.setTime(timeFormat.parse(tx_start_time.getValue()));

                // 直接入力の開始時刻を開始日時へセット
                Calendar tmp_date = Calendar.getInstance();
                tmp_date.setTime(start_date.getValue());
                tmp_date.set(Calendar.HOUR_OF_DAY, startTime.get(Calendar.HOUR_OF_DAY));
                tmp_date.set(Calendar.MINUTE, startTime.get(Calendar.MINUTE));
                tmp_date.set(Calendar.SECOND, 0);
                start_date.setValue(tmp_date.getTime());

              } catch (ParseException e) {
                msgList.add("『 <span class='em'>開始時刻</span> 』には23:59までの時刻を入力してください。");

                // 以降の代入や入力チェックでnullエラーが発生しないよう、開始時刻を00：00にする。
                Calendar tmp_date = Calendar.getInstance();
                tmp_date.setTime(start_date.getValue());
                tmp_date.set(Calendar.HOUR_OF_DAY, 0);
                tmp_date.set(Calendar.MINUTE, 0);
                tmp_date.set(Calendar.SECOND, 0);
                start_date.setValue(tmp_date.getTime());
              }
            }

            // 終了時刻入力
            if ("".equals(tx_end_time.getValue())) {

              // 終了時刻が未入力の場合は、開始時刻を設定する
              Calendar tmp_date = Calendar.getInstance();
              tmp_date.setTime(end_date.getValue());
              tmp_date.set(Calendar.HOUR_OF_DAY, Integer.parseInt(start_date.getHour()));
              tmp_date.set(Calendar.MINUTE, Integer.parseInt(start_date.getMinute()));
              tmp_date.set(Calendar.SECOND, 0);
              end_date.setValue(tmp_date.getTime());

            } else {

              Calendar endTime = Calendar.getInstance();
              try {
                // 変換 兼 形式チェック
                endTime.setTime(timeFormat.parse(tx_end_time.getValue()));

                // 直接入力の終了時刻を終了日時へセット
                Calendar tmp_date = Calendar.getInstance();
                tmp_date.setTime(end_date.getValue());
                tmp_date.set(Calendar.HOUR_OF_DAY, endTime.get(Calendar.HOUR_OF_DAY));
                tmp_date.set(Calendar.MINUTE, endTime.get(Calendar.MINUTE));
                tmp_date.set(Calendar.SECOND, 0);
                end_date.setValue(tmp_date.getTime());

              } catch (ParseException e) {

                msgList.add("『 <span class='em'>終了時刻</span> 』には23:59までの時刻を入力してください。");

                // 以降の代入や入力チェックでnullエラーが発生しないよう、終了時刻に開始時刻を格納する。
                Calendar tmp_date = Calendar.getInstance();
                tmp_date.setTime(end_date.getValue());
                tmp_date.set(Calendar.HOUR_OF_DAY, Integer.parseInt(start_date.getHour()));
                tmp_date.set(Calendar.MINUTE, Integer.parseInt(start_date.getMinute()));
                tmp_date.set(Calendar.SECOND, 0);
                end_date.setValue(tmp_date.getTime());
              }
            }
          }

          // 期間予定でない かつ 選択入力 かつ 終了時刻が"-":"-"の場合、開始時刻と同じにする
          // 終了時刻の時分の片方のみ"-"の場合、形式エラーとする
          if (!is_span && !isTimeTextInput()) {
            if ("".equals(rundata.getParameters().get("end_date_hour")) && "".equals(rundata.getParameters().get("end_date_minute"))) {

              // 日またぎ予定もあるため、時刻のみ設定する
              Calendar tmp_date = Calendar.getInstance();
              tmp_date.setTime(end_date.getValue());
              tmp_date.set(Calendar.HOUR_OF_DAY, Integer.parseInt(start_date.getHour()));
              tmp_date.set(Calendar.MINUTE, Integer.parseInt(start_date.getMinute()));
              tmp_date.set(Calendar.SECOND, 0);
              end_date.setValue(tmp_date.getTime());

            } else if ("".equals(rundata.getParameters().get("end_date_hour")) || "".equals(rundata.getParameters().get("end_date_minute"))) {

              msgList.add("『 <span class='em'>終了時刻</span> 』を正しく入力してください。");

              // 以降の代入や入力チェックでnullエラーが発生しないよう、終了時刻に開始時刻を格納する。
              Calendar tmp_date = Calendar.getInstance();
              tmp_date.setTime(end_date.getValue());
              tmp_date.set(Calendar.HOUR_OF_DAY, Integer.parseInt(start_date.getHour()));
              tmp_date.set(Calendar.MINUTE, Integer.parseInt(start_date.getMinute()));
              tmp_date.set(Calendar.SECOND, 0);
              end_date.setValue(tmp_date.getTime());
            }
          }

          // （validateから移動）
          // 繰り返し予定と単発予定の場合、開始日と終了日を一致させる
          if (!is_span && !is_straddle) {
            Calendar tmp_end_date = Calendar.getInstance();
            tmp_end_date.set(Calendar.YEAR, Integer.valueOf(start_date.getYear()));
            tmp_end_date.set(Calendar.MONTH, Integer.valueOf(start_date.getMonth()) - 1);
            tmp_end_date.set(Calendar.DATE, Integer.valueOf(start_date.getDay()));
            tmp_end_date.set(Calendar.HOUR_OF_DAY, Integer.valueOf(end_date.getHour()));
            tmp_end_date.set(Calendar.MINUTE, Integer.valueOf(end_date.getMinute()));
            tmp_end_date.set(Calendar.SECOND, 0);
            end_date.setValue(tmp_end_date.getTime());
          }

          // 期間スケジュールの場合、開始時刻 と 終了時刻 を 0時0分0秒 に設定する
          if (is_span) {
            Calendar tmp_start_date = Calendar.getInstance();
            tmp_start_date.setTime(start_date.getValue());
            tmp_start_date.set(Calendar.HOUR_OF_DAY, 0);
            tmp_start_date.set(Calendar.MINUTE, 0);
            tmp_start_date.set(Calendar.SECOND, 0);
            start_date.setValue(tmp_start_date.getTime());

            Calendar tmp_end_date = Calendar.getInstance();
            tmp_end_date.setTime(end_date.getValue());
            tmp_end_date.set(Calendar.HOUR_OF_DAY, 0);
            tmp_end_date.set(Calendar.MINUTE, 0);
            tmp_end_date.set(Calendar.SECOND, 0);
            end_date.setValue(tmp_end_date.getTime());
          }

        }
        // change end
        // 終日
        if (all_day_flag.getValue().equals("ON") && is_span) {
          end_date.setValue(start_date.getValue());
        }

        // add start
        // 主催者有無フラグ
        boolean hasOwnerUser = false;
        // add end

        // 必須メンバーを取得
        String memberNames[] = rundata.getParameters().getStrings("member_to");
        if (memberNames != null && memberNames.length > 0) {
          SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
          Expression exp = ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, memberNames);
          query.setQualifier(exp);
          memberList.addAll(ALEipUtils.getUsersFromSelectQuery(query));
          // add start
          // 必須メンバー一覧に追加
          reqMemberList.addAll(ALEipUtils.getUsersFromSelectQuery(query));
          // 必須メンバーに主催者が存在するかチェック
          for (String loginName : memberNames) {
            if (currentUser.getName().getValue().equals(loginName)) {
              hasOwnerUser = true;
              break;
            }
          }
          // add end
        }
        // remove start
        // 必須・任意メンバー合わせて0件の場合に初期化する必要があるため、削除
        // if (memberList.size() == 0) {
        // memberList.add(login_user);
        // }
        // remove end

        // add start
        // 任意メンバーを取得
        String selfishMemberNames[] = rundata.getParameters().getStrings("selfish_member_to");
        if (selfishMemberNames != null && selfishMemberNames.length > 0) {
          SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
          Expression exp = ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, selfishMemberNames);
          query.setQualifier(exp);
          List<ALEipUser> tmp = ALEipUtils.getUsersFromSelectQuery(query);
          memberList.addAll(tmp);
          subMemberList.addAll(tmp);
          // 任意メンバーに主催者が存在するかチェック
          for (String loginName : selfishMemberNames) {
            if (currentUser.getName().getValue().equals(loginName)) {
              hasOwnerUser = true;
              break;
            }
          }
        }

        // 追加/更新時に必須/任意メンバーに主催者がいない場合、エラーメッセージを設定する
        if (("insert".equals(mode) || "update".equals(mode)) && !hasOwnerUser) {
          msgList.add("『 参加メンバー 』に主催者を入れて下さい。");
        }

        // 必須・任意メンバー合わせて0件の場合に初期化
        if (reqMemberList.size() == 0 && subMemberList.size() == 0) {
          // 必須メンバーに対象ユーザーを設定
          memberList.add(currentUser);
          reqMemberList.add(currentUser);
        }
        // add end
        // add start 要件No.11 メール作成／詳細（ファイル添付）
        // フォルダ名を作成
        if (folderName == null || "".equals(folderName)) {
          folderName = "0_" + String.valueOf(System.nanoTime());
        }
        // add end

        // remove start
        // 施設廃止
        // String facilityIds[] =
        // rundata.getParameters().getStrings("facility_to");
        // if (!ScheduleUtils.isZeroLength(facilityIds)) {
        // SelectQuery<EipMFacility> fquery =
        // Database.query(EipMFacility.class);
        // Expression fexp =
        // ExpressionFactory.inDbExp(
        // EipMFacility.FACILITY_ID_PK_COLUMN,
        // facilityIds);
        // fquery.setQualifier(fexp);
        // List<EipMFacility> facilities = fquery.fetchList();
        // for (EipMFacility facility : facilities) {
        // FacilityResultData rd = new FacilityResultData();
        // rd.initField();
        // rd.setFacilityId(facility.getFacilityId().longValue());
        // rd.setFacilityName(facility.getFacilityName());
        // facilityList.add(rd);
        // }
        // }
        // remove end
      } catch (Exception ex) {
        // change start
        // logger.error("Exception", ex);
        logger.error("スケジュール作成（編集）の画面入力値取得に失敗しました。ログインユーザー:" + loginUser.getName().getValue(), ex);
        msgList.add("スケジュール作成（編集）の画面入力値取得に失敗しました。");
        return false;
        // change end
      }
    }
    return res;
  }

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  @Override
  protected void setValidator() {
    // 予定
    name.setNotNull(true);
    name.limitMaxLength(50);
    // 場所
    place.limitMaxLength(50);
    // 内容
    note.limitMaxLength(1000);
    // add start
    // 繰り返し条件
    // 日間隔
    day_interval.setNotNull(true);
    day_interval.limitValue(1L, 999L);
    // 週間隔
    week_interval.setNotNull(true);
    week_interval.limitValue(1L, 99L);
    // 月・日の月間隔
    md_month_interval.setNotNull(true);
    md_month_interval.limitValue(1L, 99L);
    // 月・曜日の月間隔
    mw_month_interval.setNotNull(true);
    mw_month_interval.limitValue(1L, 99L);
    // 反復回数
    repeat_num.setNotNull(true);
    repeat_num.limitValue(1L, 999L);
    // add end
  }

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(List<String>)
   */
  @Override
  protected boolean validate(List<String> msgList) throws ALDBErrorException, ALPageNotFoundException {

    // change start
    // try {
    // ScheduleUtils.validateDelegate(
    // getStartDate(),
    // getEndDate(),
    // getRepeatType(),
    // is_repeat,
    // is_span,
    // getWeek0(),
    // getWeek1(),
    // getWeek2(),
    // getWeek3(),
    // getWeek4(),
    // getWeek5(),
    // getWeek6(),
    // getLimitFlag(),
    // getLimitStartDate(),
    // getLimitEndDate(),
    // getMonthDay(),
    // loginUser,
    // null,
    // msgList,
    // false);
    // } catch (NumberFormatException nfe) {
    // logger
    // .error("[ScheduleFormData] NumberFormatException: Limit Date is wrong.");
    // throw new ALPageNotFoundException();
    // }
    ScheduleUtils.validateDelegate(
      is_repeat,
      is_span,
      is_straddle,
      start_date,
      end_date,
      repeat_type,
      day_interval,
      week_interval,
      getCheckedWeekDoW(),
      month_type,
      md_month_interval,
      mw_month_interval,
      limit_type,
      limit_start_date,
      limit_end_date,
      repeat_num,
      msgList);
    // change end

    // add start
    // 強化テスト障害No.58対応
    // 年⇒月・日指定パターンの不正な月日チェック
    if (is_repeat
      && ScheduleConst.REPEAT_TYPE_YEAR.equals(repeat_type.getValue())
      && ScheduleConst.YEAR_TYPE_MD.equals(year_type.getValue())
      && 99 != ymd_day.getValue()) {
      int ymd_int_year = Integer.valueOf(limit_start_date.getYear());
      int ymd_int_month = Integer.valueOf(ymd_month.getValueAsString());
      int ymd_int_day = Integer.valueOf(ymd_day.getValueAsString());
      Calendar cal = Calendar.getInstance();
      cal.setLenient(false);
      cal.set(ymd_int_year, ymd_int_month - 1, ymd_int_day);
      try {
        cal.getTime();
      } catch (IllegalArgumentException e) {
        msgList.add("指定の月日は存在しません。");
      }
    }
    // add end

    // 予定
    name.validate(msgList);
    // 場所
    place.validate(msgList);
    // 内容
    note.validate(msgList);

    common_category_id.validate(msgList);

    return (msgList.size() == 0);
  }

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(RunData,
   * Context, List<String>)
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    try {
      // オブジェクトモデルを取得
      EipTSchedule record = ScheduleUtils.getEipTSchedule(rundata, context, false);
      if (record == null) {
        return false;
      }

      // add start
      // 別ウインドウ化対応 ウインドウにエンティティIDを渡すため
      setEntityId(ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID));
      // add end

      // change start
      // 対象ユーザーより判定する
      // is_owner =
      // (record.getOwnerId().intValue() == login_user.getUserId().getValue())
      // ? true
      // : false;
      is_owner = (record.getOwnerId().intValue() == currentUser.getUserId().getValue()) ? true : false;
      // change end

      // 予定
      name.setValue(record.getName());
      // 場所
      place.setValue(record.getPlace());
      // 内容
      note.setValue(record.getNote());
      // 公開フラグ
      public_flag.setValue(record.getPublicFlag());

      // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
      // 仮の予定フラグ(NULLの場合はfalse)
      is_temporary = ("T".equals(record.getTemporaryFlag()));
      // add end

      // remove start
      // 編集削除フラグは不可固定
      // // 共有メンバーによる編集／削除フラグ
      // if ("T".equals(record.getEditFlag())) {
      // if (is_owner) {
      // edit_flag.setValue(record.getEditFlag());
      // } else {
      // // スケジュールの登録ユーザがすでにメンバーから抜けているかを検証する．
      // int createUserId = record.getOwnerId().intValue();
      // boolean inculudeCreateUser = false;
      // List<EipTScheduleMap> scheduleMaps = record.getEipTScheduleMaps();
      //
      // for (EipTScheduleMap map : scheduleMaps) {
      // if (createUserId == map.getUserId().intValue()
      // && !"R".equals(map.getStatus())) {
      // inculudeCreateUser = true;
      // break;
      // }
      // }
      // if (inculudeCreateUser) {
      // edit_flag.setValue("F");
      // } else {
      // edit_flag.setValue("T");
      // }
      // }
      // } else {
      // edit_flag.setValue("F");
      // }
      // remove end

      // DN -> 毎日 (A = N -> 期限なし A = L -> 期限あり)
      // WnnnnnnnN W01111110 -> 毎週(月～金用)
      // MnnN M25 -> 毎月25日
      // S -> 期間での指定
      String ptn = record.getRepeatPattern();
      // remove start
      // 不要なため削除（必要な場合は繰り返しパターンの最後尾を参照するべき）
      // int count = 0;
      // remove end
      is_repeat = true;
      is_span = false;
      // add start
      // 日またぎフラグ初期化
      is_straddle = false;
      // add end
      // 毎日
      if (ptn.charAt(0) == 'D') {
        repeat_type.setValue("D");
        // remove start
        // 不要なため削除（必要な場合は繰り返しパターンの最後尾を参照するべき）
        // count = 1;
        // remove end
        // 毎週
      } else if (ptn.charAt(0) == 'W') {
        repeat_type.setValue("W");
        week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
        week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
        week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
        week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
        week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
        week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
        week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
        // remove start
        // 不要なため削除（必要な場合は繰り返しパターンの最後尾を参照するべき）
        // count = 8;
        // remove end
        // 毎月
      } else if (ptn.charAt(0) == 'M') {
        repeat_type.setValue("M");
        month_day.setValue(Integer.parseInt(ptn.substring(1, 3)));
        // remove start
        // 不要なため削除（必要な場合は繰り返しパターンの最後尾を参照するべき）
        // count = 3;
        // remove end
        // add start
        // 定期パターン増加対応
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_DAILY)) {
        // 間隔 X日ごとに設定 AxxxN
        repeat_type.setValue(ScheduleConst.REPEAT_TYPE_DAY);
        day_interval.setValue(ptn.substring(1, 4));
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_WEEKLY)) {
        // 間隔 X週ごとに設定 BxxnnnnnnnL
        repeat_type.setValue(ScheduleConst.REPEAT_TYPE_WEEK);
        week_interval.setValue(Integer.parseInt(ptn.substring(1, 3)));
        week_dow_1.setValue(ptn.charAt(3) == '1' ? ScheduleConst.DOW_CHECKED : ScheduleConst.DOW_UNCHECKED);
        week_dow_2.setValue(ptn.charAt(4) == '1' ? ScheduleConst.DOW_CHECKED : ScheduleConst.DOW_UNCHECKED);
        week_dow_3.setValue(ptn.charAt(5) == '1' ? ScheduleConst.DOW_CHECKED : ScheduleConst.DOW_UNCHECKED);
        week_dow_4.setValue(ptn.charAt(6) == '1' ? ScheduleConst.DOW_CHECKED : ScheduleConst.DOW_UNCHECKED);
        week_dow_5.setValue(ptn.charAt(7) == '1' ? ScheduleConst.DOW_CHECKED : ScheduleConst.DOW_UNCHECKED);
        week_dow_6.setValue(ptn.charAt(8) == '1' ? ScheduleConst.DOW_CHECKED : ScheduleConst.DOW_UNCHECKED);
        week_dow_7.setValue(ptn.charAt(9) == '1' ? ScheduleConst.DOW_CHECKED : ScheduleConst.DOW_UNCHECKED);
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_MONTHLY_DAY)) {
        // xxヶ月ごとの dd日に設定 CxxddL
        repeat_type.setValue(ScheduleConst.REPEAT_TYPE_MONTH);
        month_type.setValue(ScheduleConst.MONTH_TYPE_MD);
        md_month_interval.setValue(Integer.parseInt(ptn.substring(1, 3)));
        md_day.setValue(Integer.parseInt(ptn.substring(3, 5)));
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_MONTHLY_WEEK)) {
        // Xヶ月ごとの 第Y Z曜日に設定 ExxWyzN
        repeat_type.setValue(ScheduleConst.REPEAT_TYPE_MONTH);
        month_type.setValue(ScheduleConst.MONTH_TYPE_MW);
        mw_month_interval.setValue(Integer.parseInt(ptn.substring(1, 3)));
        mw_count.setValue(ptn.substring(4, 5));
        mw_dow.setValue(ptn.substring(5, 6));
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_YEARLY_DAY)) {
        // X月Y日に設定 FmmddN
        repeat_type.setValue(ScheduleConst.REPEAT_TYPE_YEAR);
        year_type.setValue(ScheduleConst.YEAR_TYPE_MD);
        ymd_month.setValue(Integer.parseInt(ptn.substring(1, 3)));
        ymd_day.setValue(Integer.parseInt(ptn.substring(3, 5)));
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_YEARLY_WEEK)) {
        // mm月第y z曜日に設定定 GmmWyzL
        repeat_type.setValue(ScheduleConst.REPEAT_TYPE_YEAR);
        year_type.setValue(ScheduleConst.YEAR_TYPE_MW);
        ymw_month.setValue(Integer.parseInt(ptn.substring(1, 3)));
        ymw_count.setValue(Integer.parseInt(ptn.substring(4, 5)));
        ymw_dow.setValue(ptn.substring(5, 6));
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_DAYS)) {
        // 日またぎ
        is_span = false;
        is_repeat = false;
        is_straddle = true;
        // add end
      } else if (ptn.charAt(0) == 'S') {
        // 期間
        is_span = true;
        is_repeat = false;
      } else {
        // 単発
        is_repeat = false;
      }

      // 繰り返し予定の開始日時・終了日時
      if (is_repeat) {
        // 開始日時
        Calendar tmpViewCal = Calendar.getInstance();
        tmpViewCal.setTime(view_date.getValue());
        Calendar tmpStartCal = Calendar.getInstance();
        tmpStartCal.setTime(record.getStartDate());
        tmpViewCal.set(Calendar.HOUR_OF_DAY, tmpStartCal.get(Calendar.HOUR_OF_DAY));
        tmpViewCal.set(Calendar.MINUTE, tmpStartCal.get(Calendar.MINUTE));
        start_date.setValue(tmpViewCal.getTime());
        // 終了日時
        Calendar tmpStopCal = Calendar.getInstance();
        tmpStopCal.setTime(record.getEndDate());
        tmpViewCal.set(Calendar.HOUR_OF_DAY, tmpStopCal.get(Calendar.HOUR_OF_DAY));
        tmpViewCal.set(Calendar.MINUTE, tmpStopCal.get(Calendar.MINUTE));
        end_date.setValue(tmpViewCal.getTime());

        // change start
        // 有効期限の設定
        // if (ptn.charAt(count) == 'N') {
        // limit_start_date.setValue(view_date.getValue());
        // limit_end_date.setValue(view_date.getValue());
        // limit_flag.setValue("OFF");
        // } else {
        // limit_flag.setValue("ON");
        // limit_start_date.setValue(record.getStartDate());
        // limit_end_date.setValue(record.getEndDate());
        // }
        // 有効期限開始日
        limit_start_date.setValue(record.getStartDate());
        // 有効期限終了日
        limit_end_date.setValue(record.getEndDate());
        // 有効期限終了パターンの設定
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String chkDate = df.format(record.getEndDate());
        if (ScheduleConst.SCHEDULE_LIMIT_ENDDATE_NONEND.equals(chkDate)) {
          // 終了日が最大値の場合、終了日なし
          limit_type.setValue(ScheduleConst.LIMIT_TYPE_NONEND);
          // 表示上の終了日に開始日を設定
          limit_end_date.setValue(record.getStartDate());
        } else if (null != record.getRepeatNum()) {
          // 繰り返し回数データが有る場合、反復回数
          limit_type.setValue(ScheduleConst.LIMIT_TYPE_NOFT);
          repeat_num.setValue(record.getRepeatNum().longValue());
          // 表示上の終了日に開始日を設定
          limit_end_date.setValue(record.getStartDate());
        } else {
          // 上記以外の場合、終了日
          limit_type.setValue(ScheduleConst.LIMIT_TYPE_DATE);
        }
        // change end

        // 繰り返しスケジュールの編集フラグ
        edit_repeat_flag.setValue(FLAG_EDIT_REPEAT_ALL);
      }

      // 期間予定の開始日時・終了日時
      if (is_span) {
        // 開始日時
        start_date.setValue(record.getStartDate());
        // 終了日時
        end_date.setValue(record.getEndDate());

        limit_start_date.setValue(record.getStartDate());
        limit_end_date.setValue(record.getEndDate());

        if (record.getStartDate().equals(record.getEndDate())) {
          // 終日予定
          all_day_flag.setValue("ON");
        }
      }

      // 単発・日またぎ予定の開始日時・終了日時
      if (!is_repeat && !is_span) {
        // 開始日時
        start_date.setValue(record.getStartDate());
        // 終了日時
        end_date.setValue(record.getEndDate());

        limit_start_date.setValue(record.getStartDate());
        limit_end_date.setValue(record.getEndDate());
      }

      // 開始日と終了日が同じ場合、is_same_dateを真にする
      if (start_date.toString().equals(end_date.toString())) {
        is_same_date = true;
      } else {
        is_same_date = false;
      }

      // このスケジュールを共有しているメンバーを取得
      // change start
      // ユーザー表示順にスケジュールマップを取得
      List<EipTScheduleMap> scheduleMaps = ScheduleUtils.getEipTScheduleMapsByUserInfoSort(record.getScheduleId());
      // SelectQuery<EipTScheduleMap> mapquery =
      // Database.query(EipTScheduleMap.class);
      // Expression mapexp =
      // ExpressionFactory.matchExp(EipTScheduleMap.SCHEDULE_ID_PROPERTY, record
      // .getScheduleId());
      // mapquery.setQualifier(mapexp);
      // List<EipTScheduleMap> scheduleMaps = mapquery.fetchList();
      // change end

      // change start
      // 必須/任意メンバー対応
      // List<Integer> userIds = new ArrayList<Integer>();
      List<Integer> facilityIds = new ArrayList<Integer>();
      for (EipTScheduleMap map : scheduleMaps) {
        if (ScheduleUtils.SCHEDULEMAP_TYPE_USER.equals(map.getType())) {
          // userIds.add(map.getUserId());
          EipTCommonCategory category = map.getEipTCommonCategory();
          if (category == null) {
            common_category_id.setValue(1);
          } else {
            common_category_id.setValue(category.getCommonCategoryId().longValue());
          }
          ALEipUser user = ALEipUtils.getALEipUser(map.getUserId());
          if (ScheduleConst.SCHEDULEMAP_REQUIRED_T.equals(map.getRequired())) {
            reqMemberList.add(user);
          } else {
            subMemberList.add(user);
          }
          memberList.add(user);
        } else {
          facilityIds.add(map.getUserId());
        }
      }
      // change end

      // remove start
      // 冗長な処理のため削除
      // if (userIds.size() > 0) {
      // SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
      // Expression exp =
      // ExpressionFactory.inDbExp(TurbineUser.USER_ID_PK_COLUMN, userIds);
      // query.setQualifier(exp);
      // memberList.addAll(ALEipUtils.getUsersFromSelectQuery(query));
      // } else {
      // memberList.add(login_user);
      // }
      // remove start

      if (facilityIds.size() > 0) {
        SelectQuery<EipMFacility> fquery = Database.query(EipMFacility.class);
        Expression fexp = ExpressionFactory.inDbExp(EipMFacility.FACILITY_ID_PK_COLUMN, facilityIds);
        fquery.setQualifier(fexp);
        facilityList.addAll(FacilitiesUtils.getFacilitiesFromSelectQuery(fquery));
      }

      // add start 要件No.18 会議案内ファイル添付
      // ファイル
      SelectQuery<AvzTScheduleFile> query = Database.query(AvzTScheduleFile.class);
      query.andQualifier(ExpressionFactory.matchDbExp(AvzTScheduleFile.TO_EIP_TSCHEDULE_PROPERTY, record.getScheduleId()));
      List<AvzTScheduleFile> fileList = query.fetchList();

      boolean isNewFile = false;
      if (is_copy || is_repeat) {
        // remove start 要件No.11 メール作成／詳細（ファイル添付）
        // if (folderName == null || "".equals(folderName)) {
        // folderName = "0_" + String.valueOf(System.nanoTime());
        // }
        // remove end
        isNewFile = true;
      }
      // add start 要件No.11 メール作成／詳細（ファイル添付）
      // 一時フォルダ名を作成
      if (folderName == null || "".equals(folderName)) {
        folderName = "0_" + String.valueOf(System.nanoTime());
      }
      // add end
      for (AvzTScheduleFile file : fileList) {

        // 元メールの登録済みのファイルを、一時ファイル置き場にコピーします。
        String org_file_path = ScheduleUtils.getSaveDirPath(Database.getDomainName(), file.getOwnerId().intValue()) + file.getFilePath();
        // System.out.println("★★ファイル移行元" + org_file_path);

        if (is_copy || is_repeat) {
          // コピー登録の場合
          File saveFolder =
            new File(ScheduleUtils.getRootFolder(Database.getDomainName(), (int) loginUser.getUserId().getValue()) + File.separator + folderName);
          if (!saveFolder.exists()) {
            saveFolder.mkdirs();
          }

          String dest_file_path = saveFolder + File.separator + file.getFileId();
          // System.out.println("★★ファイル移行先" + dest_file_path);

          ScheduleUtils.copyFile(new File(org_file_path), new File(dest_file_path));

          // 一時添付ファイル名の保存("1.txt"など)
          ScheduleUtils.createTempNameFile(dest_file_path, file);

        }

        String nameWithSize = file.getFileName() + FileuploadUtils.getDispFileSize((int) (new File(org_file_path).length()));

        FileuploadLiteBean fbean = new FileuploadLiteBean();
        fbean.initField();
        fbean.setFileId(file.getFileId());
        fbean.setFileName(nameWithSize);
        fbean.setFlagNewFile(isNewFile);
        fileuploadList.add(fbean);
      }
      // add end
    } catch (Exception e) {
      // change start
      // logger.error("[ScheduleFormData]", e);
      // throw new ALDBErrorException();
      logger.error("スケジュール作成(編集)画面の表示に失敗しました。ログインユーザー:" + loginUser.getName().getValue(), e);
      msgList.add("スケジュール作成（編集）画面の表示に失敗しました。");
      return false;
      // change end

    }
    return true;
  }

  // add start
  /**
   * 入力値DB項目変換処理[AIPO_COM_PC_001_53]
   * 
   * @param schedule
   *          変換先スケジュールエンティティ
   * @throws ALPageNotFoundException
   *           有効期限の日付変換に失敗した場合
   */
  private void convertInputParamToSchedule(EipTSchedule schedule) throws ALPageNotFoundException {

    // 予定
    schedule.setName(name.getValue());
    // 場所
    schedule.setPlace(place.getValue());
    // 内容
    schedule.setNote(note.getValue());
    // 公開フラグ
    schedule.setPublicFlag(public_flag.getValue());
    // 共有メンバーによる編集／削除フラグ
    // 不可固定
    schedule.setEditFlag("F");

    // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
    // 仮予定フラグ
    if (is_temporary) {
      schedule.setTemporaryFlag("T");
    } else {
      schedule.setTemporaryFlag("F");
    }
    // add end

    // 日時パターン別項目
    if (is_span) {
      // 期間予定
      schedule.setStartDate(start_date.getValue());
      schedule.setEndDate(end_date.getValue());
      schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_SPAN);
    } else if (is_straddle) {
      // 日またぎ予定
      schedule.setStartDate(start_date.getValue());
      schedule.setEndDate(end_date.getValue());
      schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_DAYS);
    } else if (!is_repeat) {
      // 単発予定
      schedule.setStartDate(start_date.getValue());
      schedule.setEndDate(end_date.getValue());
      schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_ONEDAY);
    } else {
      // 繰り返し予定

      try {

        // 終了日未定値
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        Date lastDate = df.parse(ScheduleConst.SCHEDULE_LIMIT_ENDDATE_NONEND);

        // 有効期限開始日時
        ALDateContainer container = limit_start_date.getValue();
        Calendar limitStartCal = Calendar.getInstance();
        // 開始時刻を設定
        limitStartCal.setTime(start_date.getValue());
        // 開始年月日を設定
        limitStartCal.set(Calendar.YEAR, container.getYear());
        limitStartCal.set(Calendar.MONTH, container.getMonth() - 1);
        limitStartCal.set(Calendar.DATE, container.getDay());
        schedule.setStartDate(limitStartCal.getTime());

        // 反復回数終了日
        Calendar nOfTEndCal = Calendar.getInstance();
        // 初期値に有効期限開始日を設定する
        nOfTEndCal.set(Calendar.YEAR, container.getYear());
        nOfTEndCal.set(Calendar.MONTH, container.getMonth() - 1);
        nOfTEndCal.set(Calendar.DATE, container.getDay());
        nOfTEndCal.set(Calendar.HOUR_OF_DAY, 0);
        nOfTEndCal.set(Calendar.MINUTE, 0);
        nOfTEndCal.set(Calendar.SECOND, 0);
        nOfTEndCal.set(Calendar.MILLISECOND, 0);

        // 繰り返しパターン設定
        if (ScheduleConst.REPEAT_TYPE_DAY.equals(repeat_type.getValue())) {

          // 日パターン
          String pattern = "000" + day_interval.getValueAsString();
          schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_DAILY
            + pattern.substring(pattern.length() - 3, pattern.length())
            + ScheduleConst.SCHEDULE_PATTERN_TERMINATION);

          // 有効期限終了パターンが反復回数の場合、日ベースで終了日を算出する
          if (ScheduleConst.LIMIT_TYPE_NOFT.equals(limit_type.getValue())) {
            // 反復回数 - 1回分、日間隔を加算する
            for (long i = 1L; i < repeat_num.getValue(); i++) {
              nOfTEndCal.add(Calendar.DAY_OF_MONTH, (int) day_interval.getValue());
            }
          }

        } else if (ScheduleConst.REPEAT_TYPE_WEEK.equals(repeat_type.getValue())) {

          // 週パターン
          String pattern = "00" + week_interval.getValueAsString();
          String dowFlag = "";
          for (String status : getCheckedWeekDoW()) {
            dowFlag += ScheduleConst.DOW_CHECKED.equals(status) ? "1" : "0";
          }
          schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_WEEKLY
            + pattern.substring(pattern.length() - 2, pattern.length())
            + dowFlag
            + ScheduleConst.SCHEDULE_PATTERN_TERMINATION);
          // add start 強化テスト 12.16
          // 日付再計算
          nOfTEndCal.getTime().getTime();
          // add end
          // 有効期限終了パターンが反復回数の場合、週ベースで終了日を算出する
          if (ScheduleConst.LIMIT_TYPE_NOFT.equals(limit_type.getValue())) {
            // 週初日を仮指定
            nOfTEndCal.set(Calendar.DAY_OF_WEEK, 1);

            // 反復回数 - 1回分、週間隔を加算する
            for (long i = 1L; i < repeat_num.getValue(); i++) {
              nOfTEndCal.add(Calendar.WEEK_OF_MONTH, (int) week_interval.getValue());
            }

            // 週末日を指定する
            nOfTEndCal.set(Calendar.DAY_OF_WEEK, nOfTEndCal.getActualMaximum(Calendar.DAY_OF_WEEK));
            // add start 強化テスト 12.16
            // 日付再計算
            nOfTEndCal.getTime().getTime();
            // add end
          }

        } else if (ScheduleConst.REPEAT_TYPE_MONTH.equals(repeat_type.getValue())) {

          int monthInterval = 0;

          // 月パターン
          if (ScheduleConst.MONTH_TYPE_MD.equals(month_type.getValue())) {

            // xヶ月ごとの dd日に設定 CxxddL
            String pattern1 = "00" + md_month_interval.getValueAsString();
            String pattern2 = "00" + md_day.getValueAsString();
            schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_MONTHLY_DAY
              + pattern1.substring(pattern1.length() - 2, pattern1.length())
              + pattern2.substring(pattern2.length() - 2, pattern2.length())
              + ScheduleConst.SCHEDULE_PATTERN_TERMINATION);

            monthInterval = (int) md_month_interval.getValue();

          } else if (ScheduleConst.MONTH_TYPE_MW.equals(month_type.getValue())) {

            // Xヶ月ごとの 第Y Z曜日に設定 ExxWyzN
            String pattern = "00" + mw_month_interval.getValueAsString();
            schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_MONTHLY_WEEK
              + pattern.substring(pattern.length() - 2, pattern.length())
              + "W"
              + mw_count.getValueAsString()
              + mw_dow.getValue()
              + ScheduleConst.SCHEDULE_PATTERN_TERMINATION);

            monthInterval = (int) mw_month_interval.getValue();

          }

          // 有効期限終了パターンが反復回数の場合、月ベースで終了日を算出する
          if (ScheduleConst.LIMIT_TYPE_NOFT.equals(limit_type.getValue())) {
            // 月初日を仮指定
            nOfTEndCal.set(Calendar.DAY_OF_MONTH, 1);
            // 反復回数 - 1回分、月間隔を加算する
            for (long i = 1L; i < repeat_num.getValue(); i++) {
              nOfTEndCal.add(Calendar.MONTH, monthInterval);
            }
            // 月末日を指定する
            nOfTEndCal.set(Calendar.DAY_OF_MONTH, nOfTEndCal.getActualMaximum(Calendar.DAY_OF_MONTH));
          }

        } else if (ScheduleConst.REPEAT_TYPE_YEAR.equals(repeat_type.getValue())) {

          if (ScheduleConst.YEAR_TYPE_MD.equals(year_type.getValue())) {

            // X月Y日に設定 FmmddL
            String pattern1 = "00" + ymd_month.getValueAsString();
            String pattern2 = "00" + ymd_day.getValueAsString();
            schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_YEARLY_DAY
              + pattern1.substring(pattern1.length() - 2, pattern1.length())
              + pattern2.substring(pattern2.length() - 2, pattern2.length())
              + ScheduleConst.SCHEDULE_PATTERN_TERMINATION);

          } else if (ScheduleConst.YEAR_TYPE_MW.equals(year_type.getValue())) {

            // X月第Y Z曜日に設定 GmmWyzL
            String pattern = "00" + ymw_month.getValueAsString();
            schedule.setRepeatPattern(ScheduleConst.SCHEDULE_PATTERN_YEARLY_WEEK
              + pattern.substring(pattern.length() - 2, pattern.length())
              + "W"
              + ymw_count.getValueAsString()
              + ymw_dow.getValue()
              + ScheduleConst.SCHEDULE_PATTERN_TERMINATION);

          }

          // 有効期限終了パターンが反復回数の場合、年ベースで終了日を算出する
          if (ScheduleConst.LIMIT_TYPE_NOFT.equals(limit_type.getValue())) {
            // 反復回数 - 1回の年数を加算
            nOfTEndCal.add(Calendar.YEAR, (int) (repeat_num.getValue() - 1L));
            // 年末日を設定
            nOfTEndCal.set(Calendar.DAY_OF_YEAR, nOfTEndCal.getActualMaximum(Calendar.DAY_OF_YEAR));
          }

        }

        // 有効期限終了日時
        Calendar limitEndCal = Calendar.getInstance();

        // 終了時刻を設定
        limitEndCal.setTime(end_date.getValue());
        Calendar limitEndYmdCal = Calendar.getInstance();
        if (ScheduleConst.LIMIT_TYPE_NONEND.equals(limit_type.getValue())) {

          // 終了日なし
          limitEndYmdCal.setTime(lastDate);
          schedule.setRepeatNum(null);

        } else if (ScheduleConst.LIMIT_TYPE_NOFT.equals(limit_type.getValue())) {

          // 反復回数
          if (lastDate.before(nOfTEndCal.getTime())) {
            // 反復回数の計算結果が終了日未定日付を超えた場合は、終了日未定日付を設定する
            limitEndYmdCal.setTime(lastDate);
          } else {
            limitEndYmdCal.setTime(nOfTEndCal.getTime());
          }
          schedule.setRepeatNum((int) repeat_num.getValue());

        } else if (ScheduleConst.LIMIT_TYPE_DATE.equals(limit_type.getValue())) {

          // 終了日
          ALDateContainer endYmdContainer = limit_end_date.getValue();
          limitEndYmdCal.setTime(endYmdContainer.getDate());
          schedule.setRepeatNum(null);

        }
        limitEndCal.set(Calendar.YEAR, limitEndYmdCal.get(Calendar.YEAR));
        limitEndCal.set(Calendar.MONTH, limitEndYmdCal.get(Calendar.MONTH));
        limitEndCal.set(Calendar.DATE, limitEndYmdCal.get(Calendar.DATE));
        schedule.setEndDate(limitEndCal.getTime());

      } catch (Exception e) {
        // カレンダーウィジットで登録するため、不正日付は想定外
        String limitStartDateStr = "";
        String limitEndDateStr = "";
        if (null != limit_start_date) {
          limitStartDateStr = limit_start_date.toString();
        }
        if (null != limit_end_date) {
          limitEndDateStr = limit_end_date.toString();
        }
        logger.error(
          "繰り返し期間の日付変換でエラーが発生しました。ログインユーザー:" + loginUser.getName().toString() + "/繰り返し期間開始日:" + limitStartDateStr + "/繰り返し期間終了日:" + limitEndDateStr,
          e);
        throw new ALPageNotFoundException();
      }
    }
  }

  // add end

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(RunData,
   * context, List<String>)
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    EipTSchedule schedule = null;
    // add start 要件No.18 会議案内ファイル添付
    List<String> delFilePathList = new ArrayList<String>();
    Map<String, String> newFilesMap = new HashMap<String, String>();
    // add end
    try {
      // remove start
      // // 施設のアクセスコントロールのチェック
      // int f_size = facilityList.size();
      // if (!facilityCheckAclPermission(
      // rundata,
      // ALAccessControlConstants.VALUE_ACL_INSERT)
      // && f_size > 0) {
      // msgList.add(" 施設を予約する権限がありません ");
      // return false;
      // }
      // remove end

      // Validate のときに SELECT していることに注意する

      // remove start
      // setFormDataで同様の処理を行っているため、削除
      // if (is_span) {
      // Calendar startDate = Calendar.getInstance();
      // startDate.setTime(start_date.getValue());
      // startDate.set(Calendar.HOUR_OF_DAY, 0);
      // startDate.set(Calendar.MINUTE, 0);
      //
      // Calendar endDate = Calendar.getInstance();
      // endDate.setTime(end_date.getValue());
      // endDate.set(Calendar.HOUR_OF_DAY, 0);
      // endDate.set(Calendar.MINUTE, 0);
      //
      // start_date.setValue(startDate.getTime());
      // end_date.setValue(endDate.getTime());
      // } else {
      // Calendar startcal = new GregorianCalendar();
      // startcal.setTime(start_date.getValue());
      // Calendar endcal = Calendar.getInstance();
      // endcal.setTime(end_date.getValue());
      // endcal.set(Calendar.YEAR, startcal.get(Calendar.YEAR));
      // endcal.set(Calendar.MONTH, startcal.get(Calendar.MONTH));
      // endcal.set(Calendar.DATE, startcal.get(Calendar.DATE));
      // end_date.setValue(endcal.getTime());
      // }
      // remove end

      // オーナーID
      // change start
      // 対象者をオーナーとする
      // int ownerid = ALEipUtils.getUserId(rundata);
      int ownerid = (int) currentUser.getUserId().getValue();
      // change end

      // 新規オブジェクトモデル
      schedule = Database.create(EipTSchedule.class);

      // add start
      // 入力値をDB項目へ変換
      convertInputParamToSchedule(schedule);
      // add end

      // 親スケジュール ID
      schedule.setParentId(Integer.valueOf(0));

      // remove start
      // // 予定
      // schedule.setName(name.getValue());
      // // 場所
      // schedule.setPlace(place.getValue());
      // // 内容
      // schedule.setNote(note.getValue());
      // // 公開フラグ
      // schedule.setPublicFlag(public_flag.getValue());
      // // 共有メンバーによる編集／削除フラグ
      // if (memberList.size() >= 1) {
      // schedule.setEditFlag(edit_flag.getValue());
      // } else {
      // schedule.setEditFlag("F");
      // }
      // remove end

      // オーナーID
      schedule.setOwnerId(Integer.valueOf(ownerid));

      // 作成日
      Date now = new Date();
      schedule.setCreateDate(now);
      // change start
      // ログインユーザーIDを設定する
      // schedule.setCreateUserId(Integer.valueOf(ownerid));
      schedule.setCreateUserId((int) loginUser.getUserId().getValue());
      // change end
      // 更新日
      schedule.setUpdateDate(now);
      // change start
      // ログインユーザーIDを設定する
      // schedule.setUpdateUserId(Integer.valueOf(ownerid));
      schedule.setUpdateUserId(Integer.valueOf((int) loginUser.getUserId().getValue()));
      // change end

      // remove start
      // 設定処理を共通メソッドに移管
      // if (is_span) {
      // // 期間スケジュール設定の場合
      // schedule.setEndDate(end_date.getValue());
      // schedule.setRepeatPattern("S");
      //
      // schedule.setStartDate(start_date.getValue());
      // } else if (!is_repeat) {
      // // 終了日時
      // schedule.setEndDate(end_date.getValue());
      // schedule.setRepeatPattern("N");
      //
      // schedule.setStartDate(start_date.getValue());
      // } else {
      // // 繰り返しスケジュール設定の場合
      // char lim = 'N';
      // Calendar cal = Calendar.getInstance();
      // cal.setTime(end_date.getValue());
      // if ("ON".equals(limit_flag.getValue())) {
      // lim = 'L';
      // cal.set(limit_end_date.getValue().getYear(), limit_end_date
      // .getValue()
      // .getMonth() - 1, limit_end_date.getValue().getDay());
      //
      // ALDateContainer container = limit_start_date.getValue();
      // Calendar limitStartCal = Calendar.getInstance();
      // limitStartCal.setTime(start_date.getValue());
      // limitStartCal.set(Calendar.YEAR, container.getYear());
      // limitStartCal.set(Calendar.MONTH, container.getMonth() - 1);
      // limitStartCal.set(Calendar.DATE, container.getDay());
      // schedule.setStartDate(limitStartCal.getTime());
      // } else {
      // schedule.setStartDate(start_date.getValue());
      // }
      //
      // schedule.setEndDate(cal.getTime());
      // if ("D".equals(repeat_type.getValue())) {
      // schedule.setRepeatPattern(new StringBuffer()
      // .append('D')
      // .append(lim)
      // .toString());
      // } else if ("W".equals(repeat_type.getValue())) {
      // schedule.setRepeatPattern(new StringBuffer().append('W').append(
      // week_0.getValue() != null ? 1 : 0).append(
      // week_1.getValue() != null ? 1 : 0).append(
      // week_2.getValue() != null ? 1 : 0).append(
      // week_3.getValue() != null ? 1 : 0).append(
      // week_4.getValue() != null ? 1 : 0).append(
      // week_5.getValue() != null ? 1 : 0).append(
      // week_6.getValue() != null ? 1 : 0).append(lim).toString());
      // } else {
      // DecimalFormat format = new DecimalFormat("00");
      // schedule.setRepeatPattern(new StringBuffer().append('M').append(
      // format.format(month_day.getValue())).append(lim).toString());
      // }
      // }
      // remove end

      EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory(Long.valueOf(1));

      // 2007.3.28 ToDo連携
      // // スケジュールを登録
      // orm.doInsert(schedule);

      // change start
      // 必須・任意メンバー対応
      // for (ALEipUser user : memberList) {
      // EipTScheduleMap map = Database.create(EipTScheduleMap.class);
      // int userid = (int) user.getUserId().getValue();
      //
      // map.setEipTSchedule(schedule);
      // map.setUserId(Integer.valueOf(userid));
      // // O: 自スケジュール T: 仮スケジュール C: 確定スケジュール
      // if (userid == ALEipUtils.getUserId(rundata)) {
      // map.setStatus("O");
      // } else {
      // map.setStatus("T");
      // }
      // EipTCommonCategory category =
      // CommonCategoryUtils.getEipTCommonCategory(common_category_id
      // .getValue());
      // if (category == null) {
      // map.setCommonCategoryId(Integer.valueOf(1));
      // map.setEipTSchedule(schedule);
      // map.setEipTCommonCategory(category1);
      // } else {
      // map.setCommonCategoryId(Integer.valueOf((int) (common_category_id
      // .getValue())));
      // map.setEipTSchedule(schedule);
      // map.setEipTCommonCategory(category);
      // }
      // map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_USER);
      // }
      // change end

      // remove start
      // 施設廃止
      // グループに施設を追加する．（公開スケジュールのみ）
      // if ("O".equals(public_flag.toString()) && !(is_span)) {
      // for (Object record : facilityList) {
      // FacilityResultData frd = (FacilityResultData) record;
      //
      // EipTScheduleMap map = Database.create(EipTScheduleMap.class);
      // int facilityid = (int) frd.getFacilityId().getValue();
      //
      // map.setEipTSchedule(schedule);
      // map.setUserId(Integer.valueOf(facilityid));
      // // O: 自スケジュール T: 仮スケジュール C: 確定スケジュール
      // map.setStatus("O");
      // map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY);
      // map.setEipTCommonCategory(category1);
      // map.setCommonCategoryId(Integer.valueOf(1));
      // }
      // }
      //
      // /* 施設重複判定 */
      // if (!ignore_duplicate_facility) {
      // if (facilityList.size() > 0) {
      // ArrayList<Integer> facilityIds = new ArrayList<Integer>();
      //
      // for (Object record : facilityList) {
      // FacilityResultData frd = (FacilityResultData) record;
      // facilityIds.add(Integer.valueOf((int) frd
      // .getFacilityId()
      // .getValue()));
      // }
      //
      // if (ScheduleUtils.isDuplicateFacilitySchedule(
      // schedule,
      // facilityIds,
      // null,
      // null)) {
      // if (msgList.size() == 0) {
      // msgList.add("duplicate_facility");
      // }
      // Database.rollback();
      // return false;
      // }
      // }
      // }
      // remove end
      // 必須メンバーを登録
      createScheduleMapForNewSchedule(reqMemberList, ScheduleConst.SCHEDULEMAP_REQUIRED_T, schedule, category1, ownerid);
      // 任意メンバーを登録
      createScheduleMapForNewSchedule(subMemberList, ScheduleConst.SCHEDULEMAP_REQUIRED_F, schedule, category1, ownerid);

      // add start 要件No.18 会議案内ファイル添付
      // 添付ファイル情報をデータベースに登録する．
      ScheduleUtils.insertFileDataDelegate(rundata, context, schedule, fileuploadList, folderName, delFilePathList, newFilesMap, msgList);
      // add end
      // add start 要件No.18 会議案内ファイル添付
      // 添付ファイルを一時ディレクトリからストアディレクトリにコピーする．
      ScheduleUtils.syncFile(folderName, (int) loginUser.getUserId().getValue(), ownerid, delFilePathList, newFilesMap, msgList);
      // add end

      // スケジュールを登録
      Database.commit();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId(), ALEventlogConstants.PORTLET_TYPE_SCHEDULE, schedule.getName());

      // アクティビティ
      String loginName = loginUser.getName().getValue();
      List<String> recipients = new ArrayList<String>();
      for (ALEipUser user : memberList) {
        if (loginUser.getUserId().getValue() != user.getUserId().getValue()) {
          recipients.add(user.getName().getValue());
        }
      }
      ScheduleUtils.createShareScheduleActivity(schedule, loginName, recipients, true);

    } catch (Exception e) {
      // add start 要件No.18 会議案内ファイル添付
      // ストアディレクトリに作成したファイルを削除する。
      ScheduleUtils.rollbackFiles((int) currentUser.getUserId().getValue(), newFilesMap);
      // add end
      Database.rollback();
      // change start
      // logger.error("[ScheduleFormData]", e);
      // throw new ALDBErrorException();
      logger.error("スケジュールの新規追加に失敗しました。ログインユーザー:" + loginUser.getName().getValue(), e);
      msgList.add("スケジュールの新規追加に失敗しました。");
      return false;
      // change end
    }

    // change start
    // スケジュールメール送信処理共通化
    // try {
    // // メール送信
    // int msgType =
    // ALMailUtils.getSendDestType(ALMailUtils.KEY_MSGTYPE_SCHEDULE);
    // if (msgType > 0) {
    // // パソコンへメールを送信
    // List<ALEipUserAddr> destMemberList =
    // ALMailUtils.getALEipUserAddrs(memberList, ALEipUtils
    // .getUserId(rundata), false);
    // String subject = "[" + ALOrgUtilsService.getAlias() + "]スケジュール";
    // String orgId = Database.getDomainName();
    //
    // List<ALAdminMailMessage> messageList =
    // new ArrayList<ALAdminMailMessage>();
    // for (ALEipUserAddr destMember : destMemberList) {
    // ALAdminMailMessage message = new ALAdminMailMessage(destMember);
    // message.setPcSubject(subject);
    // message.setCellularSubject(subject);
    // message.setPcBody(ScheduleUtils.createMsgForPc(
    // rundata,
    // schedule,
    // memberList));
    // message.setCellularBody(ScheduleUtils.createMsgForCellPhone(
    // rundata,
    // schedule,
    // memberList,
    // destMember.getUserId()));
    // messageList.add(message);
    // }
    //
    // ALMailService.sendAdminMail(new ALAdminMailContext(orgId, ALEipUtils
    // .getUserId(rundata), messageList, ALMailUtils
    // .getSendDestType(ALMailUtils.KEY_MSGTYPE_SCHEDULE)));
    // // msgList.addAll(errors);
    //
    // }
    // } catch (Exception ex) {
    // msgList.add("メールを送信できませんでした。");
    // logger.error("Exception", ex);
    // return false;
    // }
    // -----------------
    // メール送信処理
    // -----------------
    // メール送信先
    // 参加メンバー（ログインユーザーを除く）を送信先にする
    List<ALEipUserAddr> sendToUserList = ALMailUtils.getALEipUserAddrs(memberList, ALEipUtils.getUserId(rundata), false);
    // メール送信実行
    if (!ScheduleUtils.sendScheduleMail(sendToUserList, schedule.getOwnerId(), schedule, reqMemberList, subMemberList,
    // change start 要件No.1 スケジュール案内受信
      // "予定作成",
      ScheduleUtils.MEETING_CREATE,
      // change end
      "作成しました。",
      rundata,
      // add start 要件No.1 スケジュール案内受信
      "",
      ScheduleUtils.CREATE_MSG_MODE_REQ
    // add end
      )) {
      msgList.add("mailErrMsg=メールを送信できませんでした。entityId=" + schedule.getScheduleId());
      return false;
    }

    if (schedule.getOwnerId().intValue() != (int) loginUser.getUserId().getValue()) {

      // 秘書設定元へ代理操作の通知を行なう。

      // メール送信先(ALEipUser)秘書設定元送信用
      List<ALEipUser> sendToEipClientUserList = new ArrayList<ALEipUser>(0);

      sendToEipClientUserList.add(ALEipUtils.getALEipUser(schedule.getOwnerId().intValue()));

      List<ALEipUserAddr> sendToClientUserList = ALMailUtils.getALEipUserAddrs(sendToEipClientUserList, (int) loginUser.getUserId().getValue(), false);

      if (!ScheduleUtils.sendScheduleMail(
        sendToClientUserList,
        (int) loginUser.getUserId().getValue(),
        schedule.getOwnerId(),
        schedule,
        reqMemberList,
        subMemberList,
        // change start 要件No.1 スケジュール案内受信
        // "代理予定作成通知",
        ScheduleUtils.SUBSTITUTE_CREATE,
        // change end
        "作成しました。",
        rundata,
        // add start 要件No.1 スケジュール案内受信
        "",
        ScheduleUtils.CREATE_MSG_MODE_SUBREQ
      // add end
        )) {
        msgList.add("mailErrMsg=メールを送信できませんでした。entityId=" + schedule.getScheduleId());
        return false;
      }
    }
    // change end

    return true;
  }

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(RunData,
   * context, List<String>)
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    ArrayList<ALEipUser> newmemberList = new ArrayList<ALEipUser>();
    EipTSchedule schedule = null;
    EipTSchedule newSchedule = null;
    EipTSchedule tmpSchedule = null;

    // add start
    List<ALEipUser> removedMemberList = new ArrayList<ALEipUser>(0);
    boolean isSameSchedule = false;
    // add end

    // add start 要件No.18 会議案内ファイル添付
    List<String> delFilePathList = new ArrayList<String>();
    Map<String, String> newFilesMap = new HashMap<String, String>();
    // add end

    try {
      // Validate のときに SELECT していることに注意する

      // remove start
      // setFormDataで同様の処理を行っているため、削除
      // if (is_span) {
      // Calendar startDate = Calendar.getInstance();
      // startDate.setTime(start_date.getValue());
      // startDate.set(Calendar.HOUR_OF_DAY, 0);
      // startDate.set(Calendar.MINUTE, 0);
      //
      // Calendar endDate = Calendar.getInstance();
      // endDate.setTime(end_date.getValue());
      // endDate.set(Calendar.HOUR_OF_DAY, 0);
      // endDate.set(Calendar.MINUTE, 0);
      //
      // start_date.setValue(startDate.getTime());
      // end_date.setValue(endDate.getTime());
      // } else {
      // Calendar startcal = new GregorianCalendar();
      // startcal.setTime(start_date.getValue());
      // Calendar endcal = Calendar.getInstance();
      // endcal.setTime(end_date.getValue());
      // endcal.set(Calendar.YEAR, startcal.get(Calendar.YEAR));
      // endcal.set(Calendar.MONTH, startcal.get(Calendar.MONTH));
      // endcal.set(Calendar.DATE, startcal.get(Calendar.DATE));
      // end_date.setValue(endcal.getTime());
      // }
      // remove end

      // オブジェクトモデルを取得
      schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
      if (schedule == null) {
        return false;
      }
      tmpSchedule = schedule;
      // int ownerid = ALEipUtils.getUserId(rundata);
      int ownerid = schedule.getOwnerId();

      // remove start
      // 施設を使用しない
      // // 施設のアクセスコントロールのチェック
      // if (!facilityCheckAclPermission(
      // rundata,
      // ALAccessControlConstants.VALUE_ACL_UPDATE)) {
      // int[] old_ids = ScheduleUtils.getFacilityIds(schedule);
      // if (old_ids.length != facilityList.size()) {
      // msgList.add(" 施設を予約する権限がありません ");
      // return false;
      // }
      // boolean check = false;
      // for (int old_id : old_ids) {
      // for (Object record : facilityList) {
      // FacilityResultData frd = (FacilityResultData) record;
      // int facilityid = (int) frd.getFacilityId().getValue();
      // if (old_id == facilityid) {
      // check = true;
      // break;
      // }
      // }
      // if (!check) {
      // msgList.add(" 施設を予約する権限がありません ");
      // return false;
      // }
      // check = false;
      // }
      // }
      // remove end

      // スケジュールのアップデート権限を検証する．
      /*
       * if (ownerid != schedule.getOwnerId().intValue() &&
       * "F".equals(schedule.getEditFlag())) { // アップデート失敗時は、スケジュールの一覧を表示させる．
       * return true; }
       */

      // 新たに追加されたメンバーのリストを取得
      List<?> scheduleMapList = schedule.getEipTScheduleMaps();
      List<Integer> oldmemberIdList = new ArrayList<Integer>();
      for (Object record : scheduleMapList) {
        EipTScheduleMap map = (EipTScheduleMap) record;
        if (ScheduleUtils.SCHEDULEMAP_TYPE_USER.equals(map.getType())) {
          oldmemberIdList.add(map.getUserId());
        }
      }

      List<Integer> newmemberIdList = new ArrayList<Integer>();
      for (ALEipUser user : memberList) {
        int memberId = (int) user.getUserId().getValue();
        newmemberIdList.add(memberId);
        if (!isContains(oldmemberIdList, memberId)) {
          newmemberList.add(ALEipUtils.getALEipUser(memberId));
        }
      }

      // add by motegi 2011.12.01
      // 今回メンバーから除外されたユーザーリスト取得
      for (Integer id : oldmemberIdList) {
        if (!isContains(newmemberIdList, id)) {
          removedMemberList.add(ALEipUtils.getALEipUser(id));
        }
      }
      // add end
      // change start 2012.3.3 移行ツール改修に伴う共有カテゴリステータスの変更
      // EipTCommonCategory category1 =
      // CommonCategoryUtils.getEipTCommonCategory(Long.valueOf(1));
      EipTCommonCategory category1;
      EipTScheduleMap map;
      if (scheduleMapList.size() > 0) {
        try {
          map = (EipTScheduleMap) scheduleMapList.get(0);
          if (null != map) {
            category1 = CommonCategoryUtils.getEipTCommonCategory(Long.valueOf(map.getCommonCategoryId()));
          } else {
            category1 = CommonCategoryUtils.getEipTCommonCategory(Long.valueOf(1));
          }
        } catch (Exception ex) {
          logger.error("スケジュールマップから共有カテゴリIDの情報取得に失敗しました。", ex);
          category1 = CommonCategoryUtils.getEipTCommonCategory(Long.valueOf(1));
        }
      } else {
        category1 = CommonCategoryUtils.getEipTCommonCategory(Long.valueOf(1));
      }
      // change end 2012.3.3
      // 編集範囲フラグの状態別に新規追加/更新の分岐をする
      if (edit_repeat_flag.getValue() == FLAG_EDIT_REPEAT_ONE) {
        // --------------------------------
        // 繰り返し予定1日変更（新規追加）
        // --------------------------------
        // 繰り返しスケジュールの個別日程を変更する．
        // 新規オブジェクトモデル
        newSchedule = Database.create(EipTSchedule.class);

        // add start
        // 入力値をDB項目へ変換
        convertInputParamToSchedule(newSchedule);
        // add end

        // 繰り返しの親スケジュール ID
        newSchedule.setParentId(schedule.getScheduleId());

        // remove start
        // 設定処理を共通メソッドに移管
        // // 予定
        // newSchedule.setName(name.getValue());
        // // 場所
        // newSchedule.setPlace(place.getValue());
        // // 内容
        // newSchedule.setNote(note.getValue());
        // // 公開フラグ
        // newSchedule.setPublicFlag(public_flag.getValue());
        // // 共有メンバーによる編集／削除フラグ
        // newSchedule.setEditFlag("F");
        // newSchedule.setEditFlag(schedule.getEditFlag());
        // remove end
        // オーナーID
        newSchedule.setOwnerId(Integer.valueOf(ownerid));
        // 作成日
        Date now = new Date();
        newSchedule.setCreateDate(now);
        // change start
        // 作成者をログインユーザーに固定
        newSchedule.setCreateUserId(Integer.valueOf(ALEipUtils.getUserId(rundata)));
        // newSchedule.setCreateUserId(Integer.valueOf(ownerid));
        // change end
        // 更新日
        newSchedule.setUpdateDate(now);
        newSchedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId(rundata)));

        // remove start
        // 設定処理を共通メソッドに移管
        // // 終了日時
        // newSchedule.setEndDate(end_date.getValue());
        // newSchedule.setRepeatPattern("N");
        // newSchedule.setStartDate(start_date.getValue());
        // remove end

        // 2007.3.28 ToDo連携

        // change start
        // 必須・任意メンバー対応
        // int allsize = memberList.size() + facilityList.size();
        // if (allsize > 0) {
        // List<?> scheduleMaps = schedule.getEipTScheduleMaps();
        // for (ALEipUser user : memberList) {
        // EipTScheduleMap map = Database.create(EipTScheduleMap.class);
        // int userid = (int) user.getUserId().getValue();
        //
        // map.setEipTSchedule(newSchedule);
        // map.setUserId(Integer.valueOf(userid));
        //
        // if (userid == ownerid) {
        // map.setStatus("O");
        // } else {
        // if ("T".equals(change_tmpreserve_flag.getValue())) {
        // map.setStatus("T");
        // } else {
        // EipTScheduleMap tmpMap =
        // getScheduleMap(
        // scheduleMaps,
        // userid,
        // ScheduleUtils.SCHEDULEMAP_TYPE_USER);
        // if (tmpMap != null) {
        // map.setStatus(tmpMap.getStatus());
        // } else {
        // map.setStatus("T");
        // }
        // }
        // }
        // EipTCommonCategory category =
        // CommonCategoryUtils.getEipTCommonCategory(common_category_id
        // .getValue());
        // if (category == null) {
        // map.setCommonCategoryId(Integer.valueOf(1));
        // map.setEipTCommonCategory(category1);
        // } else {
        // map.setCommonCategoryId(Integer.valueOf((int) (common_category_id
        // .getValue())));
        // map.setEipTCommonCategory(category);
        // }
        // map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_USER);
        // }
        //
        // // グループに施設を追加する．（公開スケジュールのみ）
        // if ("O".equals(public_flag.toString()) && !(is_span)) {
        // for (Object record : facilityList) {
        // FacilityResultData frd = (FacilityResultData) record;
        // int facilityid = (int) frd.getFacilityId().getValue();
        //
        // EipTScheduleMap map = Database.create(EipTScheduleMap.class);
        // map.setEipTSchedule(newSchedule);
        // map.setUserId(Integer.valueOf(facilityid));
        // map.setStatus("O");
        // map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY);
        // map.setEipTCommonCategory(category1);
        // map.setCommonCategoryId(Integer.valueOf(1));
        // }
        // }
        // }
        //
        // // 登録されていたメンバーと今回追加されたメンバーのユーザー ID を取得する．
        // List<?> scheduleMaps = schedule.getEipTScheduleMaps();
        // List<Integer> memberIdList = new ArrayList<Integer>();
        // List<Integer> facilityIdList = new ArrayList<Integer>();
        // for (Object record : scheduleMaps) {
        // EipTScheduleMap map = (EipTScheduleMap) record;
        // if (ScheduleUtils.SCHEDULEMAP_TYPE_USER.equals(map.getType())) {
        // memberIdList.add(map.getUserId());
        // } else {
        // facilityIdList.add(map.getUserId());
        // }
        // }
        //
        // for (ALEipUser user : memberList) {
        // int memberId = (int) user.getUserId().getValue();
        // if (!isContains(memberIdList, memberId)) {
        // memberIdList.add(Integer.valueOf(memberId));
        // }
        // }
        // int memberIdListSize = memberIdList.size();
        // int[] memberIds = new int[memberIdListSize];
        // for (int i = 0; i < memberIdListSize; i++) {
        // memberIds[i] = memberIdList.get(i).intValue();
        // }
        //
        // for (Object record : facilityList) {
        // int facilityId =
        // (int) ((FacilityResultData) record).getFacilityId().getValue();
        // if (!isContains(facilityIdList, facilityId)) {
        // facilityList.add(Integer.valueOf(facilityId));
        // }
        // }
        // int facilityIdListSize = facilityIdList.size();
        // int[] facilityIds = new int[facilityIdListSize];
        // for (int i = 0; i < facilityIdListSize; i++) {
        // facilityIds[i] = facilityIdList.get(i).intValue();
        // }
        //
        // // 施設重複判定
        // if (!ignore_duplicate_facility) {
        // if (facilityIdList.size() > 0) {
        // if (ScheduleUtils.isDuplicateFacilitySchedule(
        // newSchedule,
        // facilityIdList,
        // schedule.getScheduleId(),
        // view_date.getValue())) {
        // if (msgList.size() == 0) {
        // msgList.add("duplicate_facility");
        // }
        // Database.rollback();
        // return false;
        // }
        // }
        // }

        // 必須メンバーを登録
        createScheduleMapForNewSchedule(reqMemberList, ScheduleConst.SCHEDULEMAP_REQUIRED_T, newSchedule, category1, ownerid);

        // 任意メンバーを登録
        createScheduleMapForNewSchedule(subMemberList, ScheduleConst.SCHEDULEMAP_REQUIRED_F, newSchedule, category1, ownerid);

        // ダミースケジュール作成用ユーザーID一覧を作成
        // change start TODO 運用フェーズ課題・障害台帳No.XXX
        // int[] memberIds = new int[memberList.size()];
        int[] memberIds = new int[oldmemberIdList.size()];
        // change end
        int[] facilityIds = new int[0];

        int index = 0;
        // change start TODO 運用フェーズ課題・障害台帳No.XXX
        // for (ALEipUser user : memberList) {
        // memberIds[index] = (int) user.getUserId().getValue();
        // index++;
        // }
        for (Integer userid : oldmemberIdList) {
          memberIds[index] = userid.intValue();
          index++;
        }
        // change end
        // change end

        // ダミーのスケジュールを登録する。
        // 内部でDatabase.commit()が呼び出されることに注意
        ScheduleUtils.insertDummySchedule(schedule, ownerid, view_date.getValue(), view_date.getValue(), memberIds, facilityIds);
        tmpSchedule = newSchedule;

        // add start 要件No.18 会議案内ファイル添付
        // 添付ファイル情報をデータベースに登録する．
        ScheduleUtils.insertFileDataDelegate(rundata, context, newSchedule, fileuploadList, folderName, delFilePathList, newFilesMap, msgList);
        // add end
      } else {
        // --------------------------------
        // 予定変更（更新）
        // --------------------------------
        // add start
        // 回答状態引き継ぎ判定用
        // 修正前開始日時の取得
        Date oldStartDate = schedule.getStartDate();
        // 修正前終了日時の取得
        Date oldEndDate = schedule.getEndDate();
        // 修正前予定名の取得
        String oldName = schedule.getName();
        // 修正前場所の取得
        String oldPlace = schedule.getPlace();
        // 修正前内容の取得
        String oldNote = schedule.getNote();
        // 修正前内容の取得
        String oldRepeatPattern = schedule.getRepeatPattern();
        // 修正前公開フラグの取得
        String oldPublicFlag = schedule.getPublicFlag();
        // 修正前公開フラグの取得
        Integer oldRepeatNum = schedule.getRepeatNum();
        // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
        String oldTemporaryFlag = schedule.getTemporaryFlag();
        // add end

        // 入力値をDB項目へ変換
        convertInputParamToSchedule(schedule);

        // change start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
        // isSameSchedule =
        // schedule.getStartDate().getTime() == oldStartDate.getTime()
        // && schedule.getEndDate().getTime() == oldEndDate.getTime()
        // && isSameValue(schedule.getName(), oldName)
        // && isSameValue(schedule.getPlace(), oldPlace)
        // && isSameValue(schedule.getNote(), oldNote)
        // && isSameValue(schedule.getRepeatPattern(), oldRepeatPattern)
        // && isSameValue(schedule.getPublicFlag(), oldPublicFlag)
        // && isSameValue(oldRepeatNum, schedule.getRepeatNum());
        isSameSchedule =
          schedule.getStartDate().getTime() == oldStartDate.getTime()
            && schedule.getEndDate().getTime() == oldEndDate.getTime()
            && isSameValue(schedule.getName(), oldName)
            && isSameValue(schedule.getPlace(), oldPlace)
            && isSameValue(schedule.getNote(), oldNote)
            && isSameValue(schedule.getRepeatPattern(), oldRepeatPattern)
            && isSameValue(schedule.getPublicFlag(), oldPublicFlag)
            && isSameValue(oldRepeatNum, schedule.getRepeatNum())
            && isSameValue(schedule.getTemporaryFlag(), oldTemporaryFlag);
        // change end

        // add end

        // add start 要件No.18 会議案内ファイル添付
        // 添付ファイル情報をデータベースに登録する．
        if (ScheduleUtils.insertFileDataDelegate(rundata, context, schedule, fileuploadList, folderName, delFilePathList, newFilesMap, msgList)) {
          // 添付ファイルの追加削除がある場合は、差異とみなす。
          isSameSchedule = false;
        }
        // add end

        // remove start
        // 設定処理を共通メソッドに移管
        // // 予定
        // schedule.setName(name.getValue());
        // // 場所
        // schedule.setPlace(place.getValue());
        // // 内容
        // schedule.setNote(note.getValue());
        // // 公開フラグ
        // schedule.setPublicFlag(public_flag.getValue());
        // // 共有メンバーによる編集／削除フラグ
        // if (schedule.getOwnerId().intValue() == ALEipUtils.getUserId(rundata)
        // || schedule.getOwnerId().intValue() == 0) {
        // schedule.setEditFlag(edit_flag.getValue());
        // }
        // remove end

        // オーナーIDを取得
        int ownerUserId = schedule.getOwnerId().intValue();

        // remove start
        // 参加メンバーより主催者を必ず外せない対応をしているため、削除
        // スケジュールの所有ユーザがすでにメンバーから抜けているかを検証する．
        // boolean rejectOwnerUser = false;
        // List<?> tmpScheduleMaps = schedule.getEipTScheduleMaps();
        // for (Object record : tmpScheduleMaps) {
        // EipTScheduleMap map = (EipTScheduleMap) record;
        // if (ownerUserId == map.getUserId().intValue()
        // && "R".equals(map.getStatus())) {
        // rejectOwnerUser = true;
        // break;
        // }
        // }
        //
        // if (rejectOwnerUser) {
        // // スケジュールの登録ユーザがすでにメンバーから抜けている場合、
        // // 最後に更新した人のユーザ ID をオーナ ID に設定する．
        // schedule.setOwnerId(Integer.valueOf(ALEipUtils.getUserId(rundata)));
        // }
        // remove end

        // 更新日
        schedule.setUpdateDate(new Date());
        schedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId(rundata)));

        // remove start
        // 設定処理を共通メソッドに移管
        // if (is_span) {
        // schedule.setEndDate(end_date.getValue());
        // schedule.setRepeatPattern("S");
        //
        // schedule.setStartDate(start_date.getValue());
        // } else if (!is_repeat) {
        // // 終了日時
        // schedule.setEndDate(end_date.getValue());
        // schedule.setRepeatPattern("N");
        //
        // schedule.setStartDate(start_date.getValue());
        // } else {
        // char lim = 'N';
        // Calendar cal = Calendar.getInstance();
        // cal.setTime(end_date.getValue());
        // if ("ON".equals(limit_flag.getValue())) {
        // lim = 'L';
        // cal.set(limit_end_date.getValue().getYear(), limit_end_date
        // .getValue()
        // .getMonth() - 1, limit_end_date.getValue().getDay());
        //
        // ALDateContainer container = limit_start_date.getValue();
        // Calendar limitStartCal = Calendar.getInstance();
        // limitStartCal.setTime(start_date.getValue());
        // limitStartCal.set(Calendar.YEAR, container.getYear());
        // limitStartCal.set(Calendar.MONTH, container.getMonth() - 1);
        // limitStartCal.set(Calendar.DATE, container.getDay());
        //
        // schedule.setStartDate(limitStartCal.getTime());
        // } else {
        // schedule.setStartDate(start_date.getValue());
        // }
        //
        // schedule.setEndDate(cal.getTime());
        // if ("D".equals(repeat_type.getValue())) {
        // String tmpPattern =
        // new StringBuffer().append('D').append(lim).toString();
        // schedule.setRepeatPattern(tmpPattern);
        // } else if ("W".equals(repeat_type.getValue())) {
        // String tmpPattern =
        // new StringBuffer().append('W').append(
        // week_0.getValue() != null ? 1 : 0).append(
        // week_1.getValue() != null ? 1 : 0).append(
        // week_2.getValue() != null ? 1 : 0).append(
        // week_3.getValue() != null ? 1 : 0).append(
        // week_4.getValue() != null ? 1 : 0).append(
        // week_5.getValue() != null ? 1 : 0).append(
        // week_6.getValue() != null ? 1 : 0).append(lim).toString();
        // schedule.setRepeatPattern(tmpPattern);
        //
        // } else {
        // DecimalFormat format = new DecimalFormat("00");
        // schedule.setRepeatPattern(new StringBuffer().append('M').append(
        // format.format(month_day.getValue())).append(lim).toString());
        // }
        // }
        // remove end

        List<?> scheduleMaps = schedule.getEipTScheduleMaps();

        Database.deleteAll(scheduleMaps);
        // スケジュールを登録
        // Database.commit();

        // change start
        // 必須・任意メンバー対応
        // for (ALEipUser user : memberList) {
        // EipTScheduleMap map = Database.create(EipTScheduleMap.class);
        // int userid = (int) user.getUserId().getValue();
        // map.setScheduleId(schedule.getScheduleId());
        // map.setEipTSchedule(schedule);
        // map.setUserId(Integer.valueOf(userid));
        //
        // // O: 自スケジュール T: 仮スケジュール C: 確定スケジュール
        // if (userid == schedule.getOwnerId().intValue()) {
        // map.setStatus("O");
        // } else {
        // if ("T".equals(change_tmpreserve_flag.getValue())) {
        // map.setStatus("T");
        // } else {
        // EipTScheduleMap tmpMap =
        // getScheduleMap(
        // scheduleMaps,
        // userid,
        // ScheduleUtils.SCHEDULEMAP_TYPE_USER);
        // if (tmpMap != null) {
        // map.setStatus(tmpMap.getStatus());
        // } else {
        // map.setStatus("T");
        // }
        // }
        // }
        //
        // EipTCommonCategory category =
        // CommonCategoryUtils.getEipTCommonCategory(common_category_id
        // .getValue());
        // if (category == null) {
        // map.setCommonCategoryId(Integer.valueOf(1));
        // map.setEipTSchedule(schedule);
        // map.setEipTCommonCategory(category1);
        // } else {
        // map.setCommonCategoryId(Integer.valueOf((int) (common_category_id
        // .getValue())));
        // map.setEipTSchedule(schedule);
        // map.setEipTCommonCategory(category);
        // }
        //
        // map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_USER);
        //
        // schedule.addToEipTScheduleMaps(map);
        // }

        // 施設廃止
        // グループに施設を追加する．（公開スケジュールのみ）
        // if ("O".equals(public_flag.toString()) && !(is_span)) {
        // for (Object record : facilityList) {
        // FacilityResultData frd = (FacilityResultData) record;
        // int facilityid = (int) frd.getFacilityId().getValue();
        //
        // EipTScheduleMap map = Database.create(EipTScheduleMap.class);
        // map.setEipTSchedule(schedule);
        // map.setUserId(Integer.valueOf(facilityid));
        // // O: 自スケジュール T: 仮スケジュール C: 確定スケジュール
        // map.setStatus("O");
        // map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY);
        // map.setEipTCommonCategory(category1);
        // map.setCommonCategoryId(Integer.valueOf(1));
        // }
        // }
        //
        // // 施設重複判定
        // if (!ignore_duplicate_facility) {
        // if (facilityList.size() > 0) {
        // ArrayList<Integer> fids = new ArrayList<Integer>();
        // FacilityResultData facility = null;
        // for (Object record : facilityList) {
        // facility = (FacilityResultData) record;
        // fids.add(Integer.valueOf((int) facility
        // .getFacilityId()
        // .getValue()));
        // }
        // if (ScheduleUtils.isDuplicateFacilitySchedule(
        // schedule,
        // fids,
        // null,
        // null)) {
        // if (msgList.size() == 0) {
        // msgList.add("duplicate_facility");
        // }
        // Database.rollback();
        // return false;
        // }
        // }
        // }
        // 日付・時刻変更判定：変更がない場合、回答状態を引き継ぐ
        boolean isSuccession = schedule.getStartDate().getTime() == oldStartDate.getTime() && schedule.getEndDate().getTime() == oldEndDate.getTime();

        // 必須メンバー登録
        createScheduleMapForUpdateSchedule(reqMemberList, ScheduleConst.SCHEDULEMAP_REQUIRED_T, schedule, category1, ownerUserId, scheduleMaps, isSuccession);

        // 任意メンバー登録
        createScheduleMapForUpdateSchedule(subMemberList, ScheduleConst.SCHEDULEMAP_REQUIRED_F, schedule, category1, ownerUserId, scheduleMaps, isSuccession);
        // change end
      }

      // add start 要件No.18 会議案内ファイル添付
      // 一時ディレクトリ⇒ストアディレクトリのコピー、またはストアディレクトリからのファイル削除
      ScheduleUtils.syncFile(folderName, (int) loginUser.getUserId().getValue(), ownerid, delFilePathList, newFilesMap, msgList);
      // add end

      // スケジュールを更新
      Database.commit();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId(), ALEventlogConstants.PORTLET_TYPE_SCHEDULE, schedule.getName());

      // アクティビティ
      String loginName = loginUser.getName().getValue();
      List<String> recipients = new ArrayList<String>();
      for (ALEipUser user : memberList) {
        if (loginUser.getUserId().getValue() != user.getUserId().getValue()) {
          recipients.add(user.getName().getValue());
        }
      }
      ScheduleUtils.createShareScheduleActivity(tmpSchedule, loginName, recipients, false);

    } catch (Exception e) {
      // add start 要件No.18 会議案内ファイル添付
      // ストアディレクトリに作成したファイルを削除する。
      ScheduleUtils.rollbackFiles((int) currentUser.getUserId().getValue(), newFilesMap);
      // add end
      Database.rollback();
      // change start
      // logger.error("[ScheduleFormData]", e);
      // throw new ALDBErrorException();
      logger.error("スケジュールの更新に失敗しました。ログインユーザー:" + loginUser.getName().getValue(), e);
      msgList.add("スケジュールの更新に失敗しました。");
      return false;
      // change end
    }

    // change start
    // try {
    // // メール送信
    // int msgType =
    // ALMailUtils.getSendDestType(ALMailUtils.KEY_MSGTYPE_SCHEDULE);
    // if (msgType > 0) {
    // // パソコンへメールを送信
    // List<ALEipUserAddr> destMemberList =
    // ALMailUtils.getALEipUserAddrs(memberList, ALEipUtils
    // .getUserId(rundata), false);
    // String subject = "[" + ALOrgUtilsService.getAlias() + "]スケジュール";
    //
    // if (edit_repeat_flag.getValue() == FLAG_EDIT_REPEAT_ONE) {
    // List<ALAdminMailMessage> messageList =
    // new ArrayList<ALAdminMailMessage>();
    // for (ALEipUserAddr destMember : destMemberList) {
    // ALAdminMailMessage message = new ALAdminMailMessage(destMember);
    // message.setPcSubject(subject);
    // message.setCellularSubject(subject);
    // message.setPcBody(ScheduleUtils.createMsgForPc(
    // rundata,
    // newSchedule,
    // memberList));
    // message.setCellularBody(ScheduleUtils.createMsgForCellPhone(
    // rundata,
    // newSchedule,
    // memberList,
    // destMember.getUserId()));
    // }
    //
    // ALMailService.sendAdminMail(new ALAdminMailContext(orgId, ALEipUtils
    // .getUserId(rundata), messageList, ALMailUtils
    // .getSendDestType(ALMailUtils.KEY_MSGTYPE_SCHEDULE)));
    // // msgList.addAll(errors);
    //
    // } else {
    // List<ALAdminMailMessage> messageList =
    // new ArrayList<ALAdminMailMessage>();
    // for (ALEipUserAddr destMember : destMemberList) {
    // ALAdminMailMessage message = new ALAdminMailMessage(destMember);
    // message.setPcSubject(subject);
    // message.setCellularSubject(subject);
    // message.setPcBody(ScheduleUtils.createMsgForPc(
    // rundata,
    // schedule,
    // memberList));
    // message.setCellularBody(ScheduleUtils.createMsgForCellPhone(
    // rundata,
    // schedule,
    // memberList,
    // destMember.getUserId()));
    // messageList.add(message);
    // }
    //
    // ALMailService.sendAdminMail(new ALAdminMailContext(orgId, ALEipUtils
    // .getUserId(rundata), messageList, ALMailUtils
    // .getSendDestType(ALMailUtils.KEY_MSGTYPE_SCHEDULE)));
    // // msgList.addAll(errors);
    // }
    // }
    // } catch (Exception ex) {
    // msgList.add("メールを送信できませんでした。");
    // logger.error("Exception", ex);
    // return false;
    // }
    // -----------------
    // メール送信処理
    // -----------------
    // メール送信実行
    if (!isSameSchedule) {
      // スケジュール内容に変更があった場合は、メンバー全員にメールを送信

      // add start 受入障害対応No.197対応
      // memberListの各ユーザーの「状態」を判定し、削除、辞退のユーザーについては
      // memberListから除外
      List<EipTScheduleMap> smList = ScheduleUtils.getEipTScheduleMapsByUserInfoSort(schedule.getScheduleId());
      memberList = ScheduleUtils.checkMemberList(memberList, smList);
      // add end

      // メール送信先
      // 参加メンバー（ログインユーザーを除く）を送信先にする
      List<ALEipUserAddr> sendToUserList = ALMailUtils.getALEipUserAddrs(memberList, ALEipUtils.getUserId(rundata), false);

      if (!ScheduleUtils.sendScheduleMail(sendToUserList, tmpSchedule.getOwnerId(), tmpSchedule, reqMemberList, subMemberList,
      // change start 要件No.1 スケジュール案内受信
        // "予定変更",
        ScheduleUtils.MEETING_UPDATE,
        // change end
        "変更しました。",
        rundata,
        // add start 要件No.1 スケジュール案内受信
        "",
        ScheduleUtils.CREATE_MSG_MODE_REQ
      // add end
        )) {
        msgList.add("mailErrMsg=メールを送信できませんでした。entityId=" + tmpSchedule.getScheduleId());
        return false;
      }
    } else {
      // スケジュール内容に変更がない場合は、新規追加メンバーにメール送信
      // 後の処理で、削除されたメンバーへメールを送信する。

      // メール送信先
      // 参加メンバー（ログインユーザーを除く）を送信先にする
      List<ALEipUserAddr> sendToUserList = ALMailUtils.getALEipUserAddrs(newmemberList, ALEipUtils.getUserId(rundata), false);

      if (!ScheduleUtils.sendScheduleMail(sendToUserList, tmpSchedule.getOwnerId(), tmpSchedule, reqMemberList, subMemberList,
      // change start 要件No.1 スケジュール案内受信
        // "予定作成",
        ScheduleUtils.MEETING_CREATE,
        "作成しました。",
        // change end
        rundata,
        // add start 要件No.1 スケジュール案内受信
        "",
        ScheduleUtils.CREATE_MSG_MODE_REQ
      // add end
        )) {
        msgList.add("mailErrMsg=メールを送信できませんでした。entityId=" + tmpSchedule.getScheduleId());
        return false;
      }
    }

    if (schedule.getOwnerId().intValue() != (int) loginUser.getUserId().getValue()) {

      // 秘書設定元へ代理操作の通知を行なう。

      // メール送信先(ALEipUser)秘書設定元送信用
      List<ALEipUser> sendToEipClientUserList = new ArrayList<ALEipUser>(0);

      sendToEipClientUserList.add(ALEipUtils.getALEipUser(schedule.getOwnerId().intValue()));

      List<ALEipUserAddr> sendToClientUserList = ALMailUtils.getALEipUserAddrs(sendToEipClientUserList, (int) loginUser.getUserId().getValue(), false);

      if (!ScheduleUtils.sendScheduleMail(
        sendToClientUserList,
        (int) loginUser.getUserId().getValue(),
        schedule.getOwnerId(),
        schedule,
        reqMemberList,
        subMemberList,
        ScheduleUtils.SUBSTITUTE_UPDATE,
        "変更しました。",
        rundata,
        // add start 要件No.1 スケジュール案内受信
        "",
        ScheduleUtils.CREATE_MSG_MODE_SUBREQ
      // add end
        )) {
        msgList.add("mailErrMsg=メールを送信できませんでした。entityId=" + schedule.getScheduleId());
        return false;
      }
    }

    if (removedMemberList.size() > 0) {

      // 今回更新でメンバーから除外されたユーザーに通知
      // スケジュール内容の変更有無に関わらず送信

      List<ALEipUserAddr> sendToRemovedUserAddrList = ALMailUtils.getALEipUserAddrs(removedMemberList, (int) loginUser.getUserId().getValue(), false);

      if (!ScheduleUtils.sendScheduleMail(
        sendToRemovedUserAddrList,
        (int) loginUser.getUserId().getValue(),
        schedule.getOwnerId(),
        schedule,
        reqMemberList,
        subMemberList,
        // change start 要件No.1 スケジュール案内受信
        // "予定削除",
        ScheduleUtils.MEETING_DELETE,
        // change end
        "削除しました。",
        rundata,
        true,
        // add start 要件No.1 スケジュール案内受信
        "",
        ScheduleUtils.CREATE_MSG_MODE_REQ
      // add end
        )) {
        msgList.add("mailErrMsg=メールを送信できませんでした。entityId=" + schedule.getScheduleId());
        return false;
      }
    }
    // change end
    return true;
  }

  /**
   * 引き継ぎスケジュールマップ取得
   * 
   * @param scheduleMaps
   *          抽出対象のスケジュールマップ一覧
   * @param userid
   *          抽出条件のユーザーID
   * @param type
   *          抽出条件のユーザー/施設
   * @return ユーザーID、必須フラグ、ユーザー/施設が一致するスケジュールマップ。一致するものがない場合null。
   */
  private EipTScheduleMap getScheduleMap(List<?> scheduleMaps, int userid, String type) {
    for (Object record : scheduleMaps) {
      EipTScheduleMap map = (EipTScheduleMap) record;
      if (map.getUserId().intValue() == userid && type.equals(map.getType())) {
        return map;
      }
    }
    return null;
  }

  /**
   * 参加メンバー全員の予定を完全に削除します。
   * 
   * @param schedule
   * @param members
   */
  private void deleteMemberAllRangeAll(EipTSchedule schedule, List<ALEipUser> members) throws ALDBErrorException, ALPageNotFoundException {
    deleteSchedule(schedule);
  }

  /**
   * 参加メンバー全員の一日分の予定を削除します。
   * 
   * @param schedule
   * @param members
   * @throws ALDBErrorException
   * @throws ALPageNotFoundException
   */
  private void deleteMemberAllRangeOneday(EipTSchedule schedule, List<ALEipUser> members) throws ALDBErrorException, ALPageNotFoundException {
    if (!"N".equals(schedule.getRepeatPattern())) {
      int ownerid = (int) loginUser.getUserId().getValue();

      // ダミーのスケジュールを登録する．
      // change start
      // 削除で使用する参加メンバー一覧を統一
      // int memberIdListSize = memberList.size();
      // int[] memberIdList = new int[memberIdListSize];
      // for (int i = 0; i < memberIdListSize; i++) {
      // memberIdList[i] = (int) memberList.get(i).getUserId().getValue();
      // }
      int memberIdListSize = members.size();
      int[] memberIdList = new int[memberIdListSize];
      for (int i = 0; i < memberIdListSize; i++) {
        memberIdList[i] = (int) members.get(i).getUserId().getValue();
      }
      // change end

      // 同時に削除する施設ID一覧を取得する。
      int[] facilityIdList = ScheduleUtils.getFacilityIds(schedule);

      ScheduleUtils.insertDummySchedule(schedule, ownerid, view_date.getValue(), view_date.getValue(), memberIdList, facilityIdList);
    }
  }

  /**
   * 特定のメンバーの予定を完全に削除します。
   * 
   * @param schedule
   * @param members
   * @throws ALDBErrorException
   * @throws ALPageNotFoundException
   */
  private void deleteMemberOneRangeAll(EipTSchedule schedule, List<ALEipUser> members, boolean isFacility, int deleteUserId, boolean acl_delete_other)
      throws ALPageNotFoundException, ALDBErrorException {

    List<?> scheduleMaps = ScheduleUtils.getEipTScheduleMaps(schedule);
    if (scheduleMaps != null && scheduleMaps.size() > 0) {
      if (isFacility) {
        // 施設を削除する場合
        for (Object reocrd : scheduleMaps) {
          EipTScheduleMap scheduleMap = (EipTScheduleMap) reocrd;
          if (ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY.equals(scheduleMap.getType())) {
            if (scheduleMap.getUserId().intValue() == deleteUserId) {
              Database.delete(scheduleMap);
            }
          }
        }
      } else {
        // ユーザを削除する場合
        List<EipTScheduleMap> tmpScheduleMaps = new ArrayList<EipTScheduleMap>();
        int countRejectSchedule = 0;
        for (Object reocrd : scheduleMaps) {
          EipTScheduleMap scheduleMap = (EipTScheduleMap) reocrd;
          if (ScheduleUtils.SCHEDULEMAP_TYPE_USER.equals(scheduleMap.getType())) {
            tmpScheduleMaps.add(scheduleMap);
            if ("R".equals(scheduleMap.getStatus())) {
              countRejectSchedule += 1;
            }
          }
        }

        int scheduleMapsSize = tmpScheduleMaps.size();

        if (countRejectSchedule >= scheduleMapsSize - 1) {
          // この schedule ID に関係するスケジュールがすべて reject されたため，
          // すべて削除する．
          deleteSchedule(schedule);
        } else {
          for (int i = 0; i < scheduleMapsSize; i++) {
            EipTScheduleMap scheduleMap = tmpScheduleMaps.get(i);
            if (scheduleMap.getUserId().intValue() == deleteUserId) {
              // change start
              // 同一用途のフィールド変数があるため統一
              // int loginUserId = (int) login_user.getUserId().getValue();
              int loginUserId = (int) loginUser.getUserId().getValue();
              // change end
              if ((scheduleMap.getUserId().intValue() == loginUserId) || (schedule.getCreateUserId().intValue() == loginUserId) || acl_delete_other) {
                if ("O".equals(scheduleMap.getStatus())) {
                  schedule.setOwnerId(Integer.valueOf(0));
                  if ("F".equals(schedule.getEditFlag())) {
                    // 削除するユーザーが，スケジュールの登録者であり，
                    // かつ，そのスケジュールの編集権限が他の共有メンバーに与えられていないときには，
                    // そのスケジュールの編集権限を 'T' に設定する．
                    schedule.setEditFlag("T");
                  }
                }
                scheduleMap.setStatus("R");
              }
            }
          }
        }
      }
    }
  }

  // add start 要件No.18 会議案内ファイル添付
  /**
   * 削除対象の添付ファイルリストを取得する。
   * 
   * @param schedule
   *          削除対象のスケジュール
   * @return 削除対象のファイルパスリスト（先頭にスラッシュ付き）
   */
  private List<String> getDeleteTargetFileList(EipTSchedule schedule) {

    // ファイル削除処理
    List<String> fpaths = new ArrayList<String>();
    SelectQuery<AvzTScheduleFile> query = Database.query(AvzTScheduleFile.class);
    query.andQualifier(ExpressionFactory.matchDbExp(AvzTScheduleFile.TO_EIP_TSCHEDULE_PROPERTY, schedule.getScheduleId()));
    List<AvzTScheduleFile> files = query.fetchList();
    if (files != null) {
      for (AvzTScheduleFile file : files) {
        fpaths.add(file.getFilePath());
      }
    }
    return fpaths;
  }

  /**
   * 添付ファイルを物理削除する。
   * 
   * @param fpaths
   *          削除対象のファイルパスリスト
   */
  private void deleteFiles(List<String> fpaths) {
    // ローカルファイルに保存されているファイルを削除する．
    try {
      if (fpaths != null) {
        for (String path : fpaths) {
          String f = ScheduleUtils.getSaveDirPath(Database.getDomainName(), (int) currentUser.getUserId().getValue()) + path;
          ALStorageService.deleteFile(f);
        }
      }
    } catch (Exception e) {
      logger.warn("スケジュールの添付ファイルの削除に失敗しました。ログインユーザー:" + loginUser.getName().getValue(), e);
    }
  }

  // add end

  /**
   * 特定のメンバーの一日分の予定を削除します。
   * 
   * @param schedule
   * @param members
   * @throws ALDBErrorException
   * @throws ALPageNotFoundException
   */
  private void deleteMemberOneRangeOneday(EipTSchedule schedule, List<ALEipUser> members, boolean isFacility, int deleteUserId, boolean acl_delete_other,
      RunData rundata, Context context) throws ALDBErrorException, ALPageNotFoundException {
    if (!"N".equals(schedule.getRepeatPattern())) {
      int loginUserId = (int) loginUser.getUserId().getValue();

      if (isFacility) {
        memberList = new ArrayList<ALEipUser>();
        this.loadFormData(rundata, context, new ArrayList<String>());
        for (int i = 0; facilityList.size() > i; i++) {
          if (((FacilityResultData) facilityList.get(i)).getFacilityId().getValue() == deleteUserId) {
            facilityList.remove(i);
            break;
          }
        }
        edit_repeat_flag.setValue(ScheduleFormData.FLAG_EDIT_REPEAT_ONE);
        this.updateFormData(rundata, context, new ArrayList<String>());
      } else {
        // 参加ユーザー数を調べる
        EipTScheduleMap map;
        int user_count = 0;
        List<?> maps = schedule.getEipTScheduleMaps();
        for (Object record : maps) {
          map = (EipTScheduleMap) record;
          if (map.getType().equals(ScheduleUtils.SCHEDULEMAP_TYPE_USER)) {
            user_count++;
          }
        }

        // 既に登録されているダミースケジュールを検索する
        SelectQuery<EipTSchedule> dummy_query = Database.query(EipTSchedule.class);
        Expression exp1 = ExpressionFactory.matchExp(EipTSchedule.PARENT_ID_PROPERTY, schedule.getScheduleId());
        Expression exp2 = ExpressionFactory.matchExp(EipTSchedule.START_DATE_PROPERTY, view_date.getValue());
        Expression exp3 = ExpressionFactory.matchExp(EipTSchedule.END_DATE_PROPERTY, view_date.getValue());
        dummy_query.setQualifier(exp1);
        dummy_query.andQualifier(exp2);
        dummy_query.andQualifier(exp3);
        List<EipTSchedule> list = dummy_query.fetchList();

        // ダミー登録されている人数をカウントする
        int dummy_count = 0;
        for (EipTSchedule dummy : list) {
          List<?> dummymaps = dummy.getEipTScheduleMaps();
          for (Object record : dummymaps) {
            EipTScheduleMap dummymap = (EipTScheduleMap) record;
            if (dummymap.getType().equals(ScheduleUtils.SCHEDULEMAP_TYPE_USER)) {
              dummy_count++;
            }
          }
        }

        int[] facilityIdList = null;
        if (dummy_count >= user_count - 1) {
          // if( 登録済みダミースケジュール数合計 >= スケジュール参加者数 - 今回予定を消す人 )
          // 全員の予定が消されているので、同時に削除する施設ID一覧を取得する。
          facilityIdList = ScheduleUtils.getFacilityIds(schedule);
        }
        ScheduleUtils.insertDummySchedule(schedule, loginUserId, view_date.getValue(), view_date.getValue(), new int[] { deleteUserId }, facilityIdList);
      }
    }
  }

  /*
   * 削除処理
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#deleteFormData(RunData,
   * Context, List<String>)
   */
  @Override
  @SuppressWarnings("unchecked")
  protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    // add start
    // セッションを取得
    HttpSession session = rundata.getSession();

    // メール送信可否
    boolean canSendMail = false;

    // 繰り返し予定の1日だけ削除フラグ
    boolean isRangeOneday = false;

    // 削除対象スケジュール
    EipTSchedule schedule = null;

    // 対象スケジュールのスケジュールID
    Integer scheduleId = null;
    try {
      scheduleId = new Integer(ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID));
    } catch (NumberFormatException e1) {
      scheduleId = null;
    }

    // 削除対象のユーザID
    int userid = 0;

    // スケジュールの参加メンバー（削除処理専用）
    List<ALEipUser> members = new ArrayList<ALEipUser>(0);
    // add end

    try {
      // パラメータを取得する．
      // add start 要件No.2 スケジュール案内送信
      if (rundata.getParameters().containsKey("cancel_reason")) {
        cancel_reason.limitMaxLength(1000);
        cancel_reason.setValue(rundata.getParameters().getString("cancel_reason"));
        if (!cancel_reason.validate(msgList)) {
          return false;
        }
      }
      // add end

      if (rundata.getParameters().containsKey("del_member_flag")) {
        del_member_flag.setValue(rundata.getParameters().getString("del_member_flag"));
      }
      if (rundata.getParameters().containsKey("del_range_flag")) {
        del_range_flag.setValue(rundata.getParameters().getString("del_range_flag"));
      }
      // remove start
      // 変数スコープを上位に移動
      // 削除対象のユーザID
      // int userid = 0;
      // remove end
      if (rundata.getParameters().containsKey("userid")) {
        userid = rundata.getParameters().getInt("userid");
      }
      boolean is_facility = false; // 削除のユーザIDが施設かどうか
      if (rundata.getParameters().containsKey("type")) {
        is_facility = ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY.equals(rundata.getParameters().getString("type"));
      }

      // オブジェクトモデルを取得
      // change start
      // 変数スコープを上位に移動
      // EipTSchedule schedule = ScheduleUtils.getEipTSchedule(rundata, context,
      // false);
      schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
      // change end
      // remove start
      // 上の呼び出している処理で戻り値がnullの場合例外が発生するため、当処理は無意味。
      // if (schedule == null) {
      // return false;
      // }
      // remove end

      // 共有メンバーを取得する．
      // change start
      // List<ALEipUser> members = ScheduleUtils.getUsers(rundata, context,
      // true);
      // if (members != null && members.size() > 0) {
      // memberList.addAll(members);
      // }
      List<EipTScheduleMap> smList = ScheduleUtils.getEipTScheduleMapsByUserInfoSort(scheduleId);
      // 必須と任意メンバーに仕分けする
      for (EipTScheduleMap sm : smList) {
        ALEipUser user = ALEipUtils.getALEipUser(sm.getUserId());
        if (ScheduleConst.SCHEDULEMAP_REQUIRED_T.equals(sm.getRequired())) {
          // 必須メンバー
          reqMemberList.add(user);
        } else {
          // 任意メンバー
          subMemberList.add(user);
        }
        members.add(user);
      }
      // 共有スケジュールかチェック
      if (members.size() >= 2) {
        // 参加メンバーが2名以上の場合、共有スケジュールとみなす
        canSendMail = true;
        // メール送信用情報をセッションに格納
        session.setAttribute(S_SCHDULE_FOR_SENDMAIL, schedule);
        session.setAttribute(S_USERS_FOR_SENDMAIL, members);
        session.setAttribute(S_REQUSERS_FOR_SENDMAIL, reqMemberList);
        session.setAttribute(S_SUBUSERS_FOR_SENDMAIL, subMemberList);
        session.setAttribute(S_RANGEFLAG_FOR_SENDMAIL, false);
      }
      // change end

      // change start
      // 秘書設定対応により、他ユーザー削除権限を常に可とする
      // boolean acl_delete_other =
      // ScheduleUtils.hasAuthorityForOtherSchedule(
      // rundata,
      // ALAccessControlConstants.VALUE_ACL_DELETE);
      boolean acl_delete_other = true;
      // change start

      // remove start
      // 秘書設定対応により主催者=ログインユーザーおよび主催者=作成者の操作可能にする処理を削除
      // boolean isMember = false;
      // int loginuserId = (int) login_user.getUserId().getValue();
      // for (ALEipUser user : memberList) {
      // if (loginuserId == user.getUserId().getValue()) {
      // isMember = true;
      // break;
      // }
      // }
      // if (!acl_delete_other
      // && !isMember
      // && (schedule.getCreateUserId().intValue() != loginuserId)) {
      // logger
      // .error("[ScheduleFormData] ALPageNotFoundException: The user does not
      // have the auth to delete the schedule.");
      // throw new ALPermissionException();
      // }
      //
      // if (!acl_delete_other
      // && loginuserId != schedule.getOwnerId().intValue()
      // && "F".equals(schedule.getEditFlag())
      // && FLAG_DEL_MEMBER_ONE != del_member_flag.getValue()) {
      // logger
      // .error("[ScheduleFormData] ALPageNotFoundException: The user does not
      // have the auth to delete the schedule.");
      // throw new ALPermissionException();
      // }
      // remove end

      // add start 要件No.18 会議案内ファイル添付
      List<String> delPathList = null;
      // add end
      if (del_member_flag.getValue() == FLAG_DEL_MEMBER_ALL) {
        if (del_range_flag.getValue() == FLAG_DEL_RANGE_ALL) {
          // 全メンバーかつ全スケジュール
          deleteMemberAllRangeAll(schedule, members);
          // add start 要件No.18 会議案内ファイル添付
          // 削除対象のファイルパスリストを取得する。
          delPathList = getDeleteTargetFileList(schedule);
          // add end
        } else {
          // 全メンバーかつ特定スケジュール
          deleteMemberAllRangeOneday(schedule, members);
          // add start
          isRangeOneday = true;
          session.setAttribute(S_RANGEFLAG_FOR_SENDMAIL, true);
          // add end
        }
      } else {
        if (del_range_flag.getValue() == FLAG_DEL_RANGE_ALL) {
          // 特定メンバーかつ全スケジュール
          deleteMemberOneRangeAll(schedule, members, is_facility, userid, acl_delete_other);
          // add start 要件No.18 会議案内ファイル添付
          // 削除対象のファイルパスリストを取得する。
          delPathList = getDeleteTargetFileList(schedule);
          // add end
        } else {
          // 特定メンバーかつ特定スケジュール
          deleteMemberOneRangeOneday(schedule, members, is_facility, userid, acl_delete_other, rundata, context);
          // add start
          isRangeOneday = true;
          session.setAttribute(S_RANGEFLAG_FOR_SENDMAIL, true);
          // add end
        }
      }
      // add start 要件No.18 会議案内ファイル添付
      // ストアディレクトリの添付ファイルを物理削除
      deleteFiles(delPathList);
      // add end

      Database.commit();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId(), ALEventlogConstants.PORTLET_TYPE_SCHEDULE, schedule.getName());

    } catch (Exception e) {
      Database.rollback();
      // change start
      // logger.error("[ScheduleFormData]", e);
      // throw new ALDBErrorException();
      // セッションよりメール情報有無をチェック
      if (containsKeyFromSession(session, S_SCHDULE_FOR_SENDMAIL)) {
        // メール情報が有る場合は、メール送信リトライとみなし処理を続行する
        schedule = (EipTSchedule) session.getAttribute(S_SCHDULE_FOR_SENDMAIL);
        members = (List<ALEipUser>) session.getAttribute(S_USERS_FOR_SENDMAIL);
        reqMemberList = (List<ALEipUser>) session.getAttribute(S_REQUSERS_FOR_SENDMAIL);
        subMemberList = (List<ALEipUser>) session.getAttribute(S_SUBUSERS_FOR_SENDMAIL);
        isRangeOneday = (Boolean) session.getAttribute(S_RANGEFLAG_FOR_SENDMAIL);
        canSendMail = true;
      } else {
        // メール情報がない場合は、エラーにする
        logger.error("スケジュールの削除に失敗しました。ログインユーザー:" + loginUser.getName() + "/スケジュールID:" + scheduleId + "/対象ユーザー:" + userid, e);
        msgList.add("スケジュールの削除に失敗しました。");
        return false;
      }
      // change end
    }

    // add start 2011/12/22 代理削除(共有スケジュール以外)対応
    boolean isOwner = true;
    if (schedule.getOwnerId().intValue() != (int) loginUser.getUserId().getValue()) {
      isOwner = false;
    }
    // add end

    // add start
    // change start 2011/12/22 代理削除(共有スケジュール以外)対応
    // if (!canSendMail || null == schedule) {
    if ((!canSendMail && isOwner) || null == schedule) {
      // "「共有スケジュールでない」 かつ 「自スケジュール」" または "スケジュールがない"
      // この場合に処理を終了するに変更します。
      // change end
      // メールを送信しない場合、ここで処理を終了する
      return true;
    }

    // add start 2011/12/22 代理削除(共有スケジュール以外)対応
    // 後続のメール送信処理実行条件は
    // 共有スケジュールの場合にメンバーにメール送信実行
    // アクション文
    String actionText = "";
    if (isRangeOneday) {
      // 繰り返し予定の一部を削除
      SimpleDateFormat df = new SimpleDateFormat("yyyy'年'M'月'd'日'");
      actionText = df.format(view_date.getValue()) + "分のみ削除しました。";
    } else {
      // 単一予定または全予定削除
      actionText = "削除しました。";
    }

    if (canSendMail) {
      // add end
      // -----------------
      // メール送信処理
      // -----------------
      // メール送信先
      // 参加メンバー（ログインユーザーを除く）を送信先にする
      List<ALEipUserAddr> sendToUserList = ALMailUtils.getALEipUserAddrs(members, ALEipUtils.getUserId(rundata), false);

      // メール送信実行
      if (ScheduleUtils.sendScheduleMail(sendToUserList, schedule.getOwnerId(), 0, schedule, reqMemberList, subMemberList,
      // change start 要件No.1 スケジュール案内受信
        // "予定削除",
        ScheduleUtils.MEETING_DELETE,
        // change end
        actionText,
        rundata,
        true,
        // add start 要件No.1 スケジュール案内受信 No.2 スケジュール案内送信
        cancel_reason.getValue(),
        ScheduleUtils.CREATE_MSG_MODE_REQ
      // add end
        )) {
        // 送信に成功した場合は、セッションの送信メール情報を削除する
        doRemoveSendMailInfoFromSession(rundata);
      } else {
        msgList.add("メールを送信できませんでした。");
        return false;
      }
      // add start 2011/12/22 代理削除(共有スケジュール以外)対応
    }
    // add end
    if (schedule.getOwnerId().intValue() != (int) loginUser.getUserId().getValue()) {

      // 秘書設定元へ代理操作の通知を行なう。

      // メール送信先(ALEipUser)秘書設定元送信用
      List<ALEipUser> sendToEipClientUserList = new ArrayList<ALEipUser>(0);

      sendToEipClientUserList.add(ALEipUtils.getALEipUser(schedule.getOwnerId().intValue()));

      List<ALEipUserAddr> sendToClientUserList = ALMailUtils.getALEipUserAddrs(sendToEipClientUserList, (int) loginUser.getUserId().getValue(), false);

      if (!ScheduleUtils.sendScheduleMail(
        sendToClientUserList,
        (int) loginUser.getUserId().getValue(),
        schedule.getOwnerId(),
        schedule,
        reqMemberList,
        subMemberList,
        ScheduleUtils.SUBSTITUTE_DELETE,
        // change start 強化テストNo.76
        // "削除しました。",
        actionText,
        // change end
        rundata,
        true,
        // add start 要件No.1 スケジュール案内受信 No.2 スケジュール案内送信
        cancel_reason.getValue(),
        ScheduleUtils.CREATE_MSG_MODE_SUBREQ
      // add end
        )) {
        msgList.add("mailErrMsg=メールを送信できませんでした。entityId=" + schedule.getScheduleId());
        return false;
      }
    }
    // add end

    return true;
  }

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#doViewForm(ALAction,
   * RunData, Context)
   */
  @Override
  public boolean doViewForm(ALAction action, RunData rundata, Context context) {
    // for schedule copy
    try {
      init(action, rundata, context);
      boolean isedit = (ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID) != null);

      if (is_copy) {
        isedit = false;
      }

      int aclType = ALAccessControlConstants.VALUE_ACL_INSERT;
      if (isedit) {
        aclType = ALAccessControlConstants.VALUE_ACL_UPDATE;
      }
      doCheckAclPermission(rundata, context, aclType);

      action.setMode(isedit ? ALEipConstants.MODE_EDIT_FORM : ALEipConstants.MODE_NEW_FORM);
      setMode(action.getMode());

      List<String> msgList = new ArrayList<String>();
      boolean res = (isedit || is_copy) ? loadFormData(rundata, context, msgList) : setFormData(rundata, context, msgList);
      action.setResultData(this);
      if (!msgList.isEmpty()) {
        action.addErrorMessages(msgList);
      }
      action.putData(rundata, context);
      return res;
    } catch (ALPermissionException e) {
      // change start
      // ALEipUtils.redirectPermissionError(rundata);
      logger.error("スケジュール作成(編集)の表示で権限例外が発生しました。ログインユーザー:" + ALEipUtils.getALEipUser(rundata).getName(), e);
      // change end
      return false;
    } catch (ALPageNotFoundException e) {
      // change start
      // ALEipUtils.redirectPageNotFound(rundata);
      logger.error("スケジュール作成(編集)の表示でページ遷移例外が発生しました。ログインユーザー:" + ALEipUtils.getALEipUser(rundata).getName(), e);
      // change end
      return false;
    } catch (ALDBErrorException e) {
      // change start
      // ALEipUtils.redirectDBError(rundata);
      logger.error("スケジュール作成(編集)の表示でDBアクセスエラー例外が発生しました。ログインユーザー:" + ALEipUtils.getALEipUser(rundata).getName(), e);
      // change end
      return false;
    }
  }

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   * @return
   */
  @Override
  public boolean doInsert(ALAction action, RunData rundata, Context context) {
    boolean res = super.doInsert(action, rundata, context);
    // post(action, rundata, context);
    return res;
  }

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   * @return
   */
  @Override
  public boolean doUpdate(ALAction action, RunData rundata, Context context) {
    boolean res = super.doUpdate(action, rundata, context);
    // post(action, rundata, context);
    return res;
  }

  // add start
  /**
   * セッションより送信メール情報を削除します。
   * 
   * @param rundata
   *          実行データ
   */
  public static void doRemoveSendMailInfoFromSession(RunData rundata) {
    // メール送信情報を削除する
    HttpSession s = rundata.getSession();
    s.removeAttribute(S_SCHDULE_FOR_SENDMAIL);
    s.removeAttribute(S_USERS_FOR_SENDMAIL);
    s.removeAttribute(S_REQUSERS_FOR_SENDMAIL);
    s.removeAttribute(S_SUBUSERS_FOR_SENDMAIL);
    s.removeAttribute(S_RANGEFLAG_FOR_SENDMAIL);
    logger.debug("[ScheduleFormData]call doRemoveSendMailInfoFromSession.");
  }

  // add end

  // remove start
  // 使用しないため削除
  // private boolean facilityCheckAclPermission(RunData rundata, int aclType) {
  // ALAccessControlFactoryService aclservice =
  // (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
  // .getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
  // ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
  //
  // hasAuthority =
  // aclhandler.hasAuthority(
  // ALEipUtils.getUserId(rundata),
  // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_FACILITY,
  // aclType);
  // return hasAuthority;
  // }
  // remove end

  @SuppressWarnings("unused")
  private void post(ALAction action, RunData rundata, Context context) {
    selectData = new ScheduleOnedayGroupSelectData();
    selectData.initField();

    if (tmpView != null && !tmpView.equals("")) {
      selectData.setTmpViewDate(tmpView);
    } else {
      start_date.setNotNull(true);
      if (start_date.validate(new ArrayList<String>())) {
        selectData.setTmpViewDate(start_date.toString());
      } else if (tmpStart == null || tmpStart.equals("")) {
        ALDateTimeField now = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        now.setValue(new Date());
        selectData.setTmpViewDate(now.toString());
      } else {
        selectData.setTmpViewDate(tmpStart);
      }
    }

    selectData.doSelectList(action, rundata, context);

    // 期限の調節：終了日を開始日より後の日時にする．
    // try {
    // if (limit_end_date.getValue().getDate().before(
    // limit_start_date.getValue().getDate())) {
    // limit_end_date.setValue(limit_start_date.getValue().getDate());
    // }
    // } catch (Exception ex) {
    // }
  }

  /**
   * 指定した曜日が，選択範囲に入っているかを検証する．
   * 
   * @param selectedWeek
   *          指定曜日
   * @param startWeek
   *          期間開始曜日
   * @param endWeek
   *          期間終了曜日
   * @return 選択範囲に入っている場合，true．
   */
  @SuppressWarnings("unused")
  private boolean includeWeek(int selectedWeek, int startWeek, int endWeek) {
    if (startWeek <= endWeek) {
      if (startWeek <= selectedWeek && selectedWeek <= endWeek) {
        return true;
      } else {
        return false;
      }
    } else {
      if (selectedWeek < startWeek && endWeek < selectedWeek) {
        return false;
      } else {
        return true;
      }
    }
  }

  /**
   * 指定したスケジュールを削除する．
   * 
   * @param schedule
   */
  private void deleteSchedule(EipTSchedule schedule) {
    Integer scheduleId = schedule.getScheduleId();
    Database.delete(schedule);
    // ダミースケジュールの取得
    SelectQuery<EipTSchedule> query = Database.query(EipTSchedule.class);
    Expression exp1 = ExpressionFactory.matchExp(EipTSchedule.PARENT_ID_PROPERTY, scheduleId);
    query.setQualifier(exp1);
    Expression exp2 = ExpressionFactory.matchExp(EipTSchedule.EIP_TSCHEDULE_MAPS_PROPERTY + "." + EipTScheduleMap.STATUS_PROPERTY, "D");
    query.andQualifier(exp2);
    List<EipTSchedule> dellist = query.fetchList();
    // ダミースケジュールの削除
    Database.deleteAll(dellist);

    // 2007.3.28 ToDo連携
  }

  /**
   * 第一引数のリストに，第二引数で指定したユーザ ID が含まれているかを検証する．
   * 
   * @param memberIdList
   * @param memberId
   * @return
   */
  private boolean isContains(List<Integer> memberIdList, int userId) {
    int size = memberIdList.size();
    Integer tmpInt = null;
    for (int i = 0; i < size; i++) {
      tmpInt = memberIdList.get(i);
      if (userId == tmpInt.intValue()) {
        return true;
      }
    }
    return false;
  }

  // add start

  /**
   * セッションにキーが存在するかチェックします。
   * 
   * @param s
   *          セッション
   * @param key
   *          判定したいキー
   * @return キーが存在する場合true、そうでない場合false
   */
  private boolean containsKeyFromSession(HttpSession s, String key) {
    boolean result = false;
    @SuppressWarnings("unchecked")
    Enumeration<String> sessionNames = s.getAttributeNames();
    while (sessionNames.hasMoreElements()) {
      String name = sessionNames.nextElement();
      if (name.equals(key)) {
        result = true;
        break;
      }
    }
    return result;
  }

  /**
   * 時刻入力直接入力判定
   * 
   * @return 直接入力の場合true
   */
  private boolean isTimeTextInput() {
    return TIME_INPUT_TYPE_TEXT.equals(time_input_type);
  }

  /**
   * 参加メンバーのスケジュールマップ作成（スケジュール新規登録）
   * 
   * @param list
   *          参加メンバー一覧
   * @param required
   *          登録したい必須フラグの値
   * @param schedule
   *          新規登録対象スケジュール
   * @param category
   *          カテゴリー
   * @param ownerUserId
   *          主催者ユーザーID
   */
  private void createScheduleMapForNewSchedule(List<ALEipUser> list, String required, EipTSchedule schedule, EipTCommonCategory category, int ownerUserId) {
    for (ALEipUser user : list) {
      EipTScheduleMap map = Database.create(EipTScheduleMap.class);
      int userid = (int) user.getUserId().getValue();

      // スケジュール
      map.setEipTSchedule(schedule);

      // ユーザーID
      map.setUserId(Integer.valueOf(userid));

      if (userid == ownerUserId) {
        // 主催者ユーザーと参加メンバーが同一の場合、所有者
        map.setStatus(ScheduleConst.SCHEDULEMAP_STATUS_OWNER);
      } else {
        // 未回答
        map.setStatus(ScheduleConst.SCHEDULEMAP_STATUS_NON_RES);
      }

      // 種別：ユーザー固定
      map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_USER);

      // 共有カテゴリー
      map.setCommonCategoryId(Integer.valueOf(1));
      map.setEipTCommonCategory(category);

      // 必須フラグ
      map.setRequired(required);

      // 重要フラグ：通常
      map.setPriority(ScheduleConst.SCHEDULEMAP_PRIORITY_F);

      // ダミー未回答フラグ：通常
      map.setDummyNonResponse(ScheduleConst.SCHEDULEMAP_DUMMY_NON_RES_F);

    }
  }

  /**
   * 参加メンバーのスケジュールマップ作成（スケジュール更新）
   * 
   * @param list
   *          参加メンバー一覧
   * @param required
   *          登録したい必須フラグの値
   * @param schedule
   *          更新対象スケジュール
   * @param category
   *          カテゴリー
   * @param ownerUserId
   *          主催者ユーザーID
   * @param oldScheduleMaps
   *          洗い替え前のスケジュールマップ
   * @param isSuccession
   *          旧データより回答状態を引き継ぐ場合true
   */
  private void createScheduleMapForUpdateSchedule(List<ALEipUser> list, String required, EipTSchedule schedule, EipTCommonCategory category, int ownerUserId,
      List<?> oldScheduleMaps, boolean isSuccession) {

    for (ALEipUser user : list) {
      EipTScheduleMap map = Database.create(EipTScheduleMap.class);
      int userid = (int) user.getUserId().getValue();

      // スケジュール
      map.setEipTSchedule(schedule);
      // ユーザーID
      map.setUserId(Integer.valueOf(userid));
      // 状態：未回答
      map.setStatus(ScheduleConst.SCHEDULEMAP_STATUS_NON_RES);
      // 種別：ユーザー固定
      map.setType(ScheduleUtils.SCHEDULEMAP_TYPE_USER);
      // 共有カテゴリー
      map.setCommonCategoryId(Integer.valueOf(1));
      map.setEipTCommonCategory(category);
      // 必須フラグ
      map.setRequired(required);
      // 重要フラグ：通常
      map.setPriority(ScheduleConst.SCHEDULEMAP_PRIORITY_F);
      // ダミー未回答フラグ：通常
      map.setDummyNonResponse(ScheduleConst.SCHEDULEMAP_DUMMY_NON_RES_F);

      // 旧スケジュールマップを取得
      EipTScheduleMap oldMap = getScheduleMap(oldScheduleMaps, userid, ScheduleUtils.SCHEDULEMAP_TYPE_USER);

      // 状態・ダミー未回答の引き継ぎ
      if (userid == schedule.getOwnerId().intValue()) {
        // 主催者ユーザーと参加メンバーが同一の場合
        // 状態：所有者
        map.setStatus(ScheduleConst.SCHEDULEMAP_STATUS_OWNER);
      } else if (oldMap != null && required.equals(oldMap.getRequired()) && isSuccession) {
        // 旧スケジュールマップと必須/任意が一致 かつ 引き継ぎ可の場合
        // 状態：引き継ぎ
        map.setStatus(oldMap.getStatus());
        // ダミー未回答フラグ：引き継ぎ
        map.setDummyNonResponse(oldMap.getDummyNonResponse());
      }

      // 重要フラグの引き継ぎ
      if (oldMap != null) {
        // 旧スケジュールマップが有る場合
        // 重要フラグ：引き継ぎ
        map.setPriority(oldMap.getPriority());
        // add start 要件No.26 スケジュール個別色換え
        // 個別色：引き継ぎ
        map.setIndividualColor(oldMap.getIndividualColor());
        // add end
      }

      // スケジュール配下に追加
      schedule.addToEipTScheduleMaps(map);
    }
  }

  // add end

  /**
   * 開始日時を取得します。
   * 
   * @return
   */
  public ALDateTimeField getStartDate() {
    return start_date;
  }

  /**
   * 開始日時を取得します。
   * 
   * @return
   */
  public ALDateTimeField getStartDateSub() {
    ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
    tmpDate.setValue(start_date.getValue());
    return tmpDate;
  }

  /**
   * 開始日時を取得します。
   * 
   * @return
   */
  public ALDateTimeField getStartDateTime() {
    ALDateTimeField tmpDate = new ALDateTimeField("HH:mm");
    tmpDate.setValue(start_date.getValue());
    return tmpDate;
  }

  /**
   * 終了日時を取得します。
   * 
   * @return
   */
  public ALDateTimeField getEndDate() {
    return end_date;
  }

  /**
   * 終了日時を取得します。
   * 
   * @return
   */
  public ALDateTimeField getEndDateSub() {
    ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
    tmpDate.setValue(end_date.getValue());
    return tmpDate;
  }

  /**
   * 終了日時を取得します。
   * 
   * @return
   */
  public ALDateTimeField getEndDateTime() {
    ALDateTimeField tmpDate = new ALDateTimeField("HH:mm");
    tmpDate.setValue(end_date.getValue());
    return tmpDate;
  }

  /**
   * グループメンバーを取得します。
   * 
   * @return
   */
  public List<ALEipUser> getMemberList() {
    return memberList;
  }

  // add start
  /**
   * 参加必須の共有メンバーを返します。
   * 
   * @return 参加必須の共有メンバー一覧
   */
  public List<ALEipUser> getReqMemberList() {
    return reqMemberList;
  }

  /**
   * 参加任意の共有メンバーを返します。
   * 
   * @return 参加任意の共有メンバー一覧
   */
  public List<ALEipUser> getSubMemberList() {
    return subMemberList;
  }

  /**
   * 対象ユーザーを返します。
   * 
   * @return 対象ユーザー
   */
  public ALEipUser getCurrentUser() {
    return currentUser;
  }

  /**
   * 対象ユーザーの部署情報を返します。
   * 
   * @return 対象ユーザーの部署情報
   */
  public UserGroupPositionLiteBean getCurrentUserGroupPosition() {
    return currentUserGroupPosition;
  }

  // add end

  /**
   * 指定したグループ名のユーザーを取得します。
   * 
   * @param groupname
   * @return
   */
  public List<ALEipUser> getUsers(String groupname) {
    return ALEipUtils.getUsers(groupname);
  }

  /**
   * 部署マップを取得します。
   * 
   * @return
   */
  public Map<Integer, ALEipPost> getPostMap() {
    return ALEipManager.getInstance().getPostMap();
  }

  /**
   * 予定を取得します。
   * 
   * @return
   */
  public ALStringField getName() {
    return name;
  }

  /**
   * 内容を取得します。
   * 
   * @return
   */
  public ALStringField getNote() {
    return note;
  }

  /**
   * 場所を取得します。
   * 
   * @return
   */
  public ALStringField getPlace() {
    return place;
  }

  /**
   * 終了日時を取得します。
   * 
   * @return
   */
  public int getCurrentYear() {
    return currentYear;
  }

  /**
   * 
   * @return
   */
  public boolean isMember() {
    return (is_member || memberList.size() > 1);
  }

  /**
   * 
   * @return
   */
  public boolean isOwner() {
    return is_owner;
  }

  /**
   * ログインユーザを取得します。
   * 
   * @return
   */
  public ALEipUser getLoginUser() {
    // change start
    // 同一用途のフィールド変数があるため統一
    // return login_user;
    return loginUser;
    // change end
  }

  /**
   * 編集するスケジュールの1日の情報を取得します。
   * 
   * @return
   */
  public ScheduleOnedayGroupSelectData getSelectData() {
    return selectData;
  }

  /**
   * 公開/非公開フラグを取得します。
   * 
   * @return
   */
  public ALStringField getPublicFlag() {
    return public_flag;
  }

  /**
   * 繰り返すかどうか。
   * 
   * @return
   */
  public boolean isRepeat() {
    return is_repeat;
  }

  /**
   * 期間スケジュールかどうか。
   * 
   * @return
   */
  public boolean isSpan() {
    return is_span;
  }

  // add start
  /**
   * 日またぎか判定します。
   * 
   * @return 日またぎの場合true
   */
  public boolean isStraddle() {
    return is_straddle;
  }

  // add end

  // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
  /**
   * 仮の予定か判定します。
   * 
   * @return 仮の予定の場合true
   */
  public boolean isTemporary() {
    return is_temporary;
  }

  // add end

  /**
   * コピーを作るかどうか。
   * 
   * @return
   */
  public boolean isCopy() {
    return is_copy;
  }

  /**
   * 期限を取得します。
   * 
   * @return
   */
  public ALDateField getLimitStartDate() {
    return limit_start_date;
  }

  /**
   * 期限を取得します。
   * 
   * @return
   */
  public ALDateTimeField getLimitStartDateSub() {
    ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
    try {
      tmpDate.setValue(limit_start_date.getValue().getDate());
    } catch (Exception e) {
      logger.error("[ScheduleFormData]", e);

    }
    return tmpDate;
  }

  /**
   * 期限を取得します。
   * 
   * @return
   */
  public ALDateField getLimitEndDate() {
    return limit_end_date;
  }

  /**
   * 期限を取得します。
   * 
   * @return
   */
  public ALDateTimeField getLimitEndDateSub() {
    ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
    try {
      tmpDate.setValue(limit_end_date.getValue().getDate());
    } catch (Exception e) {
      logger.error("[ScheduleFormData]", e);

    }
    return tmpDate;
  }

  /**
   * 期限フラグを取得します。
   * 
   * @return
   */
  public ALStringField getLimitFlag() {
    return limit_flag;
  }

  /**
   * 終日フラグを取得します。
   * 
   * @return
   */
  public ALStringField getAllDayFlag() {
    return all_day_flag;
  }

  /**
   * 毎月繰り返す日を取得します。
   * 
   * @return
   */
  public ALNumberField getMonthDay() {
    return month_day;
  }

  /**
   * 繰り返しタイプを取得します。
   * 
   * @return
   */
  public ALStringField getRepeatType() {
    return repeat_type;
  }

  // add start
  // 日パターン
  /**
   * 日間隔を返します。
   * 
   * @return 日間隔
   */
  public ALNumberField getDayInterval() {
    return day_interval;
  }

  // 週パターン
  /**
   * 週間隔を返します。
   * 
   * @return 週間隔
   */
  public ALNumberField getWeekInterval() {
    return week_interval;
  }

  /**
   * 週パターンチェック済み曜日一覧取得
   * 
   * @return チェック済み曜日一覧（0番=日曜日、1番=月曜日...）
   */
  public List<String> getCheckedWeekDoW() {
    List<String> result = new ArrayList<String>(0);
    if (ScheduleConst.DOW_CHECKED.equals(week_dow_1.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_dow_2.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_dow_3.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_dow_4.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_dow_5.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_dow_6.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_dow_7.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    return result;
  }

  // 月パターン
  /**
   * 月パターンを返します。
   * 
   * @return 月パターン
   */
  public ALStringField getMonthType() {
    return month_type;
  }

  // 月日指定
  /**
   * 月日指定の月間隔を返します。
   * 
   * @return 月日指定の月間隔
   */
  public ALNumberField getMdMonthInterval() {
    return md_month_interval;
  }

  /**
   * 月日指定の日を返します。
   * 
   * @return 月日指定の日
   */
  public ALNumberField getMdDay() {
    return md_day;
  }

  // 月・曜日指定
  public ALNumberField getMwMonthInterval() {
    return mw_month_interval;
  }

  public ALNumberField getMwCount() {
    return mw_count;
  }

  public ALStringField getMwDoW() {
    return mw_dow;
  }

  // 年パターン
  /**
   * 年パターンを返します。
   * 
   * @return 年パターン
   */
  public ALStringField getYearType() {
    return year_type;
  }

  // 年月日指定
  public ALNumberField getYmdMonth() {
    return ymd_month;
  }

  public ALNumberField getYmdDay() {
    return ymd_day;
  }

  // 年月曜日指定
  public ALNumberField getYmwMonth() {
    return ymw_month;
  }

  public ALNumberField getYmwCount() {
    return ymw_count;
  }

  public ALStringField getYmwDoW() {
    return ymw_dow;
  }

  /**
   * 繰り返し有効期限パターンを返します。
   * 
   * @return 繰り返し有効期限パターン
   */
  public ALStringField getLimitType() {
    return limit_type;
  }

  public ALNumberField getRepeatNum() {
    return repeat_num;
  }

  // add end
  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALStringField getWeek0() {
    return week_0;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALStringField getWeek1() {
    return week_1;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALStringField getWeek2() {
    return week_2;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALStringField getWeek3() {
    return week_3;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALStringField getWeek4() {
    return week_4;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALStringField getWeek5() {
    return week_5;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALStringField getWeek6() {
    return week_6;
  }

  /**
   * グループリストを取得します。
   * 
   * @return
   */
  public List<ALEipGroup> getGroupList() {
    return groups;
  }

  /**
   * 繰り返しスケジュールの編集フラグ
   * 
   * @return
   */
  public ALNumberField getEditRepeatFlag() {
    return edit_repeat_flag;
  }

  /**
   * 共有メンバーによる編集／削除権限フラグ
   * 
   * @return
   */
  public ALStringField getEditFlag() {
    return edit_flag;
  }

  public ALStringField getChangeTmpreserveFlag() {
    return change_tmpreserve_flag;
  }

  public ALDateTimeField getViewDate() {
    return view_date;
  }

  public int getInt(long num) {
    return (int) num;
  }

  /**
   * 
   * @return
   */
  public boolean isFacility() {
    return (is_facility || facilityList.size() > 0);
  }

  public List<Object> getFacilityList() {
    return facilityList;
  }

  public List<FacilityResultData> getFacilityAllList() {
    return facilityAllList;
  }

  /**
   * 共有カテゴリ ID
   * 
   * @return
   */
  public ALNumberField getCommonCategoryId() {
    return common_category_id;
  }

  public int getMsgType() {
    return msg_type;
  }

  /**
   * 開始日時と終了日時が同じかどうか返します。
   * 
   * @return
   */
  public boolean getIsSameDate() {
    return is_same_date;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return aclPortletFeature;
  }

  // add start
  /**
   * 時刻入力形式を返す
   * 
   * @return 時刻入力形式。直接入力の場合"T"、選択入力の場合"S"
   */
  public String getTimeInputType() {
    return time_input_type;
  }

  /**
   * 第何週列挙体を返します。
   * 
   * @return 第何週列挙体の配列
   */
  public ScheduleWeekNumber[] getWeekNums() {
    return ScheduleWeekNumber.values();
  }

  /**
   * 曜日列挙体を返します。
   * 
   * @return 曜日列挙体の配列
   */
  public DayOfWeek[] getDoWs() {
    return DayOfWeek.values();
  }

  /**
   * 日種類列挙体を返します。
   * 
   * @return 日種類列挙体の配列
   */
  public DayType[] getDayTypes() {
    return DayType.values();
  }

  // スケジュール委任権限管理対応
  /*
   * アクセス権限をチェックします。 ポートレットのアクセス権限チェックを親クラスで
   * 行なわずに、本クラスで行なえるように、親クラスのメソッドをオーバーライドします。
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#doCheckAclPermission(RunData
   * rundata, Context context,int defineAclType)
   */
  @Override
  protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
    return true;
  }

  // add end

  // remove start
  // 不要なコードのため削除
  // /**
  // * アクセス権限をチェックします
  // *
  // * @return
  // */
  // protected boolean hasAclPermission(RunData rundata, Context context,
  // int defineAclType) throws ALPermissionException {
  //
  // boolean rtn = false;
  //
  // if (ALAccessControlConstants.VALUE_ACL_INSERT == defineAclType) {
  //
  // } else if (ALAccessControlConstants.VALUE_ACL_UPDATE == defineAclType) {
  //
  // } else if (ALAccessControlConstants.VALUE_ACL_DELETE == defineAclType) {
  //
  // }
  //
  // return rtn;
  // }
  // remove end

  // add start
  /**
   * オブジェクト（String、Integerに対応）が等しいかチェック
   * 
   * @param a
   *          比較オブジェクト
   * @param b
   *          比較オブジェクト
   * 
   * @return true:aとbは等しい
   * 
   */
  private boolean isSameValue(Object a, Object b) {
    if (a == null && b == null) {
      return true;
    }
    if (a != null && a.equals(b)) {
      return true;
    }
    if (b != null && b.equals(a)) {
      return true;
    }
    return false;
  }

  // add start 要件No.18 会議案内ファイル添付
  public String getFolderName() {
    return folderName;
  }

  public List<FileuploadLiteBean> getAttachmentFileNameList() {
    return fileuploadList;
  }
  // add end

}
