/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.schedule.util.ScheduleUtils;

/**
 * カレンダー用週間スケジュールのコンテナです。
 * 
 */
public class AjaxScheduleWeekContainer implements ALData {

  /** <code>dayList</code> スケジュールリスト */
  private List<AjaxScheduleDayContainer> dayList;

  /*
   * 
   */
  public void initField() {
    dayList = new ArrayList<AjaxScheduleDayContainer>();
  }

  /**
   * 表示開始する日付を設定します。
   * 
   * @param cal
   */
  public void setViewStartDate(Calendar cal) {
    for (int i = 1; i <= 7; i++) {
      // 日付を1日ずつずらす
      AjaxScheduleDayContainer con = new AjaxScheduleDayContainer();
      con.initField();
      con.setDate(cal.getTime());
      dayList.add(con);
      cal.add(Calendar.DATE, 1);
    }
  }

  /**
   * スケジュールをコンテナに格納します。
   * 
   * @param rd
   */
  public boolean addResultData(AjaxScheduleResultData rd, boolean show_all) {
    int size = dayList.size();

    for (int i = 0; i < size; i++) {
      AjaxScheduleDayContainer con = dayList.get(i);
      ALDateTimeField field = con.getDate();
      if (!rd.getPattern().equals("N")) {
        // add start
        if (rd.getPattern().equals(ScheduleConst.SCHEDULE_PATTERN_DAYS)) {
          // <繰り返しパターン>=[日またぎ] の場合
          // 開始、終了日時の再設定用変数
          // コンテナ日付の00：00
          Calendar new_start_day = Calendar.getInstance();
          new_start_day.setTime(field.getValue());
          new_start_day.set(Calendar.HOUR_OF_DAY, 0);
          new_start_day.set(Calendar.MINUTE, 0);
          new_start_day.set(Calendar.SECOND, 0);
          new_start_day.set(Calendar.MILLISECOND, 0);
          // コンテナ日付の23：59
          Calendar new_end_day = Calendar.getInstance();
          new_end_day.setTime(field.getValue());
          new_end_day.set(Calendar.HOUR_OF_DAY, 23);
          new_end_day.set(Calendar.MINUTE, 59);
          new_end_day.set(Calendar.SECOND, 0);
          new_end_day.set(Calendar.MILLISECOND, 0);

          // rdの日付をカレンダー型に変換
          Calendar rd_start_day = Calendar.getInstance();
          rd_start_day.setTime(rd.getStartDate().getValue());
          rd_start_day.set(Calendar.HOUR_OF_DAY, 0);
          rd_start_day.set(Calendar.MINUTE, 0);
          rd_start_day.set(Calendar.SECOND, 0);
          rd_start_day.set(Calendar.MILLISECOND, 0);
          Calendar rd_end_day = Calendar.getInstance();
          rd_end_day.setTime(rd.getEndDate().getValue());
          rd_end_day.set(Calendar.HOUR_OF_DAY, 0);
          rd_end_day.set(Calendar.MINUTE, 0);
          rd_end_day.set(Calendar.SECOND, 0);
          rd_end_day.set(Calendar.MILLISECOND, 0);

          AjaxScheduleResultData rd3 = new AjaxScheduleResultData();

          rd3.initField();
          // スケジュールID
          rd3.setScheduleId((int) rd.getScheduleId().getValue());
          // 親ID
          rd3.setParentId((int) rd.getParentId().getValue());
          // スケジュール名
          rd3.setName(rd.getName().getValue());
          // 場所
          rd3.setPlace(rd.getPlace().getValue());
          // 仮スケジュールか
          rd3.setTmpreserve(rd.isTmpreserve());
          // 公開か
          rd3.setPublic(rd.isPublic());
          // 表示/非表示か
          rd3.setHidden(rd.isHidden());
          // ダミーか
          rd3.setDummy(rd.isDummy());
          // ログインユーザーか
          rd3.setLoginuser(rd.isLoginuser());
          // オーナーか
          rd3.setOwner(rd.isOwner());
          // 共有メンバーの更新が可能か
          rd3.setEditFlag(rd.isEditable());
          // メンバーか
          rd3.setMember(rd.isMember());
          // ユーザー/施設
          rd3.setType(rd.getType());
          // 所有者
          rd3.setUserId(rd.getUserId());
          // 参加メンバー一覧
          rd3.setMemberList(rd.getMemberList());

          // 状態
          rd3.setStatus(rd.getStatus());
          // 必須フラグ
          rd3.setRequired(rd.getRequired());
          // 重要フラグ
          rd3.setPriority(rd.getPriority());
          // 作成ユーザーID
          rd3.setCreateUserId(rd.getCreateUserId());
          // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
          rd3.setTemporaryFlag(rd.getTemporaryFlag());
          // add end
          // add start 要件No.18 会議案内ファイル添付
          rd3.setFiles(rd.hasFiles());
          // add end
          // add start 要件No.26 スケジュール個別色換え
          rd3.setIndividualColor(rd.getIndividualColor());
          // add end
          // add start 結合試験障害16-01対応
          rd3.setOrganizer(rd.isOrganizer());
          // add end
          if (rd_start_day.equals(new_start_day)) {
            // 開始日時の年月日付=コンテナ年月日付 の場合
            rd3.setStartDate(rd.getStartDate().getValue());
            // 終了日時を再設定用日付に設定し直す
            rd3.setEndDate(new_end_day.getTime());
            rd3.setStraddleLocation(AjaxScheduleResultData.STRADDLE_LOC_START);
            con.addResultData(rd3, show_all);
          } else if (rd_start_day.before(new_start_day) && new_start_day.before(rd_end_day)) {
            // "開始日時の年月日付＜コンテナ年月日付" かつ "終了日時の年月日付＞コンテナ年月日付の場合"
            // 開始日時を再設定用日付に設定し直す
            rd3.setStartDate(new_start_day.getTime());
            // 終了日時を再設定用日付に設定し直す
            rd3.setEndDate(new_end_day.getTime());
            rd3.setStraddleLocation(AjaxScheduleResultData.STRADDLE_LOC_MIDDLE);
            con.addResultData(rd3, show_all);
          } else if (rd_end_day.equals(new_start_day)) {
            // 終了日時の年月日付=コンテナ年月日付 の場合
            // 開始日時を再設定用日付に設定し直す
            rd3.setStartDate(new_start_day.getTime());
            rd3.setEndDate(rd.getEndDate().getValue());
            rd3.setStraddleLocation(AjaxScheduleResultData.STRADDLE_LOC_END);
            con.addResultData(rd3, show_all);
          }
        } else {
          // add end
          // 繰り返しスケジュール
          if (ScheduleUtils.isView(con.getDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
            Calendar temp = Calendar.getInstance();
            temp.setTime(field.getValue());
            temp.set(Calendar.HOUR_OF_DAY, Integer.parseInt(rd.getStartDate().getHour()));
            temp.set(Calendar.MINUTE, Integer.parseInt(rd.getStartDate().getMinute()));
            temp.set(Calendar.SECOND, 0);
            temp.set(Calendar.MILLISECOND, 0);
            Calendar temp2 = Calendar.getInstance();
            temp2.setTime(field.getValue());
            temp2.set(Calendar.HOUR_OF_DAY, Integer.parseInt(rd.getEndDate().getHour()));
            temp2.set(Calendar.MINUTE, Integer.parseInt(rd.getEndDate().getMinute()));
            temp2.set(Calendar.SECOND, 0);
            temp2.set(Calendar.MILLISECOND, 0);
            AjaxScheduleResultData rd3 = new AjaxScheduleResultData();
            rd3.initField();
            rd3.setScheduleId((int) rd.getScheduleId().getValue());
            rd3.setParentId((int) rd.getParentId().getValue());
            rd3.setName(rd.getName().getValue());
            rd3.setPlace(rd.getPlace().getValue());
            // 開始日を設定し直す
            rd3.setStartDate(temp.getTime());
            // 終了日を設定し直す
            rd3.setEndDate(temp2.getTime());
            rd3.setTmpreserve(rd.isTmpreserve());
            rd3.setPublic(rd.isPublic());
            rd3.setHidden(rd.isHidden());
            rd3.setDummy(rd.isDummy());
            rd3.setLoginuser(rd.isLoginuser());
            rd3.setOwner(rd.isOwner());
            rd3.setEditFlag(rd.isEditable());
            rd3.setMember(rd.isMember());
            rd3.setType(rd.getType());
            // 繰り返しはON
            rd3.setRepeat(true);
            rd3.setUserId(rd.getUserId());
            rd3.setMemberList(rd.getMemberList());

            // add start
            // 状態
            rd3.setStatus(rd.getStatus());
            // 必須フラグ
            rd3.setRequired(rd.getRequired());
            // 重要フラグ
            rd3.setPriority(rd.getPriority());
            // 作成ユーザーID
            rd3.setCreateUserId(rd.getCreateUserId());
            // add end
            // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
            rd3.setTemporaryFlag(rd.getTemporaryFlag());
            // add end
            // add start 要件No.18 会議案内ファイル添付
            rd3.setFiles(rd.hasFiles());
            // add end
            // add start 要件No.26 スケジュール個別色換え
            rd3.setIndividualColor(rd.getIndividualColor());
            // add end
            // add start 結合試験障害16-01対応
            rd3.setOrganizer(rd.isOrganizer());
            // add end
            con.addResultData(rd3, show_all);
          }
        }
      } else if (field.getYear().equals(rd.getStartDate().getYear())
        && field.getMonth().equals(rd.getStartDate().getMonth())
        && field.getDay().equals(rd.getStartDate().getDay())) {
        con.addResultData(rd, show_all);
        return true;
      }
    }
    return false;
  }

  /**
   * スケジュールリストを取得します。
   * 
   * @return
   */
  public List<AjaxScheduleDayContainer> getDayList() {
    return dayList;
  }

}
