/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.ArrayList;
import java.util.List;

import net.sf.json.JSONObject;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.schedule.ScheduleOneDayJSONFormData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 1日スケジュールを処理するクラスです。
 * 
 */
public class ScheduleOneDayJSONScreen extends ALJSONScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleOneDayJSONScreen.class.getName());

  @Override
  protected String getJSONString(RunData rundata, Context context) throws Exception {
    List<String> errList = new ArrayList<String>(0);
    String mode = this.getMode();
    JSONObject json = new JSONObject();
    ALEipUser loginUser = null;

    try {
      loginUser = ALEipUtils.getALEipUser(rundata);

      ScheduleOneDayJSONFormData formData = new ScheduleOneDayJSONFormData();
      formData.init(this, rundata, context);
      if (ALEipConstants.MODE_INSERT.equals(mode)) {
        try {
          // 予定新規追加処理
          formData.loadParameters(rundata, context, errList);
          if (formData.doInsert(this, rundata, context)) {
          } else {
            errList = formData.getMsgList();
          }
        } catch (Exception e) {
          logger.error("予定の新規追加に失敗しました。ログインユーザー：" + loginUser.getName(), e);
        }
      } else if (ALEipConstants.MODE_UPDATE.equals(mode)) {
        // 予定更新処理
        try {
          formData.loadParameters(rundata, context, errList);
          if (formData.doUpdate(this, rundata, context)) {
          } else {
            errList = formData.getMsgList();
          }
        } catch (Exception e) {
          logger.error("予定の更新に失敗しました。ログインユーザー：" + loginUser.getName() + "/スケジュールID：" + rundata.getParameters().getInt(ALEipConstants.ENTITY_ID), e);
        }
      }

      return formData.doViewList(this, rundata, context, errList);
    } catch (Exception e) {
      logger.error("１日スケジュール予定表示にて、予定取得に失敗しました。ログインユーザー:" + loginUser.getName(), e);
      errList.add(0, "FatalError");
      errList.add("表示内容の更新が異常終了しました。再度更新ボタンを押下して下さい。");
      json.put("errList", errList);
      return json.toString();
    }
  }
}
